;CAN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 10, 2005		1.00		Initial release
*
*Author: Exequiel Rarama for the Adapt9S12C32
*******************************************************************************

;Compiled using Codewarrior
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

;C32regs.INC CONTAINS ALL REGISTERS
	include "C32Regs.INC"

;Public Function
	
	XDEF CANInit
	XDEF CANSend
	XDEF CANReceive

;External Function

	XREF OutStr0

DataSec:SECTION
canbuffer	ds	16	;
txbuffer	ds	9	;Transmit buffer
rxbuffer	ds	9	;Receive buffer

length		ds	1	;Lenght
extended	ds	1	;

identlow	ds	2	;Low byte
identhigh	ds	2	;High byte

RXFRM		equ	%10000000	;Received Frame Flag
CANE		equ	%10000000	;MSCAN enable bit
RXF		equ	%00000001	;Receive Buffer Full Flag
RXFIE		equ	%00000001	;Receive Buffer Full enable interrupt Flag
INITRQ		equ	%00000001	;Initialize request

NON_BANKED:SECTION


CANInit
	movb	#$00,CANIDAR0+0	; Setup filter
	movb	#$ff,CANIDMR0+0	; Setup mask

	movb	#$00,CANIDAR0+1	; Setup filter
	movb	#$ff,CANIDMR0+1	; Setup mask

	movb	#$00,CANIDAR0+2	; Setup filter
	movb	#$ff,CANIDMR0+2	; Setup mask

	movb	#$00,CANIDAR0+3	; Setup filter
	movb	#$ff,CANIDMR0+3	; Setup mask

	movb	#$00,CANIDAR4+0	; Setup filter
	movb	#$ff,CANIDMR4+0	; Setup mask

	movb	#$00,CANIDAR4+1	; Setup filter
	movb	#$ff,CANIDMR4+1	; Setup mask

	movb	#$00,CANIDAR4+2	; Setup filter
	movb	#$ff,CANIDMR4+2	; Setup mask

	movb	#$00,CANIDAR4+3	; Setup filter
	movb	#$ff,CANIDMR4+3	; Setup mask

	movb	#$03,CANBTR0	; Setup prescaler for Tq (16xTq=bit-time); SJW = 1 Tq
	movb	#$3A,CANBTR1	; 1 Sample, 16 Tq (bit-time), with sample point at 12

	movb	#$10,CANIDAC	; Setup acceptance filter-arrangement
	movb	#CANE,CANCTL1	; Enable CAN and use XTAL (not PLL)

	bclr	CANCTL0,INITRQ	; leave initialization mode

;These routines must happen after INITRQ in CANCTL0 is cleared

	bset	CANCTL0,RXFRM	;Clear Flag
	movb	#RXF,CANRFLG	; free up RXFG buffer for next message
	bset	CANRIER,RXFIE	;Enable Receive interrupt

	movb	#0,txbuffer+8	; Add termination
	movb	#0,rxbuffer+8	; Add termination

;	jsr	FlushCANBuff
	rts


;----------------------------------------------------------------------------------------
CANSend
	movb	CANTFLG,CANTBSEL	;Choose which buffer to transmit
	movb	#$0,CANTXFG+$0D	; Set priority of message

	movw	#$0800,CANTXFG	; Fill IDR0,1
	movb	#$8,CANTXFG+$0C	; Set length of message

	ldx	#txbuffer	; Setup source ptr
	ldy	#CANTXFG+$04 	; Setup dest ptr in TXFG memory
	ldab	#$4		; Number of words

	movb	#'C',txbuffer+0	; C
	movb	#'A',txbuffer+1	; A
	movb	#'N',txbuffer+2	; N
	movb	#'T',txbuffer+3	; T
	movb	#'e',txbuffer+4	; e
	movb	#'s',txbuffer+5	; s
	movb	#'t',txbuffer+6	; t
	movb	#'x',txbuffer+7	; x


CANSend10
	movw	2,X+,2,Y+	; Copy dataword
	dbne	B,CANSend10	; Another word?

	movb	CANTBSEL,CANTFLG	;transmit message now
	rts


;----------------------------------------------------------------------------------------
CANReceive
	brclr	CANCTL0,RXFRM,*	;Check to see if valid Frame is received

	ldy	#canbuffer	; Setup dest ptr
	ldx	#CANRXFG	; Setup source ptr in RXFG memory
	ldab	#$8		; Number of words **************************

CANReceive10
	movw	2,X+,2,Y+	; Copy dataword
	dbne	B,CANReceive10	; Another word?

	clrb					; assume standard ident length
	brclr	CANRXFG+1,$08,CANReceive20	; check if IDE=0

	ldab	#$1		; extended message identifier

CANReceive20
	bset	CANCTL0,RXFRM	;Clear Flag

	staa	length		; return length of message
	stab	extended		; return 1 if extended (0 otherwise)

;Extract DATA
	ldx	#canbuffer+4	; Setup source ptr to data in CanBuffer
	ldy	#rxbuffer	; Setup dest ptr for data
	ldab	#$8		; Number of bytes

CANReceive30
	movb	1,X+,1,Y+	; Copy databyte
	dbne	B,CANReceive30	; Another byte?

	ldx	#rxbuffer
	jsr	OutStr0

	movb	#RXF,CANRFLG	; free up RXFG buffer for next message

	movb	#0,rxbuffer+8	; Add termination
	rti


;--------------------------------------------------------------------------
FlushCANBuff
	ldy	#canbuffer	; Setup dest ptr
	ldx	#CANRXFG	; Setup source ptr in RXFG memory
	ldab	#$8		; Number of words **************************

FlushCANBuff10
	movw	2,X+,2,Y+	; Copy dataword
	dbne	B,FlushCANBuff10	; Another word?

	bset	CANCTL0,RXFRM	;Clear Flag
	movb	#RXF,CANRFLG	; free up RXFG buffer for next message
	rts


	END