;HardwareTest.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 10, 2005		1.00		Initial release
*
*Author: Exequiel Rarama for the Adapt9S12C32
*******************************************************************************

;Compiled using Codewarrior
;
; ---------------------------
; Demo - HardwareTest Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF HardwareTestGo
	XDEF HardwareTestInit
	XDEF HardwareReady

;Public Variables
	XDEF hardware_state
	XDEF testFlag

;Public Tones

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF SendDecByte		;Hex to Decimal conversion


;External Variables

	XREF adflag

DataSec:SECTION
Var		ds	3
hardware_state	ds	2
count		ds	1
Error		ds	1
testFlag	ds	1
PassFailFlag	ds	1
;

PUPAE		equ	%00000001		;Port A pullup
PUPBE		equ	%00000010
PUPEE		equ	%00010000
PUPKE		equ	%10000000

switch		equ	%01000000		;Port A bit 6

;***********************************************************************************************
NON_BANKED:SECTION
;
HardwareTestInit				;Testing the Hardware ports
	bset	PUCR,PUPAE+PUPBE+PUPEE+PUPKE	;Enable all pull up's

	movb	#$FF,PERT
	movb	#$FF,PERS
	movb	#$FF,PERM
	movb	#$FF,PERP
	movb	#$FF,PERJ
	movb	#$FF,PERAD

	movw	#HardwareReady,hardware_state
	clr	testFlag
	clr	PassFailFlag

goEx
	rts

HardwareReady
	rts


HardwareTestGo
	movw	#WaitForChar,hardware_state
;	ldx	#WarningMSG1
;	jsr	OutStr0

	ldx	#WarningMSG2
	jsr	OutStr0
	movb	#1,testFlag

	clr	PassFailFlag
	rts

WaitForChar
	ldaa	testFlag
	bne	WaitForCharEx

	movw	#HardwareTestADT,hardware_state
WaitForCharEx
	rts

;----------------------------------------------------------------------------------------------
HardwareTestADT

;Make all ports inputs
;Note: Port A,B,E do not have dedicated Input Port register

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T
	movb	#$00,ATDDIEN1	;Port AD

;Initialize Analog To Digital
	movb	#$00,ATDCTL2	        ;enable ATD
	movb	#$00,ATDCTL3	        ;8 Channels ATD result
	movb	#$00,ATDCTL4		;Select Sample rate
	movb	#$00,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#1,adflag

;Start checking on Port AD driving T
	ldx	#TestMSG1
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRAD	;make Port AD o/p
	movb	#$00,DDRT	;make Port T i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortT20

CheckPortT10
	lsl	Var

CheckPortT20
	dec	Var+1
	beq	CheckPortTDone

	movb	Var,PTAD
	movb	Var,PTAD

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTT
	ldab	PORTT
	cmpb	Var
	beq	CheckPortT10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTT
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortT10	;Go continue the test

CheckPortTDone
	ldaa	Error
	beq	CheckPortTDoneEx10

	ldx	#Error1
	jsr	OutStr0
	bra	CheckPortTDoneEx

CheckPortTDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortTDoneEx
	movw	#HardwareTestTAD,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestTAD

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T
	movb	#$FF,ATDDIEN1		;Enable ATD channel as Digital input

;Start checking on Port T driving AD

	ldx	#TestMSG2
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRT	;make Port T o/p
	movb	#$00,DDRAD	;make Port ADL i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortAD20

CheckPortAD10
	lsl	Var

CheckPortAD20
	dec	Var+1
	beq	CheckPortADDone

	movb	Var,PORTT
	movb	Var,PORTT

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PTAD
	ldab	PTAD

	cmpb	Var
	beq	CheckPortAD10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PTAD
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortAD10	;Go continue the test

CheckPortADDone
	ldaa	Error
	beq	CheckPortADDoneEx10

	ldx	#Error2
	jsr	OutStr0
	bra	CheckPortADDoneEx

CheckPortADDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortADDoneEx
;	movb	#$80,ATDCTL2	        ;enable ATD
;	movb	#$40,ATDCTL3	        ;8 Channels ATD result
;	movb	#$60,ATDCTL4		;Select Sample rate
;	movb	#$B0,ATDCTL5		;Select 8 channel mode, Continuous scan
;	movb	#$00,ATDDIEN1		;Disable ATD channel as Digital input
;	clr	adflag

	movw	#HardwareTestAB,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestAB

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port A driving Port B

	ldx	#TestMSG3
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRA	;make Port A o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortB20

CheckPortB10
	lsl	Var

CheckPortB20
	dec	Var+1
	beq	CheckPortBDone

	movb	Var,PORTA
	movb	Var,PORTA

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTB
	ldab	PORTB

	cmpb	Var
	beq	CheckPortB10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTB
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortB10	;Go continue the test

CheckPortBDone
	ldaa	Error
	beq	CheckPortBDoneEx10

	ldx	#Error3
	jsr	OutStr0
	bra	CheckPortBDoneEx

CheckPortBDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortBDoneEx
	movw	#HardwareTestBA,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestBA
	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port B driving Port A

	ldx	#TestMSG4
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRB	;make Port B o/p
	movb	#$00,DDRA	;make Port A i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortA20

CheckPortA10
	lsl	Var

CheckPortA20
	dec	Var+1
	beq	CheckPortADone

	movb	Var,PORTB
	movb	Var,PORTB

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTA
	ldab	PORTA

	cmpb	Var
	beq	CheckPortA10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTA
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortA10	;Go continue the test

CheckPortADone
	ldaa	Error
	beq	CheckPortADoneEx10

	ldx	#Error4
	jsr	OutStr0
	bra	CheckPortADoneEx

CheckPortADoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortADoneEx
	movw	#HardwareTestTP,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestTP
	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port T driving Port P

	ldx	#TestMSG5
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRT	;make Port T o/p
	movb	#$00,DDRP	;make Port P i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortP20

CheckPortP10
	lsl	Var

CheckPortP20
	dec	Var+1
	beq	CheckPortPDone

	movb	Var,PORTT
	movb	Var,PORTT

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTP
	cmpb	Var
	beq	CheckPortP10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTP
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortP10	;Go continue the test

CheckPortPDone
	ldaa	Error
	beq	CheckPortPDoneEx10

	ldx	#Error5
	jsr	OutStr0
	bra	CheckPortPDoneEx

CheckPortPDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortPDoneEx
	movw	#HardwareTestPT,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestPT

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port P driving Port T

	ldx	#TestMSG6
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRP	;make Port P o/p
	movb	#$00,DDRT	;make Port T i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortTT20

CheckPortTT10
	lsl	Var

CheckPortTT20
	dec	Var+1
	beq	CheckPortTTDone

	movb	Var,PORTP
	movb	Var,PORTP

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTT
	cmpb	Var

	beq	CheckPortTT10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTT
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortTT10	;Go continue the test

CheckPortTTDone
	ldaa	Error
	beq	CheckPortTTDoneEx10

	ldx	#Error6
	jsr	OutStr0
	bra	CheckPortTTDoneEx

CheckPortTTDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortTTDoneEx
	movw	#HardwareTestAM,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestAM

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port A driving Port M

	ldx	#TestMSG7
	jsr	OutStr0

	clr	Error

	movb	#%00111100,DDRA	;make Port A o/p
	movb	#$00,DDRM	;make Port M i/p

	movb	#4,Var		;Initialize to 1st bit
	movb	#5,Var+1	;Initialize counter	
	bra	CheckPortM20

CheckPortM10
	lsl	Var

CheckPortM20
	dec	Var+1
	beq	CheckPortMDone

	movb	Var,PORTA
	movb	Var,PORTA

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTM
	ldab	PORTM
	andb	#%00111100

	cmpb	Var
	beq	CheckPortM10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTM
	andb	#%00111100
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortM10	;Go continue the test

CheckPortMDone
	ldaa	Error
	beq	CheckPortMDoneEx10

	ldx	#Error7
	jsr	OutStr0
	bra	CheckPortMDoneEx

CheckPortMDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortMDoneEx
	movw	#HardwareTestMA,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestMA

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port A driving Port M

	ldx	#TestMSG8
	jsr	OutStr0

	clr	Error

	movb	#%00111100,DDRM	;make Port M o/p
	movb	#$00,DDRA	;make Port A i/p

	movb	#4,Var		;Initialize to 1st bit
	movb	#5,Var+1	;Initialize counter	
	bra	CheckPortAA20

CheckPortAA10
	lsl	Var

CheckPortAA20
	dec	Var+1
	beq	CheckPortAADone

	movb	Var,PORTM
	movb	Var,PORTM

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTA
	ldab	PORTA
	andb	#%00111100

	cmpb	Var
	beq	CheckPortAA10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTA
	andb	#%00111100
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortAA10	;Go continue the test

CheckPortAADone
	ldaa	Error
	beq	CheckPortAADoneEx10

	ldx	#Error8
	jsr	OutStr0
	bra	CheckPortAADoneEx

CheckPortAADoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortAADoneEx
	movw	#HardwareTestJT,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestJT

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port J driving Port T

	ldx	#TestMSG9
	jsr	OutStr0

	clr	Error

	movb	#%11000000,DDRJ	;make Port J o/p
	movb	#$00,DDRT	;make Port T i/p

	movb	#$40,Var		;Initialize to 1st bit
	movb	#3,Var+1	;Initialize counter	
	bra	CheckPortTTT20

CheckPortTTT10
	lsl	Var

CheckPortTTT20
	dec	Var+1
	beq	CheckPortTTTDone

	movb	Var,PORTJ
	movb	Var,PORTJ

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTT
	ldab	PORTT
	andb	#%11000000

	cmpb	Var
	beq	CheckPortTTT10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTT
	andb	#%11000000
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortTTT10	;Go continue the test

CheckPortTTTDone
	ldaa	Error
	beq	CheckPortTTTDoneEx10

	ldx	#Error9
	jsr	OutStr0
	bra	CheckPortTTTDoneEx

CheckPortTTTDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortTTTDoneEx
	movw	#HardwareTestTJ,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestTJ

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port T driving Port J

	ldx	#TestMSG10
	jsr	OutStr0

	clr	Error

	movb	#%11000000,DDRT	;make Port T o/p
	movb	#$00,DDRJ	;make Port J i/p

	movb	#$40,Var		;Initialize to 1st bit
	movb	#3,Var+1	;Initialize counter	
	bra	CheckPortJ20

CheckPortJ10
	lsl	Var

CheckPortJ20
	dec	Var+1
	beq	CheckPortJDone

	movb	Var,PORTT
	movb	Var,PORTT

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTJ
	ldab	PORTJ
	andb	#%11000000

	cmpb	Var
	beq	CheckPortJ10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTJ
	andb	#%11000000
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortJ10	;Go continue the test

CheckPortJDone
	ldaa	Error
	beq	CheckPortJDoneEx10

	ldx	#Error10
	jsr	OutStr0
	bra	CheckPortJDoneEx

CheckPortJDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortJDoneEx
	movw	#HardwareTestEB,hardware_state
	rts


;---------------------------------------------------------------------------------------------
HardwareTestEB

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port E bit 2,3,4 driving Port B bit  2,3,4

	ldx	#TestMSG11
	jsr	OutStr0

	clr	Error

	movb	#%00011100,DDRE	;make Port E o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#4,Var		;Initialize to 1st bit
	movb	#4,Var+1	;Initialize counter	
	bra	CheckPortBB20

CheckPortBB10
	lsl	Var

CheckPortBB20
	dec	Var+1
	beq	CheckPortBBDone

	movb	Var,PORTE
	movb	Var,PORTE

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTB
	ldab	PORTB
	andb	#%00011100

	cmpb	Var
	beq	CheckPortBB10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTB
	andb	#%00011100
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortBB10	;Go continue the test

CheckPortBBDone
	ldaa	Error
	beq	CheckPortBBDoneEx10

	ldx	#Error11
	jsr	OutStr0
	bra	CheckPortBBDoneEx

CheckPortBBDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortBBDoneEx
	movw	#HardwareTestBE,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestBE

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port B bit 0,1,2,3,4 driving Port E bit 0,1,2,3,4

	ldx	#TestMSG12
	jsr	OutStr0

	clr	Error

	movb	#%00011111,DDRB	;make Port B o/p
	movb	#$00,DDRE	;make Port E i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#6,Var+1	;Initialize counter	
	bra	CheckPortE20

CheckPortE10
	lsl	Var

CheckPortE20
	dec	Var+1
	beq	CheckPortEDone

	movb	Var,PORTB
	movb	Var,PORTB

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE
	ldab	PORTE
	andb	#%00011111

	cmpb	Var
	beq	CheckPortE10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTE
	andb	#%00011111
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortE10	;Go continue the test

CheckPortEDone
	ldaa	Error
	beq	CheckPortEDoneEx10

	ldx	#Error12
	jsr	OutStr0
	bra	CheckPortEDoneEx

CheckPortEDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortEDoneEx
	movw	#HardwareTestE7B,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestE7B

	movb	#$00,DDRA	;Port A
	movb	#$00,DDRB	;Port B
	movb	#$00,DDRE	;Port E
	movb	#$00,DDRJ	;Port J
	movb	#$00,DDRM	;Port M
	movb	#$00,DDRP	;Port P
	movb	#$00,DDRS	;Port S
	movb	#$00,DDRT	;Port T

;Start checking on Port E bit 7 driving Port B bit  7

	ldx	#TestMSG13
	jsr	OutStr0

	clr	Error

	movb	#%10000000,DDRE	;make Port E o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#$80,Var		;Initialize to 1st bit
	movb	#2,Var+1	;Initialize counter	
	bra	CheckPortBBB20

CheckPortBBB10
	lsl	Var

CheckPortBBB20
	dec	Var+1
	beq	CheckPortBBBDone

	movb	Var,PORTE
	movb	Var,PORTE

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTB
	ldab	PORTB
	andb	#%10000000

	cmpb	Var
	beq	CheckPortBBB10

	ldx	#ErrorSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#ErrorReceive
	jsr	OutStr0

	ldab	PORTB
	andb	#%10000000
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortBBB10	;Go continue the test

CheckPortBBBDone
	ldaa	Error
	beq	CheckPortBBBDoneEx10

	ldx	#Error13
	jsr	OutStr0
	bra	CheckPortBBBDoneEx

CheckPortBBBDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortBBBDoneEx

;---------------------------------------------------------------------------------------------
;ExitB
;	ldaa	Error
;	bne	ExitTest
;
;	ldx	#TestMSGPass
;	jsr	OutStr0

ExitTest
	ldaa	PassFailFlag	;Error increment flag
	beq	ExitTest10

	ldx	#HardwareFailed
	jsr	OutStr0
	bra	ExitTest20

ExitTest10
	ldx	#HardwarePass
	jsr	OutStr0

ExitTest20
	movw	#HardwareReady,hardware_state
	ldx	#WarningMSG3
	jsr	OutStr0
	rts


littleDelay
	pshb	
	clrb
	dbne	b,*           ;delay to allow sw pin to pull up
	pulb
	rts

;----------------------------------------------------------------------------------------------
WarningMSG1	dc.b	'Remove Jumper JB3',$D,$A
WarningMSG2	dc.b	'Press Any Key when READY',$D,$A,0
WarningMSG3	dc.b	$D,$A,'Press RESET when DONE',$D,$A,0

HardwareFailed	dc.b	$D,$A,'Port TEST = FAILED',$D,$A,0
HardwarePass	dc.b	$D,$A,'Port TEST = PASS',$D,$A,0
TestMSGPass	dc.b	'Pass',$D,$A,0
ErrorSent	dc.b	$D,$A,'Sent    ',0
ErrorReceive	dc.b	$D,$A,'Receive ',0

;------------------------------------------------------------------------------
TestMSG1	dc.b	$D,$A,'Test ->Port AD driving Port T',$D,$A,0
TestMSG2	dc.b	$D,$A,'Test ->Port T driving Port AD',$D,$A,0

TestMSG3	dc.b	$D,$A,'Test ->Port A driving Port B',$D,$A,0
TestMSG4	dc.b	$D,$A,'Test ->Port B driving Port A',$D,$A,0

TestMSG5	dc.b	$D,$A,'Test ->Port T driving Port P',$D,$A,0
TestMSG6	dc.b	$D,$A,'Test ->Port P driving Port T',$D,$A,0

TestMSG7	dc.b	$D,$A,'Test ->Port A bit 2,3,4,5 driving Port M bit 2,3,4,5',$D,$A,0
TestMSG8	dc.b	$D,$A,'Test ->Port M bit 2,3,4,5 driving Port A bit 2,3,4,5',$D,$A,0

TestMSG9	dc.b	$D,$A,'Test ->Port J bit 6 and 7 driving Port T bit 6 and 7',$D,$A,0
TestMSG10	dc.b	$D,$A,'Test ->Port T bit 6 and 7 driving Port J bit 6 and 7',$D,$A,0

TestMSG11	dc.b	$D,$A,'Test ->Port E bit 2,3 and 4 driving Port B bit 2,3 and 4',$D,$A,0
TestMSG12	dc.b	$D,$A,'Test ->Port B bit 0,1,2,3 and 4 driving Port E bit 0,1,2,3 and 4',$D,$A,0

TestMSG13	dc.b	$D,$A,'Test ->Port E bit 7 driving Port B bit 7',$D,$A,0

;------------------------------------------------------------------------------
Error1		dc.b	$D,$A,'Fail ->Port AD driving Port T on H1',$D,$A,0
Error2		dc.b	$D,$A,'Fail ->Port T driving Port AD on H1',$D,$A,0

Error3		dc.b	$D,$A,'Fail ->Port A driving Port B',$D,$A,0
Error4		dc.b	$D,$A,'Fail ->Port B driving Port A',$D,$A,0

Error5		dc.b	$D,$A,'Fail ->Port T driving Port P',$D,$A,0
Error6		dc.b	$D,$A,'Fail ->Port P driving Port T',$D,$A,0

Error7		dc.b	$D,$A,'Fail ->Port A bit 2,3,4,5 driving Port M bit 2,3,4,5',$D,$A,0
Error8		dc.b	$D,$A,'Fail ->Port M bit 2,3,4,5 driving Port A bit 2,3,4,5',$D,$A,0

Error9		dc.b	$D,$A,'Fail ->Port J bit 6 and 7 driving Port T bit 6 and 7',$D,$A,0
Error10		dc.b	$D,$A,'Fail ->Port T bit 6 and 7 driving Port J bit 6 and 7',$D,$A,0

Error11		dc.b	$D,$A,'Fail ->Port E bit 2,3 and 4 driving Port B bit 2,3 and 4',$D,$A,0
Error12		dc.b	$D,$A,'Fail ->Port B bit 0,1,2,3 and 4 driving Port E bit 0,1,2,3 and 4',$D,$A,0

Error13		dc.b	$D,$A,'Fail ->Port E bit 7 driving Port B bit 7',$D,$A,0


	END
