;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 10, 2005		1.00		Initial release
*
*Author: Exequiel Rarama for the Adapt9S12C32
*******************************************************************************
;Compiled using Codewarrior
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

;C32regs.INC CONTAINS ALL REGISTERS
	include "C32Regs.INC"

;Public Function
	XDEF ResetFunc
	XDEF delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

	XDEF state
	XDEF state_timer

;External Function
	XREF RealTimeInit
	XREF audio_init

	XREF ShowAnalog
	XREF ProcessCommand

	XREF ShowMenu
	XREF set_audio

	XREF go_power
	XREF HardwareTestInit

	XREF SerInputInt0
	XREF RealTimeInt
	XREF audio_int

	XREF goReady

	XREF CANInit
	XREF CANReceive

;External Tones
	XREF pwr_on_tone
	XREF Ftone

;External Variables
	XREF audio_state
	XREF hardware_state


*  Operational Parameters
*  Operational Parameters

RAM		equ	$2000		;9S12E128 internal RAM
STACK		equ	$3F80		;Stack at below Ubug12
FLASH		equ	$4000		;Flash start address

OscFreq		equ	8000		;Enter Osc speed
initSYNR	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV	equ	$00		;
PLLSEL		equ	%10000000	;PLL select bit
LOCK		equ	%00001000	;lock status bit
PLLON		equ	%01000000	;phase lock loop on bit
LED		equ	%00000001	;Port P bit 0

DataSec:SECTION

* System Variables

state		ds	2
state_timer	ds	2

COMMAND		ds	1		;used by ProcessCommand
COMMAND_PENDING	ds	1		;used by ProcessCommand
CONTINUOUS	ds	1		;flag for real-time a/d screen update

***************************** Program *******************************

NON_BANKED:SECTION

ResetFunc				;This is where the RESET vector points to
	sei				;Disable Any interrupts

	movb	#$00,INITRG		;set registers at $0000 
	movb	#$39,INITRM		;move and set ram to end at $3fff 

;Initialize Stack
	lds	#STACK			;initialize stack pointer

; Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider

	nop
	nop
	nop
	nop

	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system

	jsr	go_power		;
	jsr	RealTimeInit		;Initialize SCI and RTI

	jsr	audio_init		;Initialize bit 0 of PORTP as audio o/p
	jsr	HardwareTestInit	;Initialize for Hardware Checking
	jsr	CANInit

	clr	COMMAND_PENDING
	clr	CONTINUOUS

	cli				;unmask interrupts
	jsr	ShowMenu


;------------------------------------------------------------------------------
main					;Main Loop
	jsr	ProcessCommand		;this is the program loop
	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont
	ldx	state			;Process state command
	jsr	0,x

	ldx	hardware_state		;Go check hardware
	jsr	0,x

	ldx	audio_state		;Process audio command
	jsr	0,x

	bra	main


;------------------------------------------------------------------------------
;small delay
delay
	pshy
	ldy	#0

dly
	dbne	y,dly			;decrement y counter
	puly
	rts


	ldd	 #VECTOR63  ;*****Do not delete****

VectorTable	equ	$F780

         org    VectorTable

Vector:SECTION
VECTOR63	dc.w	ResetFunc          	;Reserve
VECTOR62	dc.w	ResetFunc          	;Reserve
VECTOR61	dc.w	ResetFunc          	;Reserve
VECTOR60	dc.w	ResetFunc         	;Reserve
VECTOR59	dc.w	ResetFunc         	;Reserve
VECTOR58	dc.w	ResetFunc       	;VREG LVI
VECTOR57	dc.w	ResetFunc       	;PWM Emergency Shutdown
VECTOR56	dc.w	ResetFunc 		;Port P

VECTOR55	dc.w	ResetFunc		;Reserved
VECTOR54	dc.w	ResetFunc	 	;Reserved
VECTOR53	dc.w	ResetFunc		;Reserved
VECTOR52	dc.w	ResetFunc 		;Reserved
VECTOR51	dc.w	ResetFunc 		;Reserved
VECTOR50	dc.w	ResetFunc 		;Reserved
VECTOR49	dc.w	ResetFunc 		;Reserved
VECTOR48	dc.w	ResetFunc 		;Reserved

VECTOR47	dc.w	ResetFunc 		;Reserved
VECTOR46	dc.w	ResetFunc 		;Reserved
VECTOR45	dc.w	ResetFunc 		;Reserved
VECTOR44	dc.w	ResetFunc 		;Reserved
VECTOR43	dc.w	ResetFunc 		;Reserved
VECTOR42	dc.w	ResetFunc 		;Reserved
VECTOR41	dc.w	ResetFunc 		;Reserved
VECTOR40	dc.w	ResetFunc 		;Reserved

VECTOR39	dc.w	ResetFunc 		;CAN transmit
VECTOR38	dc.w	CANReceive 		;CAN receive
VECTOR37	dc.w	ResetFunc 		;CAN errors
VECTOR36	dc.w	ResetFunc 		;CAN wake-up
VECTOR35	dc.w	ResetFunc	  	;FLASH
VECTOR34	dc.w	ResetFunc 		;Reserved
VECTOR33	dc.w	ResetFunc 		;Reserve
VECTOR32	dc.w	ResetFunc 		;Reserve

VECTOR31	dc.w	ResetFunc 		;Reserved
VECTOR30	dc.w	ResetFunc	  	;Reserved
VECTOR29	dc.w	ResetFunc	  	;CRG Self Clock Mode
VECTOR28	dc.w	ResetFunc 		;CRG PLL lock
VECTOR27	dc.w	ResetFunc 		;Reserved
VECTOR26	dc.w	ResetFunc 		;Reserved
VECTOR25	dc.w	ResetFunc	  	;Reserved
VECTOR24	dc.w	ResetFunc 		;Port J (PIEP)

VECTOR23	dc.w	ResetFunc 		;Reserved
VECTOR22	dc.w	ResetFunc 		;ATD (ATDCTL2 - ASCIE)
VECTOR21	dc.w	ResetFunc 		;SCI1
VECTOR20	dc.w	SerInputInt0		;SCI0
VECTOR19	dc.w	ResetFunc       	;SPI
VECTOR18	dc.w	ResetFunc 		;Pulse Accumulator 0 input edge
VECTOR17	dc.w	ResetFunc 		;Pulse Accumulator 0 overflow
VECTOR16	dc.w	ResetFunc 		;Standard Timer 0 Overflow

VECTOR15	dc.w	ResetFunc	  	;Timer 0 Channel 7
VECTOR14	dc.w	ResetFunc  		;Timer 0 Channel 6
VECTOR13	dc.w	ResetFunc	  	;Timer 0 Channel 5
VECTOR12	dc.w	audio_int		;Timer 0 Channel 4
VECTOR11	dc.w	ResetFunc	  	;Timer 0 Channel 3
VECTOR10	dc.w	ResetFunc 		;Timer 0 Channel 2
VECTOR9		dc.w	ResetFunc 		;Timer 0 Channel 1
VECTOR8		dc.w	ResetFunc	  	;Timer 0 Channel 0

VECTOR7		dc.w	RealTimeInt		;Real Time Interrupt
VECTOR6		dc.w	ResetFunc 		;IRQ
VECTOR5		dc.w	ResetFunc 		;XIRQ
VECTOR4		dc.w	ResetFunc 		;SWI
VECTOR3		dc.w	ResetFunc 		;Instruction Trap
VECTOR2		dc.w	ResetFunc 		;COP failure
VECTOR1		dc.w	ResetFunc 		;Clock Monitor
VECTOR0		dc.w	ResetFunc        	;Power On Reset   /* reset vector: this is the default entry point for a Assembly application. */

	END