	.module port.c
	.area data
_vPortSchRunning::
	.blkb 1
	.area idata
	.byte 0
	.area data
_vPortCriticalNesting::
	.blkb 1
	.area idata
	.byte 0
	.area data
_vPortTmp::
	.blkb 1
	.area idata
	.byte 0
	.area data
	.area text
_rtiHandler::
; /* This file is part of an "unsupported" FreeRTOS port distribution for
;  * Freescale MC9S12DP256B CPU.
;  */
; 
; /* Scheduler include files. */
; #include "projdefs.h"
; #include "portable.h"
; #include "task.h"
; #include "version.h"
; 
; volatile unsigned char vPortSchRunning = 0;
; volatile unsigned char vPortCriticalNesting = 0;
; volatile unsigned char vPortTmp = 0;
; 
; extern volatile void *pxCurrentTCB;
; 
; /* variable for temporary variables storage, placed in reserved memory block */
; unsigned char vPortCCRSave;
; unsigned short vPortAddrSave;
; unsigned char vPortPPAGESave;
; 
; /* timer setup routine */
; void prvSetupTimerInterrupt(void);
; 
; /*
; ** Tick ISR
; */
; #pragma interrupt_handler rtiHandler()
; void rtiHandler (void)
; {
;    vPortIsrHead();
		ldaa 0x30

		psha

		ldx _pxCurrentTCB

		sts 0, x

	jsr _vTaskIncrementTick
	jsr _vTaskSwitchContext
		ldx _pxCurrentTCB

		lds 0, x

		pulb

		stab 0x30

; 
;    /* do interrupt stuff... */
; 
; 	vPortIsrTail();
	bset 0x37,#128
		rti

; }
L3:
	.dbline 0 ; func end
	rti
;   pvParameters -> 8,x
;         pxCode -> 6,x
;   pxTopOfStack -> 2,x
_pxPortInitialiseStack::
	pshd
	pshx
	tfr s,x
; 
; /*
;  * See header file for description.
;  */
; portSTACK_TYPE *pxPortInitialiseStack(portSTACK_TYPE *pxTopOfStack,
; 	pdTASK_CODE pxCode, void /*@unused@*/ *pvParameters)
; {
; 	/* Place a few bytes of known values on the bottom of the stack.
; 	 * This is just useful for debugging. */
; 	*pxTopOfStack = (portSTACK_TYPE) 0x11;
	ldy 2,x
	ldab #17
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 	*pxTopOfStack = (portSTACK_TYPE) 0x22;
	ldy 2,x
	ldab #34
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 	*pxTopOfStack = (portSTACK_TYPE) 0x33;
	ldy 2,x
	ldab #51
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* Simulate how the stack would look after a call to vPortYield() generated
; 	 * by the compiler.
; 	 *
; 	 * First store the function parameters.  This is where the task will expect
; 	 * to find them when it starts running.
; 	 * A small note: CodeWarrior compiler passes single pointer via D and B
; 	 * registers, no stack is used, no need to push parameters into stack, but...
; 	 * there's also a problem to pass those parameters to the task, right now
; 	 * parameters passing to function is not supported. */
; //	*pxTopOfStack = (portSTACK_TYPE) ((unsigned int) pvParameters);
; //	pxTopOfStack--;
; //	*pxTopOfStack = (portSTACK_TYPE) ((unsigned int) pvParameters >> 8);
; //	pxTopOfStack--;
; 
; 	/* here comes the return address, since interrupts don't use pages, only
; 	 * two bytes of return address are stored, PPAGE byte will be saved later,
; 	 * manually
; 	 * such a complex lines are compiled into two assembly commands each */
; 	*pxTopOfStack = (portSTACK_TYPE) *(((portSTACK_TYPE *) (&pxCode)) + 1);
	ldy 2,x
	ldab 7,x
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 	*pxTopOfStack = (portSTACK_TYPE) *(((portSTACK_TYPE *) (&pxCode)) + 0);
	ldy 2,x
	ldab 6,x
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* Next are all the registers that form part of the task context. */
; 
; 	/* Y register */
; 	*pxTopOfStack = (portSTACK_TYPE) 0xff;
	ldy 2,x
	ldab #255
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 	*pxTopOfStack = (portSTACK_TYPE) 0xee;
	ldy 2,x
	ldab #238
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* X register */
; 	*pxTopOfStack = (portSTACK_TYPE) 0xdd;
	ldy 2,x
	ldab #221
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 	*pxTopOfStack = (portSTACK_TYPE) 0xcc;
	ldy 2,x
	ldab #204
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* A register */
; 	*pxTopOfStack = (portSTACK_TYPE) 0xbb;
	ldy 2,x
	ldab #187
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* B register */
; 	*pxTopOfStack = (portSTACK_TYPE) 0xaa;
	ldy 2,x
	ldab #170
	stab 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* CCR: pay attention that on task call, interrupts will be reenabled since
; 	 * "I" bit of CCR is cleared */
; 	*pxTopOfStack = (portSTACK_TYPE) 0x00;
	ldy 2,x
	clr 0,y
; 	pxTopOfStack--;
	ldd 2,x
	addd #-1
	std 2,x
; 
; 	/* save the page of current task (will be resored manually inside the
; 	 * ISR) */
;    *pxTopOfStack = (portSTACK_TYPE) ((int) pxCode);
	ldd 6,x
	ldy 2,x
	stab 0,y
; 
; 	return pxTopOfStack;
	ldd 2,x
L4:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
; sUsePreemption -> 2,x
_sPortStartScheduler::
	pshd
	pshx
	tfr s,x
; }
; 
; /*-----------------------------------------------------------*/
; portSHORT sPortStartScheduler( portSHORT sUsePreemption )
; {
; 	if (sUsePreemption != 0)
	ldd 2,x
	beq L7
; 	{
; 		/* setup the timer to generate timebase interrupt */
; 		prvSetupTimerInterrupt();
	jsr _prvSetupTimerInterrupt
; 	}
L7:
; 
;    /* flag the scheduler as started so vPortYield() knows it */
;    vPortSchRunning = 1;
	ldab #1
	stab _vPortSchRunning
; 
; 	/* Restore the context of the first task to run. */
; 	portRESTORE_CONTEXT();
		ldx _pxCurrentTCB

		lds 0, x

		pulb

		stab 0x30

; 
; 	/* simulate a function call end as generaged by the compiler. We will now
; 	 * jump to the start of the task the context of which we have just restored
; 	 */
; 	__asm__("rti");
		rti

; 
; 	/* should not get here, done to avoid compiler warning */
; 	return pdTRUE;
	ldd #1
L6:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
_vPortEndScheduler::
; }
; 
; /*-----------------------------------------------------------*/
; 
; void vPortEndScheduler( void )
; {
; 	/* It is unlikely that the scheduler for the Motorola port will get stopped
; 	 * once running.  If required disable the tick interrupt here, then return
; 	 * to sPortStartScheduler(). */
; }
L9:
	.dbline 0 ; func end
	rts
_vPortYield::
; 
; /*-----------------------------------------------------------*/
; 
; /** Manual context switch. */
; void volatile vPortYield(void)
; {
;    /* Avoid yield if we are not running the RTOS. Usefull if you
;     * want to use a common set of code and functions both as tasks
;     * and globals. */
;    if (vPortSchRunning == 0)
	tst _vPortSchRunning
	bne L11
;    {
;      return;
	lbra L10
L11:
;    }
; 
; 	/* here we should save all the registers as if this was done by interrupt
; 	 * call */
; 
; 	/* no context switch should occur during manual contex switch */
;    portDISABLE_RTI_INTERRUPT();
	bclr 0x38,#0xff
; 
; 	/* simulate hardware interrupt handler by saving approriate registers
; 	 * but... keep interrupt enable bit clear, so on activation of this task
; 	 * interrupts will be reenabled. */
; 	__asm__("pshy");
		pshy

; 	__asm__("pshx");
		pshx

; 	__asm__("psha");
		psha

; 	__asm__("pshb");
		pshb

; 	__asm__("pshc");
		pshc

; 	__asm__("bclr 0, sp, 0x10");
		bclr 0, sp, 0x10

; 
; 	/* complete context switch save */
; 	portSAVE_CONTEXT();
		ldaa 0x30

		psha

		ldx _pxCurrentTCB

		sts 0, x

; 
; 	/* Switch to the highest priority task that is ready to run. */
; 	vTaskSwitchContext();
	jsr _vTaskSwitchContext
; 
; 	/* Start executing the task we have just switched to. */
; 	portRESTORE_CONTEXT();
		ldx _pxCurrentTCB

		lds 0, x

		pulb

		stab 0x30

; 
; 	/* restore tasks's page */
; 	PPAGE = vPortPPAGESave;
	movb _vPortPPAGESave,0x30
; 
;    /* reenable RTI interrupt, in order to disallow reentry, disable interrupts
;     * globally beforehand */
;    portDISABLE_INTERRUPTS();
		sei

;    portENABLE_RTI_INTERRUPT();
	bset 0x38,#128
; 	/* don't enable interrupts, RTI will worry for that */
; 	__asm__("rti");
		rti

; }
L10:
	.dbline 0 ; func end
	rts
_prvSetupTimerInterrupt::
; 
; 
; /** setup timebase interrupt */
; #define RTIF   1<<7   /* Real Time Interrupt Flag */
; #define RTIE   1<<7   /* Real Time Interrupt bit */
; void prvSetupTimerInterrupt(void)
; {
;    /*
;    ** Enable the RTI interrupt at 1.024ms
;    ** OSCCLK is external oscillator
;    ** OSCCLK = 8MHz assumed ->  1ms = 1.024 / ( OSCCLK / ( 8 * 2^10 ) )
;    */
;    RTICTL  = 0x17;   /* RTR6:4 = 1, RTR3:0 = 7 => 8*2^10 */
	ldab #23
	stab 0x3b
;    CRGFLG |= RTIF;   /* clear RTI flag */
	bset 0x37,#128
;    CRGINT |= RTIE;   /* enable RTI interrupt */
	bset 0x38,#128
; }
L13:
	.dbline 0 ; func end
	rts
_vPortEnterCritical::
; 
; /*-----------------------------------------------------------*/
; /** @brief save CCR value into global varible: no stack is used.
;  * We have to count nesting of critical sections enterances and save interrupts
;  * state only if this is the first level, nesting counter is protected by
;  * semaphore */
; void vPortEnterCritical(void)
; {
;    __asm__("tpa");
		tpa

;    __asm__("staa _vPortTmp");
		staa _vPortTmp

;    portDISABLE_INTERRUPTS();
		sei

; 
;    /* no interrupts are allowed here, so nobody is able to access
;     * "vPortCriticalNesting", no need to protect it */
;    if (vPortCriticalNesting == 0)
	tst _vPortCriticalNesting
	bne L15
;    {
;       vPortCCRSave = vPortTmp;
	movb _vPortTmp,_vPortCCRSave
;    }
L15:
;    vPortCriticalNesting++;
	; vol
	ldab _vPortCriticalNesting
	clra
	addd #1
	stab _vPortCriticalNesting
; }
L14:
	.dbline 0 ; func end
	rts
_vPortExitCritical::
; 
; /** restore CCR from global variable: no stack is used */
; void vPortExitCritical(void)
; {
;    vPortCriticalNesting--;
	; vol
	ldab _vPortCriticalNesting
	clra
	subd #1
	stab _vPortCriticalNesting
; 
;    /* check this is the first level of "enter critical" section and if that is
;     * the case, clear the interrupt flag if needed */
;    if (/*vPortCriticalNesting == 0 && */ (vPortCCRSave & 0x10) == 0)
	brclr _vPortCCRSave,#16,X0
	bra L18
X0:
;    {
;       /* reenable interrupts */
;       portENABLE_INTERRUPTS();
		cli

;    }
L18:
; }
L17:
	.dbline 0 ; func end
	rts
	.area bss
_vPortPPAGESave::
	.blkb 1
	.even
_vPortAddrSave::
	.blkb 2
_vPortCCRSave::
	.blkb 1
