;MAIN.ASM
;9S12Dp256 MAIN ROUTINE
;DP256regs.INC CONTAINS ALL REGISTERS
;
;DP256REGS.INC, INT.ASM and AUDIO.ASM ARE EXTERNAL FILES
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*June 14, 2002		1.00		Initial release
*
*Author:Exequiel Rarama for the ADAPT9S12DP256 DKKI apps board
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

	include "Dp256Regs.INC"

;Public Function
	XDEF ResetFunc
	XDEF delay
	XDEF small_delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

	XDEF state_timer

;External Function
	XREF disp_init			;Initialize LCD
	XREF lcd_state			;Execute current LCD state
	XREF disp_update			;Update LCD

	XREF key_char_disp		;Display keyboard press to Lcd

	XREF keybd_init			;Initialize Keyboard
	XREF RealTimeInit			;Initialize RTI

;External Variables


*  Operational Parameters

RAM	equ	$1000			;9S12DP256 internal RAM
STACK	equ	$4000			;Stack at top of internal ram
EEPROM	equ	$400			;EEPROM start address
FLASH	equ	$4000			;Flash start address


DataSec:	SECTION

* System Variables

COMMAND		ds	1		;used by ProcessCommand
COMMAND_PENDING	ds	1		;used by ProcessCommand
CONTINUOUS	ds	1		;flag for real-time a/d screen update

state_timer	ds	2

***************************** Program *******************************

CodeSec: 	SECTION

ResetFunc				;This is where the RESET vector points to
	sei				;Disable Any interrupts

;Initialize Stack
	lds	#STACK			;initialize stack pointer

;Initialize COP
	movb	#%00000000,COPTCTL	;COP is enabled and is armed to
                                      	; reset in 1 second.

	jsr	RealTimeInit		;Initialize SCI and RTI
	jsr	keybd_init		;Initialize keyboard

	cli				;unmask interrupts
	jsr	disp_init		;Initialize Lcd

;------------------------------------------------------------------------------
main					;Main Loop
	ldy	lcd_state		;execute current state
	jsr	0,y
	jsr	disp_update

	jsr	key_char_disp		;check for keypress

	bra	main

;------------------------------------------------------------------------------
delay
        pshy
        ldy     #0
        bra     dly

small_delay
        pshy
        ldy     #333

dly
        dbne    y,dly
        puly
        rts


	END