;INT.ASM

*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.		DESCRIPTION
*
*June 14, 2002		1.00		Initial release
*
*Author:Exequiel Rarama for the ADAPT9S12DP256 DKKI apps board
*******************************************************************************
;Compiled using MCUez

; ---------------------------
; Demo - ISR Routine
; ---------------------------


	include "Dp256Regs.INC"


;Public Function
	XDEF RealTimeInit
	XDEF RealTimeInt

	XDEF OutStr0
	XDEF SerOutput0
	XDEF SerInputInt0

	XDEF KeybrdInt

;Public Variables
	XDEF wait_timer
	
;External Variables
	XREF state_timer

	XREF lcd_timer
	XREF lcd_state
	XREF clr_flag
	XREF disp_buffer

	XREF keybd_timer
	XREF keyp_timer
	XREF key_ptr
	XREF keybd_value
	XREF keybd_flag
	XREF keybd_count

	XREF spi_int_flag

	XREF COMMAND_PENDING
	XREF COMMAND

;External Messages
	XREF disp_menu0

DataSec:	SECTION

;
wait_timer	ds	2

;------------------------------------------------------------------------------
;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %10000001       ;SMP1,SMP0 = 0; S10BM,PRS0=1 - Select Sample time adn Bit mode
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags

rtimask1        equ     %00000001       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask2        equ     %00000010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask3        equ     %00000011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask4        equ     %00000100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask5        equ     %00000101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask6        equ     %00000110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask7        equ     %00000111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal
rtimask8        equ     %00001000       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask9        equ     %00001010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask10       equ     %00001011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask11       equ     %00001100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask12       equ     %00001101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask13       equ     %00001110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask14       equ     %00001111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal

rtimask15       equ     %01110000       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal



RTIF		equ	%10000000
RTIE		equ	%10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD1200        equ     417/2     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208/2     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104/2     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52/2      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35/2      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26/2      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13/2      ;(baud) 19200 baud with 16 Mhz crystal

* Operational Constants

TRUE            equ     $FF
FALSE           equ     $00
CR              equ     $D
LF              equ     $A
SPACE           equ     $20

;------------------------------------------------------------------------------



***************************** Program *******************************

CodeSec: 	SECTION


RealTimeInit				;Initialize Real Time Interrupt
	movb	#rtimask15,RTICTL	;and initialize RTI rate
	bset	CRGFLG,RTIF		;clear flag
	bset	CRGINT,RTIE		;Enable RTI

;Initialize first Serial Communication Interface
	movw	#BAUD9600,SCI0BDH       ;Set baud rate to 9600
	movb	#0,SCI0CR1
	movb	#scimask,SCI0CR2         ;enable SCI 0 rcvr. & xmtr. & rx int

	ldab	SCI0SR1                  ;read register to clear flag RDRF
	ldab	SCI0DRL                  ;read receive buffer

	rts

;------------------------------------------------------------------------------
* Real-time Interrupt Routine

RealTimeInt
	bset	CRGFLG,RTIF		;clear real-time interrupt flag
	cli				; so that other interrupts can be service


;--------
; Timers
;--------
;State timer is decremented here

time10
	ldx	state_timer
	beq	time20
	dex
	stx	state_timer

time20
	ldx	wait_timer
	beq	time30

	dex
	stx	wait_timer

time30
	ldx	lcd_timer
	beq	time40

	dex
	stx	lcd_timer

time40
	sei
	ldaa	keybd_timer
	beq	time50
	deca
	staa	keybd_timer
	bne	time50

	ldaa	#11
	staa	keybd_count

time50
	cli

time60
	ldx	keyp_timer
	beq	time70

	dex
	stx	keyp_timer

	ldx	keyp_timer
	bne	time70

	ldx	#disp_menu0
	stx	lcd_state

	ldx	#disp_buffer+20
	stx	key_ptr
	clr	clr_flag

time70

timex
	rti


;==============================================================================
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.


OutStr0				; send a null terminated string to the display.
	ldaa	1,x+            ; get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput0      ; no. send it out the SCI.
	bra	OutStr0          ; go get the next character.
;
OutStrDone
	rts

;------------------------------------------------------------------------------
SerOutput0
	brclr	SCI0SR1,TDREflag,SerOutput0     ;check if buffer is empty
	staa	SCI0DRL
	rts

SerInputInt0
	ldaa	SCI0SR1                  ;read register to clear flag RDRF
	movb	SCI0DRL,COMMAND          ;read receive buffer
	movb	#TRUE,COMMAND_PENDING

SIIX
	rti

;------------------------------------------------------------------------------
KeybrdInt
        ldaa    #10
        staa    keybd_timer

        ldaa    PORTT
        rola
        ldd     keybd_value
        rora
        rorb
        std     keybd_value

        bset    TFLG1,%00001000      ;Clear input capture 3 interrupt

        dec     keybd_count
        bne     keyex

        ldaa    #11
        staa    keybd_count

        inc     keybd_flag

        ldx     keybd_value+2
        stx     keybd_value+3
        ldaa    keybd_value
        rol     keybd_value+1
        rola
        rol     keybd_value+1
        rola
        staa    keybd_value+2

keyex
        rti
	

	END

