;AUDIO.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*May 21, 2002           1.00            Initial release
*
*Revised by Exequiel Rarama for the ADAPT9S12DP256
*******************************************************************************
;Compiled using MCUez

;
;Port P, bit 7 is use to drive the speaker.
;The port pin will toggle on compare.
;
; ---------------------------
; Demo - Audio Routine
; ---------------------------

	include "Dp256Regs.INC"

;Public Function
	XDEF audio_init
	XDEF do_4_BEEPS
	XDEF OC6Int
	XDEF audio_int
	XDEF PulseXToneB

;External Variables
	XREF TIMER
	XREF TIMER1	


DataSec:	SECTION

DURATION        ds     2       ;used for tone generation
HALF_PERIOD     ds     2


;------------------------------------------------------------------------------
TONE_2K         equ     500     ;frequencies in Hertz for tone generation
TONE_1K         equ     1000
TONE_440        equ     2272
TONE_220        equ     4545
TONE_180        equ     3000
TONE_110        equ     9090
TONE_60         equ     16666

OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

Audio           equ     %10000000       ;Port P bit 7

_100MS          equ     25
_250MS          equ     61
_500MS          equ     125
_1SECOND        equ     250
_2SECONDS       equ     500
_3SECONDS       equ     750
_5SECONDS       equ     1250
_10SECONDS      equ     2500
_25SECONDS      equ     6250
_60SECONDS      equ     15000
_2MIN           equ     30000

***************************** Program *******************************

CodeSec: 	SECTION

;Initialize PORTT bit 6 as output compare
audio_init
	bset	TSCR1,%10000000		;TEN=1 - Enable timer
	bset	TIOS,%01000000		;Bit 6 of PORTT use as Audio timer

;Initialize PORTP bit 7
	bset	DDRP,Audio		;Bit 7 of PORTP is Speaker Output
	rts
 
do_4_BEEPS
	ldx	#TONE_440		;generate two 100 millisecond beeps @ 440 Hz
	ldab	#$4			; (connect speaker to PP7)

	ldy	#_100MS
	bsr	PulseXToneB		;power tones
	rts

WaitX
	stx	TIMER1		;delays a length of time defined by x

W1
	ldx	TIMER1		; (note that whenever TIMER1 is non-zero,
	bne	W1		; it is decremented in the RTI interrupt
	rts			; service routine)

;-------------------------------------------------------------------------------
PulseXToneB

* b contains number of beeps desired
* x contains tone frequency
* y contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)

	sty	DURATION

rpt
	bsr	EnableToneX     ;tone generated via OutputCompare feature
	movw	DURATION,TIMER

d2_1
	ldy	TIMER
	bne	d2_1

	bclr	PORTP,Audio     ;Disable audio
	bclr	TIE,%01000000 ;turn off tone
	bclr	TCTL1,%01000000

	movw	DURATION,TIMER

d2_2
	ldy	TIMER
	bne	d2_2
	dbne	b,rpt
	rts

EnableToneX
	sei                     ;tone generation done via OutputCompare
	stx	HALF_PERIOD

	bset	PORTP,Audio     ;Enable
	bset	TIE,%01000000 ;enable OC6 interrupt
	bset	TFLG1,%01000000 ;clear flag
	cli
	rts

;------------------------------------------------------------------------------
; Audio Interrupt Routine
; -----------------------
OC6Int
audio_int
	ldd	HALF_PERIOD
	addd	TC6
	std	TC6

	brclr	PORTP,Audio,audio10
	bclr	PORTP,Audio
	bra	audio20

audio10
	bset	PORTP,Audio             ;Enable audio

audio20
	bset	TFLG1,%01000000         ;clear flag
	rti

	END