;INT.ASM

*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*May 21, 2002           1.00            Initial release
*
*Revised by Exequiel Rarama for the ADAPT9S12DP256
*******************************************************************************
;Compiled using MCUez

; ---------------------------
; Demo - ISR Routine
; ---------------------------


	include "Dp256Regs.INC"


;Public Function
	XDEF RealTimeInit
	XDEF RealTimeInt

	XDEF OutStr0
	XDEF SerOutput0
	XDEF SerInputInt0


;Public Variables
	XDEF ad0
	XDEF ad1
	XDEF ad2
	XDEF ad3
	XDEF ad4
	XDEF ad5
	XDEF ad6
	XDEF ad7

	XDEF TIMER
	XDEF TIMER1
	XDEF COUNTER
	
;External Variables
	XREF d_flag

	XREF COMMAND
	XREF COMMAND_PENDING
	XREF CONTINUOUS



DataSec:	SECTION

;ATD ram variables
atd_var

ad0             ds     2
ad1             ds     2
ad2             ds     2
ad3             ds     2
ad4             ds     2
ad5             ds     2
ad6             ds     2
ad7             ds     2

TIMER           ds     2       ;software timers using RTI
TIMER1          ds     2
COUNTER         ds     1

;------------------------------------------------------------------------------
;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %10000001       ;SMP1,SMP0 = 0; S10BM,PRS0=1 - Select Sample time adn Bit mode
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags

rtimask1        equ     %00000001       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask2        equ     %00000010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask3        equ     %00000011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask4        equ     %00000100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask5        equ     %00000101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask6        equ     %00000110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask7        equ     %00000111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal
rtimask8        equ     %00001000       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask9        equ     %00001010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask10       equ     %00001011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask11       equ     %00001100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask12       equ     %00001101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask13       equ     %00001110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask14       equ     %00001111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal

rtimask15       equ     %01110000       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal



RTIF		equ	%10000000
RTIE		equ	%10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal

* Operational Constants

TRUE            equ     $FF
FALSE           equ     $00
CR              equ     $D
LF              equ     $A
SPACE           equ     $20

;------------------------------------------------------------------------------



***************************** Program *******************************

CodeSec: 	SECTION


RealTimeInit				;Initialize Real Time Interrupt
	movb	#rtimask15,RTICTL	;and initialize RTI rate
	bset	CRGFLG,RTIF		;clear flag
	bset	CRGINT,RTIE		;Enable RTI

;Initialize Analog To Digital
	movb	#$80,ATD0CTL2	        ;enable ATD
	movb	#$40,ATD0CTL3		;
	movb	#$60,ATD0CTL4		;Select Sample rate
	movb	#$B0,ATD0CTL5		;Select 8 channel mode, Continuous scan

;Initialize first Serial Communication Interface
	movw	#BAUD9600,SCI0BDH       ;Set baud rate to 9600
	movb	#0,SCI0CR1
	movb	#scimask,SCI0CR2         ;enable SCI 0 rcvr. & xmtr. & rx int

	ldab	SCI0SR1                  ;read register to clear flag RDRF
	ldab	SCI0DRL                  ;read receive buffer

	rts

;------------------------------------------------------------------------------
* Real-time Interrupt Routine

RealTimeInt
	bset	CRGFLG,RTIF		;clear real-time interrupt flag
	cli				; so that other interrupts can be service

RTI_1
	ldx	TIMER
	beq	RTI_2
	dex
	stx	TIMER

RTI_2
	ldx	TIMER1
	beq	RTI_3
	dex
	stx	TIMER1

RTI_3
	ldaa	d_flag
	bne	RTI_4

	brclr	ATD0STATH,SCFflag,*       ;Loop here until SCF of ATD is set
                                        ;save ATD

	ldd	ATD0DR0H
	std	ad0

	ldd	ATD0DR1H
	std	ad1

	ldd	ATD0DR2H
	std	ad2

	ldd	ATD0DR3H
	std	ad3

	ldd	ATD0DR4H
	std	ad4

	ldd	ATD0DR5H
	std	ad5

	ldd	ATD0DR6H
	std	ad6

	ldd	ATD0DR7H
	std	ad7

RTI_4
	rti


;==============================================================================
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.


OutStr0				; send a null terminated string to the display.
	ldaa	1,x+            ; get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput0      ; no. send it out the SCI.
	bra	OutStr0          ; go get the next character.
;
OutStrDone
	rts

;------------------------------------------------------------------------------
SerOutput0
	brclr	SCI0SR1,TDREflag,SerOutput0     ;check if buffer is empty
	staa	SCI0DRL
	rts

SerInputInt0
	ldaa	SCI0SR1                  ;read register to clear flag RDRF
	movb	SCI0DRL,COMMAND          ;read receive buffer
	movb	#TRUE,COMMAND_PENDING

SIIX
	rti


	END

