;Author: Exequiel Rarama
;May 18, 2002
;
;MC68HC912DP256 REGISTER MAP

REG	EQU	$0000

PORTA	EQU	$0000		;PORTA
PORTB	EQU	$0001		;PORTB
DDRA	EQU	$0002		;PORTA - DATA DIRECTION REGISTER
DDRB	EQU	$0003		;PORTB - DATA DIRECTION REGISTER

PORTE	EQU	$0008		;PORTE
DDRE	EQU	$0009		;PORTE - DATA DIRECTION REGISTER
PEAR	EQU	$000A		;PEAR - PORTE ASSIGNMENT REGISTER
MODE	EQU	$000B		;MODE - MODE REGISTER
PUCR	EQU	$000C		;PUCR - PULL UP CONTROL REGISTER
RDRIV	EQU	$000D		;RDRIV - REDUCED DRIVE OF I/O LINES

EBICTL	EQU	$000E		;EBITCTL - ESTR

INITRM	EQU	$0010		;INITRM - INITIALIZATION OF INTERNAL RAM POSITION REGISTER
INITRG	EQU	$0011		;INITRG - INITIALIZATION OF INTERNAL REGISTER POSITION REGISTER
INITEE	EQU	$0012		;INITEE - INITIALIZATION OF INTERNAL EEPROM POSITION REGISTER
MISC	EQU	$0013		;MISC - MISCELLANEOUS MAPPING CONTROL REGISTER
MTST0	EQU	$0014
ITCR	EQU	$0015
ITEST	EQU	$0016
MTST1	EQU	$0017

PARTIDH	EQU	$001A
PARTIDL	EQU	$001B
MEMSIZ0	EQU	$001C
MEMSIZ1	EQU	$001D

INTCR	EQU	$001E           ;INTCR - INTERRUPT CONTROL REGISTER
HPRIO	EQU	$001F           ;HPRIO - HIGHEST PRIORITY I INTERRRUPT

BKPCT0	EQU	$0028
BKPCT1	EQU	$0029
BKP0X	EQU	$002A
BKP0H	EQU	$002B
BKP0L	EQU	$002C
BKP1X	EQU	$002D
BKP1H	EQU	$002E
BKP1L	EQU	$002F
PPAGE	EQU	$0030

PORTK	EQU	$0032
DDRK	EQU	$0033
SYNR	EQU	$0034           ;SYNR -
REFDV	EQU	$0035           ;REFDV -
CTFLG	EQU	$0036
CRGFLG	EQU	$0037
CRGINT	EQU	$0038
CLKSEL	EQU	$0039
PLLCTL	EQU	$003A
RTICTL	EQU	$003B
COPTCTL	EQU	$003C
FORBYP	EQU	$003D
CTCTL	EQU	$003E
ARMCOP	EQU	$003F

TIOS	EQU	$0040		;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
TCFORC	EQU	$0041		;CFORC - TIMER COMPARE FORCE REGISTER
TOC7M	EQU	$0042		;OC7M - OUTPUT COMPARE 7 MASK REGISTER
TOC7D	EQU	$0043		;OC7D - OUTPUT COMPARE 7 DATA REGISTER

TCNT	EQU	$0044
TCNTH	EQU	$0044
TCNTL	EQU	$0045

TSCR1	EQU	$0046		;TSCR - TIMER SYSTEM CONTROL REGISTER
TTOV	EQU	$0047
TCTL1	EQU	$0048		;TCTL1 - TIMER CONTROL REGISTER 1
TCTL2	EQU	$0049		;TCTL2 - TIMER CONTROL REGISTER 2
TCTL3	EQU	$004A		;TCTL3 - TIMER CONTROL REGISTER 3
TCTL4	EQU	$004B		;TCTL4 - TIMER CONTROL REGISTER 4
TIE	EQU	$004C
TSCR2	EQU	$004D
TFLG1	EQU	$004E		;TFLG1 - TIMER INTERRUPT FLAG 1
TFLG2	EQU	$004F		;TFLG2 - TIMER INTERRUPT FLAG2
TC0	EQU	$0050		;TC0 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC1	EQU	$0052		;TC1 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC2	EQU	$0054		;TC2 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC3	EQU	$0056		;TC3 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC4	EQU	$0058		;TC4 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC5	EQU	$005A		;TC5 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC6	EQU	$005C		;TC6 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC7	EQU	$005E		;TC7 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0

PACTL	EQU	$0060		;PATCL - PULSE ACCUMULATOR CONTROL REGISTER
PAFLG	EQU	$0061		;PAFLG - PULSE ACCUMULATOR FLAG REGISTER
PACN3	EQU	$0062		;PACN3 - HI BYTE
PACN2	EQU	$0063		;PACN2 - LO BYTE
PACN1	EQU	$0064		;PACN1 - HI BYTE
PACN0	EQU	$0065		;PACN0 - LO BYTE
MCCTL	EQU	$0066		;MCCTL
MCFLG	EQU	$0067		;MCFLG
ICPAR	EQU	$0068		;ICPAR
DLYCT	EQU	$0069		;DLYCT
ICOVW	EQU	$006A		;ICOVW
ICSYS	EQU	$006B		;ICSYS

TIMTST	EQU	$006D		;TIMTST - TIMER TEST REGISTER

PBCTL	EQU	$0070		;PBCTL
PBFLG	EQU	$0071		;PBFLG
PA3H	EQU	$0072		;PA3H
PA2H	EQU	$0073		;PA2H
PA1H	EQU	$0074		;PA1H
PA0H	EQU	$0075		;PA0H

MCCNT	EQU	$0076
MCCNTH	EQU	$0076		;MCCNT - LO BYTE
MCCNTL	EQU	$0077		;MCCNT - LO BYTE

TC0H	EQU	$0078		;TC0H
TC0L	EQU	$0079		;TC0L
TC1H	EQU	$007A		;TC1H
TC1L	EQU	$007B		;TC1L
TC2H	EQU	$007C		;TC2H
TC2L	EQU	$007D		;TC2L
TC3H	EQU	$007E		;TC3H
TC3L	EQU	$007F		;TC3L

ATD0CTL0	EQU	$0080		;ATDCTL0 - RESERVED
ATD0CTL1	EQU	$0081		;ATDCTL1 - RESERVED
ATD0CTL2	EQU	$0082		;ATDCTL2 - ATD CONTROL REGISTER
ATD0CTL3	EQU	$0083		;ATDCTL3 - ATD CONTROL REGISTER
ATD0CTL4	EQU	$0084		;ATDCTL4 - ATD CONTROL REGISTER
ATD0CTL5	EQU	$0085		;ATDCTL5 - ATD CONTROL REGISTER

ATD0STATH	EQU	$0086	;ATDSTAT - ATD STATUS HIGH REGISTER
ATD0STATL	EQU	$0087	;ATDSTAT - LOW REGISTER
ATD0TESTH	EQU	$0088	;ATDTEST - ATD TEST HIGH REGISTER
ATD0TESTL	EQU	$0089	;ATDTEST - LOW REGISTER

ATD0DIEN	EQU	$008D

PORTAD0	EQU	$008F		;PORTAD - PORT AD DATA INPUT REGISTER
ATD0DR0H	EQU	$0090
ATD0DR0L	EQU	$0091
ATD0DR1H	EQU	$0092
ATD0DR1L	EQU	$0093
ATD0DR2H	EQU	$0094
ATD0DR2L	EQU	$0095
ATD0DR3H	EQU	$0096
ATD0DR3L	EQU	$0097
ATD0DR4H	EQU	$0098
ATD0DR4L	EQU	$0099
ATD0DR5H	EQU	$009A
ATD0DR5L	EQU	$009B
ATD0DR6H	EQU	$009C
ATD0DR6L	EQU	$009D
ATD0DR7H	EQU	$009E
ATD0DR7L	EQU	$009F

PWME	EQU	$00A0
PWMPOL	EQU	$00A1
PWMCLK	EQU	$00A2
PWMPRCLK	EQU	$00A3
PWMCAE	EQU	$00A4
PWMCTL	EQU	$00A5
PWMTST	EQU	$00A6
PWMPRSC	EQU	$00A7
PWMSCLA	EQU	$00A8
PWMSCLB	EQU	$00A9
PWMSCNTA	EQU	$00AA
PWMSCNTB	EQU	$00AB
PWMCNT0	EQU	$00AC
PWMCNT1	EQU	$00AD
PWMCNT2	EQU	$00AE
PWMCNT3	EQU	$00AF
PWMCNT4	EQU	$00B0
PWMCNT5	EQU	$00B1
PWMCNT6	EQU	$00B2
PWMCNT7	EQU	$00B3
PWMPER0	EQU	$00B4		;PWPER0
PWMPER1	EQU	$00B5		;PWPER1
PWMPER2	EQU	$00B6		;PWPER2
PWMPER3	EQU	$00B7		;PWPER3
PWMPER4	EQU	$00B8		;PWPER4
PWMPER5	EQU	$00B9		;PWPER5
PWMPER6	EQU	$00BA		;PWPER6
PWMPER7	EQU	$00BB		;PWPER7

PWMDTY0	EQU	$00BC		;PWDTY0
PWMDTY1	EQU	$00BD		;PWDTY1
PWMDTY2	EQU	$00BE		;PWDTY2
PWMDTY3	EQU	$00BF		;PWDTY3
PWMDTY4	EQU	$00C0		;PWDTY4
PWMDTY5	EQU	$00C1		;PWDTY5
PWMDTY6	EQU	$00C2		;PWDTY6
PWMDTY7	EQU	$00C3		;PWDTY7
PWMSDN	EQU	$00C4

SCI0BDH	EQU	$00C8		;SCI0BDH - SCI BAUD RATE CONTROL REGISTER
SCI0BDL	EQU	$00C9		;SCI0BDL - SCI BAUD RATE CONTROL REGISTER
SCI0CR1	EQU	$00CA		;SCI0CR1 - SCI CONTROL REGISTER
SCI0CR2	EQU	$00CB		;SCI0CR2 - SCI CONTROL REGISTER
SCI0SR1	EQU	$00CC		;SCI0SR1 - SCI STATUS REGISTER
SCI0SR2	EQU	$00CD		;SCI0SR2 - SCI STATUS REGISTER
SCI0DRH	EQU	$00CE		;SCI0DRH - SCI DATA REGISTER
SCI0DRL	EQU	$00CF		;SCI0DRL - SCI DATA REGISTER

SCI1BDH	EQU	$00D0		;SCI1BDH -
SCI1BDL	EQU	$00D1		;SCI1BDL -
SCI1CR1	EQU	$00D2		;SCI1CR1 -
SCI1CR2	EQU	$00D3		;SCI1CR2 -
SCI1SR1	EQU	$00D4		;SCI1SR1 -
SCI1SR2	EQU	$00D5		;SCI1SR2 -
SCI1DRH	EQU	$00D6		;SCI1DRH -
SCI1DRL	EQU	$00D7		;SCI1DRL -
SPI0CR1	EQU	$00D8		;SPI0CR1 - SPI CONTROL REGISTER
SPI0CR2	EQU	$00D9		;SPI0CR2 - SPI CONTROL REGISTER
SPI0BR	EQU	$00DA		;SPI0BR - SPI BAUD RATE REGISTER
SPI0SR	EQU	$00DB		;SPI0SR - SPI STATUS REGISTER

SPI0DR	EQU	$00DD		;SPI0DR - SPI DATA REGISTER

IBAD	EQU	$00E0		;IBAD -
IBFD	EQU	$00E1		;IFBD -
IBCR	EQU	$00E2		;IBCR -
IBSR	EQU	$00E3		;IBSR -
IICDR	EQU	$00E4		;IIBDR -

DLCBCR1	EQU	$00E8
DLCBSVR	EQU	$00E9
DLCBCR2	EQU	$00EA
DLCBDR	EQU	$00EB
DLCBARD	EQU	$00EC
DLCBRSR	EQU	$00ED
DLCSCR	EQU	$00EE
DLCBSTAT	EQU	$00EF

SPI1CR1	EQU	$00F0
SPI1CR2	EQU	$00F1
SPI1BR	EQU	$00F2
SPI1SR	EQU	$00F3

SPI1DR	EQU	$00F5

SPI2CR1	EQU	$00F8
SPI2CR2	EQU	$00F9
SPI2BR	EQU	$00FA
SPI2SR	EQU	$00FB

SPI2DR	EQU	$00FD

FCLKDIV	EQU	$0100
FSEC	EQU	$0101

FCNFG	EQU	$0103
FPROT	EQU	$0104
FSTAT	EQU	$0105
FCMD	EQU	$0106

ECLKDIV	EQU	$0110

ECNFG	EQU	$0113
EPROT	EQU	$0114
ESTAT	EQU	$0115
ECMD	EQU	$0116

ATD1CTL0		EQU	$0120		;ATD1CTL0 -
ATD1CTL1		EQU	$0121		;ATD1CTL1 -
ATD1CTL2		EQU	$0122		;ATD1CTL2 -
ATD1CTL3		EQU	$0123		;ATD1CTL3 -
ATD1CTL4		EQU	$0124		;ATD1CTL4 -
ATD1CTL5		EQU	$0125		;ATD1CTL5 -
ATD1STAT0	EQU	$0126		;ATD1STAT0 -
ATD1STAT1	EQU	$0127		;ATD1STAT1 -
ATD1TEST0	EQU	$0128		;ATD1TESTH -
ATD1TEST1	EQU	$0129		;ATD1TESTL -

ATDDIEN		EQU	$012D

PORTAD1		EQU	$012F		;PORTAD1 -

ATD1DR0H	EQU	$0130		;ADT1DR0H -
ATD1DR0L	EQU	$0131		;ADT1DR0L -
ATD1DR1H	EQU	$0132		;ADT1DR1H -
ATD1DR1L	EQU	$0133		;ADT1DR1L -
ATD1DR2H	EQU	$0134		;ADT1DR2H -
ATD1DR2L	EQU	$0135		;ADT1DR2L -
ATD1DR3H	EQU	$0136		;ADT1DR3H -
ATD1DR3L	EQU	$0137		;ADT1DR3L -
ATD1DR4H	EQU	$0138		;ADT1DR4H -
ATD1DR4L	EQU	$0139		;ADT1DR4L -
ATD1DR5H	EQU	$013A		;ADT1DR5H -
ATD1DR5L	EQU	$013B		;ADT1DR5L -
ATD1DR6H	EQU	$013C		;ADT1DR6H -
ATD1DR6L	EQU	$013D		;ADT1DR6L -
ATD1DR7H	EQU	$013E		;ADT1DR7H -
ATD1DR7L	EQU	$013F		;ADT1DR7L -

CAN0CTL0	EQU	$0140
CAN0CTL1	EQU	$0141
CAN0BTR0	EQU	$0142
CAN0BTR1	EQU	$0143
CAN0RFLG	EQU	$0144
CAN0RIER	EQU	$0145
CAN0TFLG	EQU	$0146
CAN0TIER	EQU	$0147
CAN0TARQ	EQU	$0148
CAN0TAAK	EQU	$0149

CAN0TBSEL	EQU	$014A
CAN0IDAC		EQU	$014B

CAN0RXERR	EQU	$014E
CAN0TXERR	EQU	$014F
CAN0IDAR0	EQU	$0150
CAN0IDAR1	EQU	$0151
CAN0IDAR2	EQU	$0152
CAN0IDAR3	EQU	$0153
CAN0IDMR0	EQU	$0154
CAN0IDMR1	EQU	$0155
CAN0IDMR2	EQU	$0156
CAN0IDMR3	EQU	$0157
CAN0IDAR4	EQU	$0158
CAN0IDAR5	EQU	$0159
CAN0IDAR6	EQU	$015A
CAN0IDAR7	EQU	$015B
CAN0IDMR4	EQU	$015C
CAN0IDMR5	EQU	$015D
CAN0IDMR6	EQU	$015E
CAN0IDMR7	EQU	$015F

CAN0RXFG	EQU	$0160		;RECEIVE BUFFER = $0160-$016F
CAN0TXFG	EQU	$0170		;TRANSMIT BUFFER = $0170-$017F

CAN1CTL0	EQU	$0180
CAN1CTL1	EQU	$0181
CAN1BTR0	EQU	$0182
CAN1BTR1	EQU	$0183
CAN1RFLG	EQU	$0184
CAN1RIER	EQU	$0185
CAN1TFLG	EQU	$0186
CAN1TIER	EQU	$0187
CAN1TARQ	EQU	$0188
CAN1TAAK	EQU	$0189

CAN1TBSEL	EQU	$018A
CAN1IDAC		EQU	$018B

CAN1RXERR	EQU	$018E
CAN1TXERR	EQU	$018F
CAN1IDAR0	EQU	$0190
CAN1IDAR1	EQU	$0191
CAN1IDAR2	EQU	$0192
CAN1IDAR3	EQU	$0193
CAN1IDMR0	EQU	$0194
CAN1IDMR1	EQU	$0195
CAN1IDMR2	EQU	$0196
CAN1IDMR3	EQU	$0197
CAN1IDAR4	EQU	$0198
CAN1IDAR5	EQU	$0199
CAN1IDAR6	EQU	$019A
CAN1IDAR7	EQU	$019B
CAN1IDMR4	EQU	$019C
CAN1IDMR5	EQU	$019D
CAN1IDMR6	EQU	$019E
CAN1IDMR7	EQU	$019F

CAN1RXFG	EQU	$01A0		;RECEIVE BUFFER = $01A0-$01AF
CAN1TXFG	EQU	$01B0		;TRANSMIT BUFFER = $01B0-$01BF

CAN2CTL0	EQU	$01C0
CAN2CTL1	EQU	$01C1
CAN2BTR0	EQU	$01C2
CAN2BTR1	EQU	$01C3
CAN2RFLG	EQU	$01C4
CAN2RIER	EQU	$01C5
CAN2TFLG	EQU	$01C6
CAN2TIER	EQU	$01C7
CAN2TARQ	EQU	$01C8
CAN2TAAK	EQU	$01C9

CAN2TBSEL	EQU	$01CA
CAN2IDAC		EQU	$01CB

CAN2RXERR	EQU	$01CE
CAN2TXERR	EQU	$01CF
CAN2IDAR0	EQU	$01D0
CAN2IDAR1	EQU	$01D1
CAN2IDAR2	EQU	$01D2
CAN2IDAR3	EQU	$01D3
CAN2IDMR0	EQU	$01D4
CAN2IDMR1	EQU	$01D5
CAN2IDMR2	EQU	$01D6
CAN2IDMR3	EQU	$01D7
CAN2IDAR4	EQU	$01D8
CAN2IDAR5	EQU	$01D9
CAN2IDAR6	EQU	$01DA
CAN2IDAR7	EQU	$01DB
CAN2IDMR4	EQU	$01DC
CAN2IDMR5	EQU	$01DD
CAN2IDMR6	EQU	$01DE
CAN2IDMR7	EQU	$01DF

CAN2RXFG	EQU	$01E0		;RECEIVE BUFFER = $01E0-$01EF
CAN2TXFG	EQU	$01F0		;TRANSMIT BUFFER = $01B0-$01FF

CAN3CTL0	EQU	$0200
CAN3CTL1	EQU	$0201
CAN3BTR0	EQU	$0202
CAN3BTR1	EQU	$0203
CAN3RFLG	EQU	$0204
CAN3RIER	EQU	$0205
CAN3TFLG	EQU	$0206
CAN3TIER	EQU	$0207
CAN3TARQ	EQU	$0208
CAN3TAAK	EQU	$0209

CAN3TBSEL	EQU	$020A
CAN3IDAC		EQU	$020B

CAN3RXERR	EQU	$020E
CAN3TXERR	EQU	$020F
CAN3IDAR0	EQU	$0210
CAN3IDAR1	EQU	$0211
CAN3IDAR2	EQU	$0212
CAN3IDAR3	EQU	$0213
CAN3IDMR0	EQU	$0214
CAN3IDMR1	EQU	$0215
CAN3IDMR2	EQU	$0216
CAN3IDMR3	EQU	$0217
CAN3IDAR4	EQU	$0218
CAN3IDAR5	EQU	$0219
CAN3IDAR6	EQU	$021A
CAN3IDAR7	EQU	$021B
CAN3IDMR4	EQU	$021C
CAN3IDMR5	EQU	$021D
CAN3IDMR6	EQU	$021E
CAN3IDMR7	EQU	$021F

CAN3RXFG	EQU	$0220		;RECEIVE BUFFER = $0220-$022F
CAN3TXFG	EQU	$0230		;TRANSMIT BUFFER = $0230-$023F

PTT	EQU	$0240
PORTT	EQU	PTT
PTIT	EQU	$0241
DDRT	EQU	$0242		;DDRT - DATA DIRECTION REGISTER
RDRT	EQU	$0243	
PERT	EQU	$0244
PPST	EQU	$0245

PTS	EQU	$0248
PORTS	EQU	PTS
PTIS	EQU	$0249
DDRS	EQU	$024A
RDRS	EQU	$024B
PERS	EQU	$024C
PPSS	EQU	$024D
WOMS	EQU	$024E

PTM	EQU	$0250
PORTM	EQU	PTM
PTIM	EQU	$0251
DDRM	EQU	$0252
RDRM	EQU	$0253
PERM	EQU	$0254
PPSM	EQU	$0255
WOMM	EQU	$0256

PTP	EQU	$0258
PORTP	EQU	PTP
PTIP	EQU	$0259
DDRP	EQU	$025A
RDRP	EQU	$025B
PERP	EQU	$025C
PPSP	EQU	$025D
PIEP	EQU	$025E
PIFP	EQU	$025F

PTH	EQU	$0260
PORTH	EQU	PTH
PTIH	EQU	$0261
DDRH	EQU	$0262
RDRH	EQU	$0263
PERH	EQU	$0264
PPSH	EQU	$0265
PIEH	EQU	$0266
PIFH	EQU	$0267

PTJ	EQU	$0268
PORTJ	EQU	PTJ
PTIJ	EQU	$0269
DDRJ	EQU	$026A
RDRJ	EQU	$026B
PERJ	EQU	$027C
PPSJ	EQU	$026D
PIEJ	EQU	$026E
PIFJ	EQU	$026F

CAN4CTL0	EQU	$0280
CAN4CTL1	EQU	$0281
CAN4BTR0	EQU	$0282
CAN4BTR1	EQU	$0283
CAN4RFLG	EQU	$0284
CAN4RIER	EQU	$0285
CAN4TFLG	EQU	$0286
CAN4TIER	EQU	$0287
CAN4TARQ	EQU	$0288
CAN4TAAK	EQU	$0289

CAN4TBSEL	EQU	$028A
CAN4IDAC		EQU	$028B

CAN4RXERR	EQU	$028E
CAN4TXERR	EQU	$028F
CAN4IDAR0	EQU	$0290
CAN4IDAR1	EQU	$0291
CAN4IDAR2	EQU	$0292
CAN4IDAR3	EQU	$0293
CAN4IDMR0	EQU	$0294
CAN4IDMR1	EQU	$0295
CAN4IDMR2	EQU	$0296
CAN4IDMR3	EQU	$0297
CAN4IDAR4	EQU	$0298
CAN4IDAR5	EQU	$0299
CAN4IDAR6	EQU	$029A
CAN4IDAR7	EQU	$029B
CAN4IDMR4	EQU	$029C
CAN4IDMR5	EQU	$029D
CAN4IDMR6	EQU	$029E
CAN4IDMR7	EQU	$029F

CAN4RXFG	EQU	$02A0		;RECEIVE BUFFER = $02A0-$02AF
CAN4TXFG	EQU	$02B0		;TRANSMIT BUFFER = $02B0-$02BF












