;MAIN.ASM
;9S12Dp256 MAIN ROUTINE
;DP256regs.INC CONTAINS ALL REGISTERS
;
;DP256REGS.INC, INT.ASM and AUDIO.ASM ARE EXTERNAL FILES
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*May 21, 2002           1.00            Initial release
*
*Revised by Exequiel Rarama for the ADAPT9S12DP256
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

	include "Dp256Regs.INC"

;Public Function
	XDEF ResetFunc
	XDEF delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

;External Function
	XREF RealTimeInit
	XREF audio_init
	XREF do_4_BEEPS

	XREF ShowAnalog
	XREF ProcessCommand

	XREF ShowMenu

;External Variables
	XREF d_flag



*  Operational Parameters

RAM	equ	$1000			;9S12DP256 internal RAM
STACK	equ	$4000			;Stack at top of internal ram
EEPROM	equ	$400			;EEPROM start address
FLASH	equ	$4000			;Flash start address


DataSec:	SECTION

* System Variables

COMMAND		ds	1		;used by ProcessCommand
COMMAND_PENDING	ds	1		;used by ProcessCommand
CONTINUOUS	ds	1		;flag for real-time a/d screen update


***************************** Program *******************************

CodeSec: 	SECTION

ResetFunc				;This is where the RESET vector points to
	sei				;Disable Any interrupts

;Initialize Stack
	lds	#STACK			;initialize stack pointer

;Initialize COP
	movb	#%00000000,COPTCTL	;COP is enabled and is armed to
                                      	; reset in 1 second.

	movb	#$FF,DDRP		;Make Port P outputs

	jsr	RealTimeInit		;Initialize SCI and RTI
	jsr	audio_init		;Initialize bit 7 of PORTP as OC for audio o/p

	clr	COMMAND_PENDING
	clr	CONTINUOUS
	clr	d_flag

	cli				;unmask interrupts

	jsr	do_4_BEEPS		;Blink/Sound LED/SPEAKER

	jsr	ShowMenu

;------------------------------------------------------------------------------
main					;Main Loop
	jsr	ProcessCommand		;this is the program loop

	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog


NotCont
	bra	main


;------------------------------------------------------------------------------
;small delay
delay
	pshy
	ldy	#0

dly
	dbne	y,dly			;decrement y counter
	puly
	rts


	END