//             TECHNOLOGICAL ARTS
//	    www.technologicalarts.com
//
//************************************************************************
// This program demonstrates the operation of msCAN using Adapt9S12DG
// and the EVALH1 board.
// In this program, two boards sets are used. Both 
// Adapt9S12DG cards are connected physicallly via 3-wire female cables
// connected to the CAN0 port of each board.
//
// You can add as many board sets as you want.
// When one sends the data, it is received by all the other boards. 
// Dip switches on the Demo board are used to set the 8 bit identifier and 
// 8 bit data. So basically, the identifier is the same as data byte. This data byte 
// is transfered to the other board(s) and displayed on the LED bargraph of the Demo Board.
//************************************************************************

// Please refer to FRAME.doc in the CANFINAL folder to get an idea of
// what a CAN V2.0A standard frame looks like.
// Make sure that the 8-bit identifier is set the same as the data byte.


#include <hidef.h>      	// common defines and macros 
#include "derivative.h"      /* derivative-specific definitions */
#include "PORT.h"		// port initialisation
#include "msCAN.h"		// msCAN initialisation
#include "PLL.h"		// PLL initialisation

volatile unsigned int j,i, k;

//#pragma CODE_SEG __NEAR_SEG NON_BANKED 	// Interrupt section for this module. 
interrupt void CAN0R_ISR(void)
{
	if((CAN0RFLG & 0x01) == 1)  	// Receiver Buffer Full Flag is 1 when data is received
	
	{
	 j=CAN0RXDSR0;  		// Read byte of data from Receiver Data Segment Register0
	}
	
	CAN0RFLG = CAN0RFLG | 0x01; 	// clear flag
	PTH = ~j;			// display byte on LED bargraph
}

//#pragma CODE_SEG DEFAULT

void main(void)
{

	PORT_Init();
	
	PLL_Initialization();

	CAN_TR_Init();
	CANTXinit();
	EnableInterrupts;
	 
	while (1) 
	{
		while(k==PTT){} 		// wait for DIP switch change
		for(i=0; i<10000; i++); 	// a delay for switch data in
		k=PTT; 	                  	// update bargraph display with data from DIP switch
		CAN0TX(k);			// call function to transmit data at port T
	}
}