//             TECHNOLOGICAL ARTS 
//	        www.technologicalarts.com

// Please refer to FRAME.doc to see what a CAN V2.0A standard frame looks like.
// Make sure that the 8-bit identifier field is set same as data byte

#include <hidef.h>            /* common defines and macros */
#include <mc9s12dp512.h>      /* derivative information */

void CAN_TR_Init(void)
{
	CAN0CTL1 |=0x80;		// Enable CAN module
	
	CAN0CTL1 &=0xEF; 		// Turn off listen mode
	
	while ((CAN0CTL1 | 0x01) == 0) 	// place CAN in init mode
	{
		CAN0CTL0 = CAN0CTL0 | 0x01;
	}
	CAN0IDAC=0x20; 			// 8-bit acceptance mode, CAN must be in initialization mode
	
	CAN0BTR0 = 0xC5; 		// set jump width 4 Tq cycles, 6 prescaler value.
					            // sets the bit rate to 250kHz

	CAN0BTR1 = 0xE7; 		// set 3 samples per bit. for bit rate of 250 Khz
					// Bit Time= (Prescaler Value/Fcanclk)*[1+TSEG2+SEG1]
				        // set 1+TSEG2+SEG1=16 therefore SEG2= 7 and SEG1=8
					
	CAN0IDMR0 = 0x00; 	//Identifier mask register 0-7
	CAN0IDMR1 = 0x00;	//placing 1's doesn't allow a comparison, so all ones will
	CAN0IDMR2 = 0x00;	//generate a hit, no matter what is stored in corresponding
 	CAN0IDMR3 = 0x00;	//acceptance register
	CAN0IDMR4 = 0x00;
	CAN0IDMR5 = 0x00;
	CAN0IDMR6 = 0x40; 	//0x40 here would result in a filter 6 hit if upper nibble = 0100 and 
				              //lower nibble could be anything
				              
	CAN0IDMR7 = 0xFF; 	//for example, 0xFF here would result in a filter 7 hit no matter 
			              	// the value of identifier
			              	
	CAN0IDAR0 = 0x54; 	//if identifier is 0x01, filter 0 hit
	CAN0IDAR1 = 0x50; 	//if identifier is 0x02 filter 2 hit
	CAN0IDAR2 = 0x46; 
	CAN0IDAR3 = 0x08;
	CAN0IDAR4 = 0x10;
	CAN0IDAR5 = 0x20;
	CAN0IDAR6 = 0x40;
	CAN0IDAR7 = 0x80; 	            // if identifier is 0x80 filter 7 hit
	
	CAN0CTL0 &= 0xFE; 	            //CAN out of init mode

	while ((CAN0CTL0 & 0x10) == 0); // Wait for syncronization
	
	CAN0RFLG = CAN0RFLG | 0x01; 		// clr flag
	
	CAN0RIER = CAN0RIER | 0x01; 		//enable CAN receiver interrupts
}


void CAN0TX(volatile unsigned int k)
{
	while (!CAN0TFLG); 		// wait for TX complete flag 
						            // if 0 Tx buffer empty else full
						            
	CAN0TBSEL = CAN0TFLG; // depending on Tx flag, selected particular Tx 
						            // buffer from CAN0TBSEL 
						            // CAN0TBSEL (?)
	
	CAN0TXIDR0 = k; 		  // IDR = Identifer Register
	                  	  // only 8 bit identifier 
						            // we can go up to 32 bits of identifier
						            
	CAN0TXIDR1 = 0xE0;    // depending upon IDAM1 & IDAM0 in CAN0IDAC register 
						            // Use standard format IDE = 0
						            // set RTR to 0 because sending a data frame
	
	CAN0TXDSR0 = k; 			// message (Byte 0) DSR = Data Segment register
	
	CAN0TXDLR = 0x01; 		// send 1 data bytes
	
	CAN0TFLG = CAN0TBSEL; // Clear flag
}

void CANTXinit(void)    //CAN setup
{

	CAN0CTL1 = CAN0CTL1 | 0x80; 		// ENABLE CAN MODULE
	
	CAN0CTL1 = CAN0CTL1 & 0xEF; 		// Turn off listen mode
	
	while ((CAN0CTL1 | 0x01) == 0) 	//place CAN in init mode
	
	{
	CAN0CTL0 = CAN0CTL0 | 0x01; 		// Set Bit 1 to go into init mode
	}
	
	CAN0BTR0 = 0xC5; 		//set jump width 4 Tq cycles, 6 prescaler value.
					            // sets bit rate to 250KHz

	CAN0BTR1 = 0xE7; 		//set 3 samples per bit. for bit rate of 250 KHz
					            // Bit Time= (Prescaler Value/Fcanclk)*[1+TSEG2+SEG1]
					            // set 1+TSEG2+SEG1=16 therefore SEG2= 7 and SEG1=8
					            
	CAN0CTL0 = CAN0CTL0 & 0xFE; 		  // take CAN out of init mode
	
	while ((CAN0CTL0 & 0x10) == 0){} 	// wait forever for sync
}
	
