//             TECHNOLOGICAL ARTS
//              +1(416) 963-8996 
//	    www.technologicalarts.ca

// This is a demo program used to demonstrate the working SPI module 
// of 9S12. In this demo program, we used our standard cards: Adapt9S12D,9S12
// demo board, and SPI EEPROM 25AA640 interfaced to H2 connector of Adapt9S12D.
// H2 connector pin 1,2,3 and 4 can be used as MISO,MOSI,SCK and SS respectively
// for SPI. This program will write a byte to a memory location, read from 
// it, and then display it on the bargraph provided on 9S12 demo board.

#include <hidef.h>      /* common defines and macros */
#include <mc9s12dp512.h>     /* derivative information */
#pragma LINK_INFO DERIVATIVE "mc9s12dp512"
#include <PLL.h>
#include <PORT.h>
#include <Delay.h>
#include <SPI_BYTE.h>


#define DATA 	       0xAA      // byte  data to be written into EEPROM
#define ADD_LSB      0x00      // Memory location Address LSB
#define ADD_MSB      0x00      // Memory location Address MSB 
#define EEPROM_READ  0x03      // EEPROM READ instruction
#define EEPROM_WRITE 0x02      // EEPROM WRITE instruction
#define EEPROM_WREN  0x06      // EEPROM WRITE Enable instruction
#define EEPROM_WRDI  0x04      // EEPROM WRITE Disable instruction


void main(void) 
{

PLL_Initialization();		// Initialise PLL
PORT_Init();				    // Initialise PORT
SPI_Initialisation();		// Initialise SPI


// Write byte to memory location
SPI_write(EEPROM_WREN,EEPROM_WRITE,ADD_MSB,ADD_LSB,DATA,EEPROM_WRDI);

Delay(1000);    // Delay between write and read operation

// Read byte to memory location
PTH=SPI_read(EEPROM_READ,ADD_MSB,ADD_LSB);

for(;;) {}      // wait

}
