//             TECHNOLOGICAL ARTS
//              +1(416) 963-8996 
//	        www.technologicalarts.ca

#include <hidef.h>      /* common defines and macros */
#include <mc9s12dp512.h>     /* derivative information */
#include <PORT.h>
#include <Delay.h>


#define SS_H 0x80	  // Data Latch High for 74HC595
#define SS_L 0x7F	  // Data Latch Low for 74HC595
#define trans_delay 10 // Transient_delay 10
//***************************
void SPI_Initialisation(void)
//***************************

{   SPI0CR1=0x50; // SPI Control Register 1
		              // SPE =1 ; Enable SPI
		              // MSTR=1 ; Enable Master mode
		              
                  // LSBFE=0; MSB First
    
    SPI0CR2=0x00; // SPI Control Register 2
		              
		              		  
    SPI0BR=0x22;  // SPI Baud Rate Register
		              // Baud Rate = Bus_Clock / Baud_Rate_Divisor
		              // Baud_Rate_Divisor= (SPPR+1)*2exp(SPR+1)
		              // here SSPR=2 and SPR= 1 will set the
  		            // 1 Mhz baud rate.
}
// SPI_Initialisation();


// Set CS LOW
void CS_LOW(void)
{
 PTS&=SS_L;  	  
}

// Set CS HIGH
void CS_HIGH(void)
{
 Delay(trans_delay); // Transient Delay
 PTS|=SS_H;  	 
}


 //**************************************
// Send byte on SPI port
//**************************************
void data_send_SPI(unsigned char data)
{

	unsigned char dummy1, dummy2;  // dummy charater to clear flag


	while(SPI0SR_SPTEF==0);   // wait while data register is not empty
  SPI0DR=data;              // sent data
  
  while(SPI0SR_SPIF==0);    // wait till transfer complete
 	dummy1=SPI0SR;            // read Status and Data Register
	dummy2= SPI0DR;           // to clear flag
}

// Write subroutine.EEPROM 25AA640 require write enable to bet set before data to be written into the EEPROM.
// Well following set of instructions are required for write operation
// Chip Select(CS) low + Write Enable + CS High + CS Low + Write Instruction 
// + 16 bit address + data byte + CS High + CS Low + Write Disable + CS High 
// *************************************************************************************************************************************************************************
void SPI_write(unsigned char EEPROM_WREN,unsigned char EEPROM_WRITE,unsigned char ADD_MSB,unsigned char ADD_LSB,unsigned char *DATA,unsigned char EEPROM_WRDI,int pagelength)
// *************************************************************************************************************************************************************************
{  
   int i;
	 CS_LOW();                         // cs low
 	 data_send_SPI(EEPROM_WREN);       // set eeprom write enable latch
 	 CS_HIGH();                        // make cs high
   
   CS_LOW();                         // cs low again
   data_send_SPI(EEPROM_WRITE);      // eeprom write instruction
   data_send_SPI(ADD_MSB);           // 16 bit address
   data_send_SPI(ADD_LSB);
   
   for(i=0;i<pagelength;i++)
   data_send_SPI(DATA[i]);              // 8 bit data 
   CS_HIGH();                        // cs high
   
   CS_LOW();                         // cs low
   data_send_SPI(EEPROM_WRDI);       // disable write enable operation
   CS_HIGH();                        // cs high
}

// READ subroutine. Well following set of instructions are required for Read operation
// Chip Select(CS) low + READ Instruction + 16 bit address + read data byte on MISO + CS High 
// **********************************************************************************************************
unsigned char *SPI_read(unsigned char EEPROM_READ,unsigned char ADD_MSB,unsigned char ADD_LSB,int pagelength)
{  
   int j;
   unsigned char Data1[32]; 
   CS_LOW();                          // cs low
   data_send_SPI(EEPROM_READ);        // eeprom read instuction
   data_send_SPI(ADD_MSB);            // 16 bit address
   data_send_SPI(ADD_LSB);
   
   for(j=0;j<pagelength;j++)
   {
    
   while((SPI0SR_SPTEF==0));          // wait while data register is not empty
   SPI0DR=0x00;                       // dummy write, to read data byte on MISO line
                                      // this will generate 8 clock bit for data read 
                                      // operation
                                      
   while((SPI0SR_SPIF==0));           // wait till transfer complete
   Data1[j]=SPI0DR;
   }                                  
   CS_HIGH();                         // cs high
   return (Data1);                   // get new data
}

