//             TECHNOLOGICAL ARTS
//              +1(416) 963-8996 
//	    www.technologicalarts.ca

// This is a demo program used to demonstrate the working SPI module 
// of 9S12. In this program, we use our standard cards:  Adapt9S12D,9S12
// demo board and SPI EEPROM 25AA640 interfaced to H2 connector of Adapt9S12D.
// H2 connector pin 1,2,3 and 4 can be used as MISO,MOSI,SCK and SS respectively
// for SPI. This program will write a byte or page to a memory location and then read from 
// it, displaying it on the bargraph provided on 9S12 demo board.

// by changing the pagelength you can write a page or a byte.

#include <hidef.h>      /* common defines and macros */
#include <mc9s12dp512.h>     /* derivative information */
#pragma LINK_INFO DERIVATIVE "mc9s12dp512"
#include <PLL.h>
#include <PORT.h>
#include <Delay.h>
#include <SPI_PAGE.h>

#define pagelength 8         // page length 32 bytes

#define ADD_LSB      0x20      // Memory location Address LSB
#define ADD_MSB      0x00      // Memory location Address MSB 
#define EEPROM_READ  0x03      // EEPROM READ instruction
#define EEPROM_WRITE 0x02      // EEPROM WRITE instruction
#define EEPROM_WREN  0x06      // EEPROM WRITE Enable instruction
#define EEPROM_WRDI  0x04      // EEPROM WRITE Disable instruction

unsigned char DATA[32]={0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA,0x01,0x32,0x45,0xAA};
unsigned char *Data1;			// Data1 holds the data to be written into a page 
									// Data2 hold the data when we read the page
int k;

void main(void) 
{

PLL_Initialization();		// Initialise PLL
PORT_Init();				    // Initialise PORT
SPI_Initialisation();		// Initialise SPI


// Write byte to memory location
SPI_write(EEPROM_WREN,EEPROM_WRITE,ADD_MSB,ADD_LSB,DATA,EEPROM_WRDI,pagelength);

Delay(1000);    // Delay between write and read operation

// Read byte to memory location
Data1=SPI_read(EEPROM_READ,ADD_MSB,ADD_LSB,pagelength);

for(k=0;k<pagelength;k++)
{
PTH=Data1[k];

Delay(300000);
}

for(;;) {}      // wait

}

/*
IIC_write(EEPROM_ADD,ADD1_MSB,ADD1_LSB,Data1,pagelength);
Delay(700); 
Data2= IIC_read(EEPROM_ADD,ADD1_MSB,ADD1_LSB,pagelength);



}
*/