// ****************************************************************************
//             TECHNOLOGICAL ARTS
//              +1(416) 963-8996 
//	    www.technologicalarts.ca

// This is a demo program used to demonstrate the working of CLOCK
// using Adapt9S12D,9S12 demo board and 4x16 LCD

// PORT S -- D7 to D4 connected with D7 to D4 of Lcd.
// D3-D0 of LCD are not connected as LCD is used in 4 bit Mode.

// PORT P -- D0- R/W, D1-EN, D2-RS 

// Switch SW2, SW3, SW4 and SW5 are used to set the time of real Clock.

// As we never read Lcd R/W, it is always set to zero.
// ****************************************************************************

#include <hidef.h>        // common defines and macros 
#include <mc9s12dp512.h>  // derivative information
#include <PLL.h> 	  // initialize PLL to 24MHz
#include <PORT.h>	  // initialise Ports
#include <LCD.h>	  // initialise LCD
#include <Delay.h>	  // Delay program
#include <Modulus_Timer.h // initialise Modulus Down Counter
#include <Int_Char_Conv.h>// convert integer to charater

#pragma LINK_INFO DERIVATIVE "mc9s12dp512"

#define DELAY4 (20000)    // Debounce Delay for SW2,SW3,SW4 and SW5 switch.

void Display_Time(void);                // display on LCD

void Clock_Real_Time(void);             // run real time clock

void Set_Time(void);                                                         // approximate delay

int toggle,ampm,ampm12;

unsigned char hrs10,hrs1,hrs,min10,min1,min,sec10,sec1,sec;

unsigned int count;

void main(void) 
{ 

  PORT_Init();		  // initialise Ports
 
  PLL_Initialization();   // initialize PLL  

  Lcd_Initialization();   // initialize Lcd
 
  Lcd_Display();          // subroutine for displaying data on Lcd

  //##############################################################
  Set_Time();             // adjust the time clock. Here with 
                          // this subroutine you can adjust the time
                          // to the actual time.
  //##############################################################
  
  Lcd_Write("+1(416) 963-8996",3);  // line 3 Technological Arts Telephone number
  
  ModulusDown_Initialization();	    // initialise Modulus Down Counter

  EnableInterrupts;		    // enable interrupt

  while(1)
  	{    
  	 Clock_Real_Time();         // this subroutine will display time
  	}                         
}
                   



void Clock_Real_Time(void)
  {
  
	  if (sec==60)               // when 60 sec over increment min by 1 and make sec=0
		{
		 sec=0;
		 min++;
		 
		}
	  if (min==60) 
		{
		 min=0;              // when 60 min over increment hrs by 1 and make min=0
		 hrs++;
		 
		 ampm12++;           // adjust AM/PM count by 1 after every one hrs
		}
	  if (hrs==13)              
		{
		 hrs=1;              // used to adjust hours e.g. 12:59 is time, after 1 minute
		}                    // it will become 13:00. So it will adjust it to 1:00
		
	  if (ampm12==12)
	  { ampm12=0;                // if time is AM make after 12 hrs PM and vice versa
	    if (ampm==1) 	     
	      {
	       ampm=0; 
	      }
	        else 
	         {
	          ampm=1;
	         }
	    
  }
	  Display_Time();
	  
  }
	 
  
	           

  
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// this subroutine separate units and tens from interger for hrs, min and sec. It will  
// then convert them into character for display on LCD.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
 void Display_Time(void)
  {
   	unsigned char address1=0xD5;  // 4th line, 5th character address from where time start
   	char temp;                    // stores temporary conversion data of INT to CHAR                                             

   	hrs10=hrs/10;                 // separate units and ten's from hours
  	hrs1=hrs-hrs10*10;

	min10=min/10;                 // separate units and ten's from minutes
	min1=min-min10*10;

	sec10=sec/10;                 // separate units and ten's from seconds
	sec1=sec-sec10*10;        
 
    Lcd_Controlword( address1,0);
    
    temp=int2char_conv(hrs10);        // display as Time HH:MM:SS PM
    Lcd_Controlword( temp,1);
    
    temp=int2char_conv(hrs1);
    Lcd_Controlword( temp,1);
    
    Lcd_Controlword( ':',1);
    
    temp=int2char_conv(min10);
    Lcd_Controlword( temp,1);
    
    temp=int2char_conv(min1);
    Lcd_Controlword( temp,1);
    
    Lcd_Controlword( ':',1);
    
    temp=int2char_conv(sec10);
    Lcd_Controlword( temp,1);
    
    temp=int2char_conv(sec1);
    Lcd_Controlword( temp,1);
    
    Lcd_Controlword( ' ',1);
    if (ampm==1)
    {
    Lcd_Controlword( 'P',1);
    Lcd_Controlword( 'M',1);
    } 
    else
    {
    Lcd_Controlword( 'A',1);
    Lcd_Controlword( 'M',1);
    }
 }

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// This subroutine is used to adjust the time. Switch 
// sw2 for hrs
// sw3 for min
// sw4 for AM/PM
// sw5 tells controller that time adjustment is complete
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

void Set_Time(void) 
{
unsigned char sw1,sw2,sw3,sw4,sw5;

while (sw5!=0x00) 
{  
  sw1 =PORTAD0;
 
  Delay(DELAY4);
  sw5=sw1&0x80;
  sw4=sw1&0x40;
  sw3=sw1&0x20;
  sw2=sw1&0x10;

  
if (sw2==0x00)
  { hrs++;}        // increment hrs by 1 if switch sw2 is pressed
  
if (sw3==0x00) 	   // increment min by 1 if switch sw3 is pressed
  { min++;}
 
if (sw4==0x00)     // toggle between AM PM when sw4 is pressed
  { if (ampm==1) 
    ampm=0;
  else
   ampm=1;
  }

 if (sec==60) 
		{
		 sec=0;       //  sec= 60, increment min by 1
		 		 
		}
	if (min==60) 	      //  min= 60, increment hrs by 1
		{
		 min=0;
		}
	if (hrs==13)	      //  hrs=1  after 12:59
		{
		 hrs=1;
		}
		
	  
Display_Time();               
}
 ampm12=hrs;          // this will keep track of PM and AM
}


//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
// This is interrupt subroutine for Real Time Interrupt
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
#pragma CODE_SEG __NEAR_SEG NON_BANKED
  interrupt void ModulusDown_ISR(void)
  {
	MCFLG = 0x80;   // clear flag 
	
	count++;        // if count == 25 then its one second
	

	if (count==25)  // .04*25= 1 second 
		{
		PTH++;        // turn on LED after every 1 minute
		
		count=0;      // count becomes 0 after every one second
		
		sec++;        // incement sec after count =25. As count= 25 means 1 second of time
	
	}
  }

  #pragma CODE_SEG DEFAULT