#ifndef __UEXEC_H
#define __UEXEC_H
#include "uexec.h"

/* Internal header file for micro-executive (uexec)
 * Do NOT include except for uexec source code
 *
 * Copyright (c) 1998 ImageCraft and Richard F. Man
 * http://www.imagecraft.com
 */
/* Task State:
 * no need to declare T_CURRENT
 */
enum { T_CREATED, T_READY };

typedef struct TaskControlBlock
	{
	struct	TaskControlBlock *next;
	unsigned char tid;			/* task id */
	unsigned char state;		/* task state, do not use enum
								 * since the compiler may allocate
								 * more space 
							     */
	unsigned char ticks;		/* how many ticks does the task execute */
	unsigned char current_ticks;/* current number of ticks remaining */
	void	(*func)(void);		/* function to call for that task */
	unsigned char	*stack_start;		/* stack low value */
	unsigned char	*stack_end;			/* stack high value */
	unsigned char	*sp;		/* current value of the stack pointer */
	} TaskControlBlock;

#define DEFAULT_TICKS		5

void UEXC_Schedule(void);
void UEXC_Resume(void);
void UEXC_KillSelf(void);
void UEXC_SystemInterrupt(void);
void UEXC_StartTimer(void);
void UEXC_RestartTimer(void);
void UEXC_SavregsAndResched(void);
void UEXC_StartNewTask(void);
#endif
