;
; processor dependent portion of the micro-executive
; Copyright (c) 1998 ImageCraft and Richard F. Man
; http://www.imagecraft.com
;
	.area text
; interrupt handler
; this gets invoke every X cycles
;
_UEXC_SystemInterrupt::
	sts	_uexc_current_sp
	jsr	_UEXC_CheckTask	; may schedule
	; if we reschedule, then we won't come back!
	rti

; save state and then reschedule
; this is called by Defer to give up control
;
_UEXC_SavregsAndResched::
 ; first create an interrupt stack frame
	pshy
	pshx
	pshd		; what a concept, not A:B
	tpa
	anda #0xEF	; re-enable interrupt when it "returns" since
	psha		; Defer() disables interrupt
 ; now store the stack pointer to *_current_sp, which is
 ; set to &_current_task->sp
	ldy _uexc_current_sp
	sts 0,y
 ; now reschedule
	jmp _UEXC_Schedule

; Start a new task
;
_UEXC_StartNewTask::
	lds _uexc_current_sp
 ; make KillSelf as the "return pc" of a new task, so if it
 ; ever returns, it will reclaim the storage
	ldd #_UEXC_KillSelf
	pshb
	psha
	ldd _uexc_current_func
	pshb
	psha
 ; create an interrupt stack frame
	pshy
	pshx
	pshd
	tpa
	anda #0xEF	; re-enable interrupt
	psha		; 
 ; now "call" the new function
	rti

; Resume a previously stopped task
;
_UEXC_Resume::
 ; _current_sp has current_task->sp
 ; restore the stack pointer and just pretend we are returning
 ; from interrupt
	lds _uexc_current_sp
	rti

; The following can be written in C but they are processor
; specific
;
; start the interrupt timer

IO_BASE	= 0x0
TIOS = 0x40

TCNT	= 0x44

TSCR	= 0x46
TCTL1	= 0x48
TMSK1	= 0x4C
TFLG1	= 0x4E
TC4		= 0x58

INTERRUPT_CYCLES = 2500

; start the timer to interrupt 
;
_UEXC_StartTimer::
	pshx	; save X
	ldx	#IO_BASE

	bset TSCR,x,#0x90		; turn on the timer system and use Fast Flag Clear
	bset TIOS,x,#0x10		; TC4 is output compare

	ldd	 TCNT,x
	addd #INTERRUPT_CYCLES
	std  TC4,x
	bset TMSK1,x,#0x10		; enable interrupt for TOC4
	bset TFLG1,x,#0x10		; clear the interrupt flag
	bclr TCTL1,x,#0x03		; TOC4 does not control any pin
	pulx
	rts

_UEXC_RestartTimer::
	pshx
	ldx #IO_BASE
	ldd  TC4,x
	addd #INTERRUPT_CYCLES
	std  TC4,x
	pulx
	rts
