// filename ******** Main.C ************** 
// Example main program for SCI 9S12C32 test
// 9S12C32 SCI connected to PC com port
// does not run in BOOT mode, only in RUN mode

// Steven Lamb : minor mods for g++ April 28, 2004

#include "9s12c32.h"  //register map
#include "sci.h"

//---------------------OutCRLF---------------------
// Output a CR,LF to SCI to go to a new line
// Input: none
// Output: none
// toggle PortT bit 0 each time, debugging profile
void OutCRLF(void){
  SCI_OutChar(CR);
  SCI_OutChar(LF);
  PORTT ^= 0x01;          // toggle bit 0
}

int main() {
char string[20];  
unsigned short n;

  DDRT |= 0x3 ;     // PortT bits 1,0 are output to LED
  SCI_Init(9600);	// standard baud rate
  
  OutCRLF(); SCI_OutString("Technological Arts 9S12C32, SCI test  28/04/04 -SRL"); OutCRLF();
  for(;;) {
    PORTT ^= 0x2;          // toggle bit 1
    SCI_OutString("InString: "); 
    SCI_InString(string,19);   
    SCI_OutString(" OutString="); SCI_OutString(string); OutCRLF();
    
    SCI_OutString("InUDec: ");  n=SCI_InUDec(); 
    SCI_OutString(" OutUDec="); SCI_OutUDec(n); OutCRLF();
     
    SCI_OutString("InUHex: ");  n=SCI_InUHex(); 
    SCI_OutString(" OutUHex="); SCI_OutUHex(n); OutCRLF();
  } 
}
