#ifndef __HCS12E128_H
#define __HCS12E128_H

/* macros, generic #define etc.
 */
#include <hc12def.h>

/* base address of register block, change this if you relocate the register
 * block. This is for S12E128 !
 */

#define _IO_BASE        0
#define _ADDR(off)      (unsigned char volatile *)(_IO_BASE + off)
#define _P(off)         *(unsigned char volatile *)(_IO_BASE + off)
#define _LP(off)        *(unsigned short volatile *)(_IO_BASE + off)

#define PORTA   _P(0x00)
#define PORTB   _P(0x01)
#define DDRA    _P(0x02)
#define DDRB    _P(0x03)

//#define Reserved      _P(0x04)
//#define Reserved      _P(0x05)
//#define Reserved      _P(0x06)
//#define Reserved      _P(0x07)

#define PORTE   _P(0x08)
#define DDRE    _P(0x09)
#define PEAR    _P(0x0A)
#define MODE    _P(0x0B)
#define PUCR    _P(0x0C)
#define RDRIV   _P(0x0D)
#define EBICTL  _P(0x0E)

//#define reserved      _P(0x0F)

#define INITRM  _P(0x10)
#define INITRG  _P(0x11)
#define INITEE  _P(0x12)
#define MISC    _P(0x13)
#define MTST0   _P(0x14)
#define ITCR    _P(0x15)
#define ITEST   _P(0x16)
#define MIST1   _P(0x17)

//#define Reserved      _P(0x18)
#define VREGCTRL      _P(0x19)

#define PARTIDH  _P(0x1A)
#define PARTIDL  _P(0x1B)
#define PARTID   _LP(0x1A)

#define MEMSIZ0  _P(0x1C)
#define MEMSIZ1  _P(0x1D)
#define INTCR    _P(0x1E)
#define HPRIO    _P(0x1F)

#define BDGC1      _P(0x20)
#define DBGCS      _P(0x21)
#define DBGTBH      _P(0x22)
#define DBGTBL      _P(0x23)
#define DBGCNT      _P(0x24)
#define DBGCCX      _P(0x25)
#define DBGCCH      _P(0x26)
#define DBGCCL      _P(0x27)

#define BKPCT0   _P(0x28)
#define BKPCT1   _P(0x29)
#define BKP0X    _P(0x2A)
#define BKP0H    _P(0x2B)
#define BKP0L    _P(0x2C)
#define BKP0     _LP(0x2B)

#define BKP1X    _P(0x2D)
#define BKP1H    _P(0x2E)
#define BKP1L    _P(0x2F)
#define BKP1     _LP(0x2E)

#define PPAGE     _P(0x30)

//#define RESERVED      _P(0x31)
//#define RESERVED    	_P(0x32)
//#define RESERVED      _P(0x33)

#define SYNR     _P(0x34)
#define REFDV    _P(0x35)
#define CTFLG    _P(0x36)
#define CRGFLG   _P(0x37)
#define CRGINT   _P(0x38)
#define CLKSEL   _P(0x39)
#define PLLCTL   _P(0x3A)
#define RTICTL   _P(0x3B)
#define COPCTL   _P(0x3C)
#define FORBYP   _P(0x3D)
#define CTCTL    _P(0x3E)
#define ARMCOP   _P(0x3F)

#define T0IOS     _P(0x40)
#define T0CFORC   _P(0x41)
#define T0OC7M    _P(0x42)
#define T0OC7D    _P(0x43)

#define T0CNT     _LP(0x44)

#define T0SCR1    _P(0x46)
#define T0TOV     _P(0x47)
#define T0CTL1    _P(0x48)
#define T0CTL2    _P(0x49)
#define T0CTL3    _P(0x4A)
#define T0CTL4    _P(0x4B)
#define T0IE      _P(0x4C)
#define T0SCR2    _P(0x4D)
#define T0FLG1    _P(0x4E)
#define T0FLG2    _P(0x4F)

//#define RESERVED      _LP(0x50)
//#define RESERVED      _LP(0x52)
//#define RESERVED      _LP(0x54)
//#define RESERVED      _LP(0x56)

#define T0C4      _LP(0x58)
#define T0C5      _LP(0x5A)
#define T0C6      _LP(0x5C)
#define T0C7      _LP(0x5E)

#define P0ACTL     _P(0x60)
#define P0AFLG     _P(0x61)
#define P0ACNTH     _P(0x62)
#define P0ACNTL     _P(0x63)
#define P0ACNT	   _LP(0x62)

//#define Reserved     _P(0x64 - 7F)

#define ATD0CTL0  _P(0x80)
#define ATD0CTL1  _P(0x81)
#define ATD0CTL2  _P(0x82)
#define ATD0CTL3  _P(0x83)
#define ATD0CTL4  _P(0x84)
#define ATD0CTL5  _P(0x85)

#define ATD0STAT0   _P(0x86)
//#define Reserved   _P(0x87)
#define ATDTEST0   _P(0x88)
#define ATDTEST1   _P(0x89)
#define ATD0STAT1     _P(0x8A)
#define ATD1STAT1      _P(0x8B)
#define ATDDIEN0      _P(0x8C)
#define ATDDIEN1   _P(0x8D)

#define PORTAD0    _P(0x8E)

#define PORTAD1   _P(0x8F)

#define ATDDR0H  _P(0x90)
#define ATDDR0L  _P(0x91)
#define ATDDR0   _LP(0x90)

#define ATDDR1H  _P(0x92)
#define ATDDR1L  _P(0x93)
#define ATDDR1   _LP(0x92)

#define ATDDR2H _P(0x94)
#define ATDDR2L _P(0x95)
#define ATDDR2  _LP(0x94)

#define ATDDR3H _P(0x96)
#define ATDDR3L _P(0x97)
#define ATDDR3  _LP(0x96)

#define ATDDR4H _P(0x98)
#define ATDDR4L _P(0x99)
#define ATDDR4  _LP(0x98)

#define ATDDR5H _P(0x9A)
#define ATDDR5L _P(0x9B)
#define ATDDR5  _LP(0x9A)

#define ATDDR6H _P(0x9C)
#define ATDDR6L _P(0x9D)
#define ATDDR6  _LP(0x9C)

#define ATDDR7H _P(0x9E)
#define ATDDR7L _P(0x9F)
#define ATDDR7  _LP(0x9E)

#define ATDDR8H _P(0xA0)
#define ATDDR8L _P(0xA1)
#define ATDDR8  _LP(0xA0)

#define ATDDR9H _P(0xA2)
#define ATDDR9L _P(0xA3)
#define ATDDR9  _LP(0xA2)

#define ATDDR10H _P(0xA4)
#define ATDDR10L _P(0xA5)
#define ATDDR10  _LP(0xA4)

#define ATDDR11H _P(0xA6)
#define ATDDR11L _P(0xA7)
#define ATDDR11  _LP(0xA6)

#define ATDDR12H _P(0xA8)
#define ATDDR12L _P(0xA9)
#define ATDDR12  _LP(0xA8)

#define ATDDR13H _P(0xAA)
#define ATDDR13L _P(0xAB)
#define ATDDR13  _LP(0xAA)

#define ATDDR14H _P(0xAC)
#define ATDDR14L _P(0xAD)
#define ATDDR14  _LP(0xAC)

#define ATDDR15H _P(0xAE)
#define ATDDR15L _P(0xAF)
#define ATDDR15  _LP(0xAE)


#define SCI0BDH  _P(0xC8)
#define SCI0BDL  _P(0xC9)
#define SCI0BD   _LP(0xC8)

#define SC0CR1   _P(0xCA)
#define SCI0CR1  _P(0xCA)
#define SCI0CR2  _P(0xCB)

#define SCI0SR1  _P(0xCC)
#define SC0SR1	SCI0SR1		/* compatability */
#define SC0SR2   _P(0xCD)
#define SCI0SR2  _P(0xCD)

#define SCI0DRH  _P(0xCE)
#define SCI0DRL  _P(0xCF)
#define SC0DRL	SCI0DRL		/* compatability */
#define SCI0DR   _LP(0xCE)

#define SCI1BDH  _P(0xD0)
#define SCI1BDL  _P(0xD1)
#define SCI1BD   _LP(0xD0)

#define SCI1CR1   _P(0xD2)
#define SCI1CR2   _P(0xD3)
#define SCI1SR1   _P(0xD4)
#define SCI1SR2   _P(0xD5)

#define SCI1DRH   _P(0xD6)
#define SCI1DRL   _P(0xD7)
#define SCI1DR    _LP(0xD6)

#define SPICR1   _P(0xD8)
#define SPICR2   _P(0xD9)
#define SPIBR    _P(0xDA)
#define SPISR    _P(0xDB)

//#define Reserved      _P(0xDC)

#define SPIDR    _P(0xDD)

//#define Reserved      _P(0xDE)
//#define Reserved      _P(0xDF)

#define IBAD    _P(0xE0)
#define IBFD    _P(0xE1)
#define IBCR    _P(0xE2)
#define IBSR    _P(0xE3)
#define IICDR   _P(0xE4)

//#define Reserved      _P(0xE5)
//#define Reserved      _P(0xE6)
//#define Reserved      _P(0xE7)

#define SCI2BDH  _P(0xE8)
#define SCI2BDL  _P(0xE9)
#define SCI2BD   _LP(0xE8)

#define SCI2CR1   _P(0xEA)
#define SCI2CR2   _P(0xEB)
#define SCI2SR1   _P(0xEC)
#define SCI2SR2   _P(0xED)

#define SCI2DRH   _P(0xEE)
#define SCI2DRL   _P(0xEF)
#define SCI2DR    _LP(0xEE)


#define DAC0C0  _P(0xF0)
#define DAC0C1  _P(0xF1)
#define DAC0DL  _P(0xF2)
#define DAC0DR  _P(0xF3)


#define DAC1C0  _P(0xF4)
#define DAC1C1  _P(0xF5)
#define DAC1DL  _P(0xF6)
#define DAC1DR  _P(0xF7)

#define FCLKDIV _P(0x0100)
#define FSEC    _P(0x0101)
#define C0BTR0  _P(0x0102)

//#define Reserved for Factory Test _P(0x0102)

#define FCNFG  _P(0x0103)
#define FPROT  _P(0x0104)
#define FSTAT  _P(0x0105)
#define FCMD   _P(0x0106)

//#define Reserved _P(0x0107 - 013F)

#define T1IOS     _P(0x140)
#define T1CFORC   _P(0x141)
#define T1OC7M    _P(0x142)
#define T1OC7D    _P(0x143)

#define T1CNT     _LP(0x144)

#define T1SCR1    _P(0x146)
#define T1TOV     _P(0x147)
#define T1CTL1    _P(0x148)
#define T1CTL2    _P(0x149)
#define T1CTL3    _P(0x14A)
#define T1CTL4    _P(0x14B)
#define T1IE      _P(0x14C)
#define T1SCR2    _P(0x14D)
#define T1FLG1    _P(0x14E)
#define T1FLG2    _P(0x14F)

//#define RESERVED      _LP(0x50)
//#define RESERVED      _LP(0x52)
//#define RESERVED      _LP(0x54)
//#define RESERVED      _LP(0x56)

#define T1C4      _LP(0x158)
#define T1C5      _LP(0x15A)
#define T1C6      _LP(0x15C)
#define T1C7      _LP(0x15E)

#define P1ACTL     _P(0x160)
#define P1AFLG     _P(0x161)
#define P1ACNTH     _P(0x162)
#define P1ACNTL     _P(0x163)
#define P1ACNT	   _LP(0x162)

//#define RESERVED 0x164-0x17F
#define T2IOS     _P(0x180)
#define T2CFORC   _P(0x181)
#define T2OC7M    _P(0x182)
#define T2OC7D    _P(0x183)

#define T2CNT     _LP(0x184)

#define T2SCR1    _P(0x186)
#define T2TOV     _P(0x187)
#define T2CTL1    _P(0x188)
#define T2CTL2    _P(0x189)
#define T2CTL3    _P(0x18A)
#define T2CTL4    _P(0x18B)
#define T2IE      _P(0x18C)
#define T2SCR2    _P(0x18D)
#define T2FLG1    _P(0x18E)
#define T2FLG2    _P(0x18F)

//#define RESERVED      _LP(0x50)
//#define RESERVED      _LP(0x52)
//#define RESERVED      _LP(0x54)
//#define RESERVED      _LP(0x56)

#define T2C4      _LP(0x198)
#define T2C5      _LP(0x19A)
#define T2C6      _LP(0x19C)
#define T2C7      _LP(0x19E)

#define P2ACTL     _P(0x1A0)
#define P2AFLG     _P(0x1A1)
#define P2ACNTH    _P(0x1A2)
#define P2ACNTL    _P(0x1A3)
#define P2ACNT	   _LP(0x1A2)

//#define RESERVED 0x1B0 - 0x1DF

#define PWMTST	   _P(0x1E6)
#define PWMPRSC	   _P(0x1E7)
#define PWMSCLA	   _P(0x1E8)
#define PWMSCLB	   _P(0x1E9)
#define PWMSCNTA   _P(0x1EA)
#define PWMSCNTB   _P(0x1EB)
#define PWMCNT0	   _P(0x1EC)
#define PWMCNT1	   _P(0x1ED)
#define PWMCNT2	   _P(0x1EE)
#define PWMCNT3	   _P(0x1EF)
#define PWMCNT4	   _P(0x1F0)
#define PWMCNT5	   _P(0x1F1)
#define PWMPER0	   _P(0x1F2)
#define PWMPER1	   _P(0x1F3)
#define PWMPER2	   _P(0x1F4)
#define PWMPER3	   _P(0x1F5)
#define PWMPER4	   _P(0x1F6)
#define PWMPER5	   _P(0x1F7)
#define PWMDTY0	   _P(0x1F8)
#define PWMDTY1	   _P(0x1F9)
#define PWMDTY2	   _P(0x1FA)
#define PWMDTY3	   _P(0x1FB)
#define PWMDTY4	   _P(0x1FC)
#define PWMDTY5	   _P(0x1FD)

//#define RESERVED 0x1FE - 0x1FF

#define PMFCFG0	   _P(0x200)
#define PMFCFG1	   _P(0x201)
#define PMFCFG2	   _P(0x202)
#define PMFCFG3	   _P(0x203)
#define PMFFCTL	   _P(0x204)
#define PMFFPIN	   _P(0x205)
#define PMFFSAT	   _P(0x206)
#define PMFQSMP	   _P(0x207)
#define PMFDMPA	   _P(0x208)
#define PMFDMPB	   _P(0x209)
#define PMFDMPC	   _P(0x20A)
#define PMFOUTC	   _P(0x20C)
#define PMFOUTB	   _P(0x20D)
#define PMFDTMS	   _P(0x20E)
#define PMFCCTL	   _P(0x20F)
#define PMFVAL0	   _LP(0x210)
#define PMFVAL1	   _LP(0x212)
#define PMFVAL2	   _LP(0x214)
#define PMFVAL3	   _LP(0x216)
#define PMFVAL4	   _LP(0x218)
#define PMFVAL5	   _LP(0x21A)
#define PMFENCA	   _P(0x220)
#define PMFFQCA	   _P(0x221)
#define PMFCNTA	   _LP(0x222)
#define PMFMODA	   _LP(0x224)
#define PMFDTMA	   _LP(Ox226)
#define PMFENCB	   _LP(Ox228)
#define PMFCNTB	   _LP(Ox22A)
#define PMFMODB	   _LP(Ox22C)
#define PMFENCC	   _P(Ox230)
#define PMFFQCC	   _P(Ox231)
#define PMFCNTC	   _LP(Ox232)
#define PMFMODC	   _LP(Ox234)
#define PMFDTMC	   _LP(Ox236)

//#define RESERVED _P(0x0238 - 0x023C)

#define PTIM	   _P(0x0251)
#define DRRM	   _P(0x0252)
#define RDDM	   _P(0x0253)
#define PERM	   _P(0x0254)
#define PPSM	   _P(0x0255)
#define WOMM	   _P(0x0256)
//#define RESERVED 		   _P(0x0257)
#define PTP		   _P(0x0258)
#define PTIP	   _P(0x0259)
#define DDRP	   _P(0x025A)
#define RDRP	   _P(0x025B)
#define PERP	   _P(0x025C)
#define PPSP	   _P(0x025D)
//#define RESERVED 	   _P(0x025E)
//#define RESERVED	   _P(0X025F)
#define PTQ		   _P(0x0260)
#define PTIQ	   _P(0x0261)
#define DDRQ	   _P(0x0262)
#define RDRQ	   _P(0x0263)
#define PERQ	   _P(0x0264)
#define PPSQ	   _P(0x0265)
//#define RESERVED 	   _P(0x0266)
//#define RESERVED	   _P(0X0267) 	   
#define PTU		   _P(0x0268)
#define PTIU	   _P(0x0269)
#define DDRU	   _P(0x026A)
#define RDRU	   _P(0x026B)
#define PERU	   _P(0x026C)
#define PPSU	   _P(0x026D)
#define MODRR 	   _P(0x026E)
//#define RESERVED	   _P(0X026F)

#define PTAD		   _LP(0x0270)
#define PTIAD		   _LP(0x0272)
#define DDRAD		   _LP(0x0274)
#define RDRAD		   _LP(0x0276)
#define PERAD		   _LP(0x0278)
#define PPSAD		   _LP(0x027A)
#define PIEAD		   _LP(0x027C)
#define PIFAD		   _LP(0x027E)
//#define RESERVED	   _P(0X0280 - 0X02FF)

//#define Unimplemented _P(0x0300 - 0x03FF)
#endif
