;TestingSCI.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*September 08, 2003           1.00            Initial release
*
*Author: Exequiel Rarama for the ADAPT9S12E128
*******************************************************************************
;Compiled using MiniIDE


#include "E128Regs.INC"

STACK	equ	$3F80


;SCI Variables
;***scimask         equ     %00101100       ;RIE - SCI Interrupt enable
scimask         equ     %00001100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
OscFreq		equ	8000		;Enter Osc speed
initSYNR	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV	equ	$00		;

BusFreq		equ	((OscFreq/(initREFDV+1))*(initSYNR+1))
baud115200	equ	(BusFreq/16)*10/1152  			;sets baud rate to 115,200
baud9600	equ	(BusFreq/16)*10/96  			;sets baud rate to 009,600
initSCI0CR2	equ	$0C					;SCI0 Control Register 2

PLLSEL		equ	%10000000	;PLL select bit
LOCK		equ	%00001000	;lock status bit
PLLON		equ	%01000000	;phase lock loop on bit
LED		equ	%00000001	;Port P bit 0

;------------------------------------------------------------------------------

***************************** Program *******************************

	org	$C000
Start
	sei
	lds	#STACK

;Initialize first Serial Communication Interface
	movw	#baud9600,SCI0BDH	;Set baud rate to 9600
	movb	#scimask,SCI0CR2	;Rx and Tx on
	ldab	SCI0SR1  		;read register to clear flag RDRF
	ldab	SCI0DRL			;read receive buffer

;Initialize 2nd Serial Communication Interface
	movw	#baud9600,SCI1BDH	;Set baud rate to 9600
	movb	#scimask,SCI1CR2	;Rx and Tx on
	ldab	SCI0SR1  		;read register to clear flag RDRF
	ldab	SCI0DRL			;read receive buffer

;Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider
	nop
	nop
	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system

	bset	DDRP,LED
	nop
	bset	PORTP,LED		;Turn on LED

main
	com	PORTP			;Toggle Port P LED

	bsr	delay
	bsr	delay
	bsr	delay
	bsr	delay

	com	PORTP

	bsr	delay
	bsr	delay
	bsr	delay
	bsr	delay


	brclr	SCI0SR1,RDRFflag,CheckSCI1	;check flag is set in SCI0
	bsr	SerInputInt0

	ldx	#MSG1		;Send warning message
	jsr	OutStr0


CheckSCI1
	brclr	SCI1SR1,RDRFflag,main	;check flag is set in SCI1
	bsr	SerInputInt1

	ldx	#MSG2		;Send warning message
	jsr	OutStr1

	bra	main


delay
	ldy #0

dly	
	dbne y,dly
	rts


MSG1	dc.b	'Testing 123 on SCI0',$D,$0A,0
MSG2	dc.b	'Testing 345 on SCI1',$D,$0A,0


;==============================================================================
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.


OutStr0				; send a null terminated string to the display.
	ldaa	1,x+            ; get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput0      ; no. send it out the SCI.
	bra	OutStr0          ; go get the next character.
;
OutStr1				; send a null terminated string to the display.
	ldaa	1,x+            ; get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput1      ; no. send it out the SCI.
	bra	OutStr1          ; go get the next character.

OutStrDone
	rts


;------------------------------------------------------------------------------
SerOutput0
	brclr	SCI0SR1,TDREflag,SerOutput0     ;check if buffer is empty
	staa	SCI0DRL
	rts

SerOutput1
	brclr	SCI1SR1,TDREflag,SerOutput1     ;check if buffer is empty
	staa	SCI1DRL
	rts

SerInputInt0
	ldaa	SCI0SR1                  ;read register to clear flag RDRF
	ldaa	SCI0DRL		          ;read receive buffer
	bra	SIIX

SerInputInt1
	ldaa	SCI1SR1                  ;read register to clear flag RDRF
	ldaa	SCI1DRL		          ;read receive buffer

SIIX
	rts


BAD_INT
	bra BAD_INT		;infinite loop

	org $fff0

	dc.w	BAD_INT; real-time interrupt
	dc.w	BAD_INT; IRQ
	dc.w	BAD_INT; XIRQ
	dc.w	BAD_INT; SWI
	dc.w	BAD_INT; TRAP
	dc.w	BAD_INT; COP
	dc.w	BAD_INT; Clock
	dc.w	Start	; Reset