;Author: Exequiel Rarama
;July 31, 2003
;
;MC68HC9S12E128 REGISTER MAP

REG	EQU	$0000

PORTA		EQU	$0000		;PORTA
PORTB		EQU	$0001		;PORTB
DDRA		EQU	$0002		;PORTA - DATA DIRECTION REGISTER
DDRB		EQU	$0003		;PORTB - DATA DIRECTION REGISTER

PORTE		EQU	$0008		;PORTE
DDRE		EQU	$0009		;PORTE - DATA DIRECTION REGISTER
PEAR		EQU	$000A		;PEAR - PORTE ASSIGNMENT REGISTER
MODE		EQU	$000B		;MODE - MODE REGISTER
PUCR		EQU	$000C		;PUCR - PULL UP CONTROL REGISTER
RDRIV		EQU	$000D		;RDRIV - REDUCED DRIVE OF I/O LINES
EBICTL		EQU	$000E		;EBITCTL - ESTR

INITRM		EQU	$0010		;INITRM - INITIALIZATION OF INTERNAL RAM POSITION REGISTER
INITRG		EQU	$0011		;INITRG - INITIALIZATION OF INTERNAL REGISTER POSITION REGISTER
INITEE		EQU	$0012		;INITEE - INITIALIZATION OF INTERNAL EEPROM POSITION REGISTER
MISC		EQU	$0013		;MISC - MISCELLANEOUS MAPPING CONTROL REGISTER
MTST0		EQU	$0014
ITCR		EQU	$0015
ITEST		EQU	$0016
MTST1		EQU	$0017

VREGCTRL	EQU	$19

PARTIDH		EQU	$001A
PARTIDL		EQU	$001B
MEMSIZ0		EQU	$001C
MEMSIZ1		EQU	$001D

INTCR		EQU	$001E           ;INTCR - INTERRUPT CONTROL REGISTER
HPRIO		EQU	$001F           ;HPRIO - HIGHEST PRIORITY I INTERRRUPT

;Debug12
DBGC1		EQU	$20
DBGSC		EQU	$21
DBGTBH		EQU	$22
DBGTBL		EQU	$23
DBGCNT		EQU	$24
DBGCCX		EQU	$25
DBGCCH		EQU	$26
DBGCCL		EQU	$27
DBGC2		EQU	$28
BKPCT0		EQU	$28
DBGC3		EQU	$29		
BKPCT1		EQU	$29
DBGCAX		EQU	$2A
BKP0X		EQU	$2A
DBGCAH		EQU	$2B
BKP0H		EQU	$2B
DBGCAL		EQU	$2C
BKP0L		EQU	$2C
DBGCBX		EQU	$2D
BKP1X		EQU	$2D

DBGCBH		EQU	$2E
BKP1H		EQU	$2E
DBGCBL		EQU	$2F
BKP1L		EQU	$2F

PPAGE		EQU	$0030

PORTK		EQU	$0032
DDRK		EQU	$0033

;CRG - Clock and Reset Generator
SYNR		EQU	$0034           ;CRG synthesizer register
REFDV		EQU	$0035           ;CRG reference divider register
CTFLG		EQU	$0036
CRGFLG		EQU	$0037		;CRG flags register
CRGINT		EQU	$0038
CLKSEL		EQU	$0039		;CRG clock select register
PLLCTL		EQU	$003A		;CRG PLL control register
RTICTL		EQU	$003B
COPTCTL		EQU	$003C
FORBYP		EQU	$003D
CTCTL		EQU	$003E
ARMCOP		EQU	$003F

;TIM0 - Timer 16 Bit 4 Channels
T0TIOS		EQU	$0040		;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
T0CFORC		EQU	$0041		;CFORC - TIMER COMPARE FORCE REGISTER
T0OC7M		EQU	$0042		;OC7M - OUTPUT COMPARE 7 MASK REGISTER
T0OC7D		EQU	$0043		;OC7D - OUTPUT COMPARE 7 DATA REGISTER

T0TCNT		EQU	$0044
T0TCNTH		EQU	$0044
T0TCNTL		EQU	$0045

T0TSCR1		EQU	$0046		;TSCR - TIMER SYSTEM CONTROL REGISTER
T0TTOV		EQU	$0047
T0TCTL1		EQU	$0048		;TCTL1 - TIMER CONTROL REGISTER 1
T0TCTL3		EQU	$004A		;TCTL3 - TIMER CONTROL REGISTER 3

T0TIE		EQU	$004C

T0TSCR2		EQU	$004D
T0TFLG1		EQU	$004E		;TFLG1 - TIMER INTERRUPT FLAG 1
T0TFLG2		EQU	$004F		;TFLG2 - TIMER INTERRUPT FLAG2

T0TC4		EQU	$0058		;TC4 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
T0TC5		EQU	$005A		;TC5 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
T0TC6		EQU	$005C		;TC6 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
T0TC7		EQU	$005E		;TC7 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0

T0PACTL		EQU	$0060		;PATCL - PULSE ACCUMULATOR CONTROL REGISTER
T0PAFLG		EQU	$0061		;PAFLG - PULSE ACCUMULATOR FLAG REGISTER
T0PACNT		EQU	$0062		;PACN3 - HI BYTE
T0PACNTH	EQU	$0062		;PACN3 - HI BYTE
T0PACNTL	EQU	$0063		;PACN2 - LO BYTE

;ATD - Analog to Digital Converter 10 Bit 16 Channel
ATDCTL0		EQU	$0080		;ATDCTL0 - RESERVED
ATDCTL1		EQU	$0081		;ATDCTL1 - RESERVED
ATDCTL2		EQU	$0082		;ATDCTL2 - ATD CONTROL REGISTER
ATDCTL3		EQU	$0083		;ATDCTL3 - ATD CONTROL REGISTER
ATDCTL4		EQU	$0084		;ATDCTL4 - ATD CONTROL REGISTER
ATDCTL5		EQU	$0085		;ATDCTL5 - ATD CONTROL REGISTER
ATDSTAT0 	EQU	$0086	

ATDTEST0	EQU	$0088	;ATDTEST
ATDTEST1	EQU	$0089	;ATDTEST

ATDSTAT2	EQU	$8A
ATDSTAT1	EQU	$8B

ATDDIEN0	EQU	$8C
ATDDIEN1	EQU	$8D

PORTAD0		EQU	$008E		;PORTAD - PORT AD DATA INPUT REGISTER
PORTAD1		EQU	$008F		;PORTAD - PORT AD DATA INPUT REGISTER

ATDDR0H		EQU	$0090
ATDDR0L		EQU	$0091
ATDDR1H		EQU	$0092
ATDDR1L		EQU	$0093
ATDDR2H		EQU	$0094
ATDDR2L		EQU	$0095
ATDDR3H		EQU	$0096
ATDDR3L		EQU	$0097
ATDDR4H		EQU	$0098
ATDDR4L		EQU	$0099
ATDDR5H		EQU	$009A
ATDDR5L		EQU	$009B
ATDDR6H		EQU	$009C
ATDDR6L		EQU	$009D
ATDDR7H		EQU	$009E
ATDDR7L		EQU	$009F
ATDDR8H		EQU	$00A0
ATDDR8L		EQU	$00A1
ATDDR9H		EQU	$00A2
ATDDR9L		EQU	$00A3
ATDDR10H	EQU	$00A4
ATDDR10L	EQU	$00A5
ATDDR11H	EQU	$00A6
ATDDR11L	EQU	$00A7
ATDDR12H	EQU	$00A8
ATDDR12L	EQU	$00A9
ATDDR13H	EQU	$00AA
ATDDR13L	EQU	$00AB
ATDDR14H	EQU	$00AC
ATDDR14L	EQU	$00AD
ATDDR15H	EQU	$00AE
ATDDR15L	EQU	$00AF

;SCI0 - Asynchronous Serial Interface
SCI0BDH		EQU	$00C8		;SCI0BDH - SCI BAUD RATE CONTROL REGISTER
SCI0BDL		EQU	$00C9		;SCI0BDL - SCI BAUD RATE CONTROL REGISTER
SCI0CR1		EQU	$00CA		;SCI0CR1 - SCI CONTROL REGISTER
SCI0CR2		EQU	$00CB		;SCI0CR2 - SCI CONTROL REGISTER
SCI0SR1		EQU	$00CC		;SCI0SR1 - SCI STATUS REGISTER
SCI0SR2		EQU	$00CD		;SCI0SR2 - SCI STATUS REGISTER
SCI0DRH		EQU	$00CE		;SCI0DRH - SCI DATA REGISTER
SCI0DRL		EQU	$00CF		;SCI0DRL - SCI DATA REGISTER

;SCI1 - Asynchronous Serial Interface
SCI1BDH		EQU	$00D0		;SCI1BDH -
SCI1BDL		EQU	$00D1		;SCI1BDL -
SCI1CR1		EQU	$00D2		;SCI1CR1 -
SCI1CR2		EQU	$00D3		;SCI1CR2 -
SCI1SR1		EQU	$00D4		;SCI1SR1 -
SCI1SR2		EQU	$00D5		;SCI1SR2 -
SCI1DRH		EQU	$00D6		;SCI1DRH -
SCI1DRL		EQU	$00D7		;SCI1DRL -

;SPI - Serial Peripheral Interface
SPI0CR1		EQU	$00D8		;SPI0CR1 - SPI CONTROL REGISTER
SPI0CR2		EQU	$00D9		;SPI0CR2 - SPI CONTROL REGISTER
SPI0BR		EQU	$00DA		;SPI0BR - SPI BAUD RATE REGISTER
SPI0SR		EQU	$00DB		;SPI0SR - SPI STATUS REGISTER
SPI0DR		EQU	$00DD		;SPI0DR - SPI DATA REGISTER

;IIC - Inter-IC Bus
IBAD		EQU	$00E0		;IBAD -
IBFD		EQU	$00E1		;IFBD -
IBCR		EQU	$00E2		;IBCR -
IBSR		EQU	$00E3		;IBSR -
IICDR		EQU	$00E4		;IIBDR -

;SCI2 - Asynchronous Serial Interface
SCI2BDH		EQU	$00E8		;SCI2BDH -
SCI2BDL		EQU	$00E9		;SCI2BDL -
SCI2CR1		EQU	$00EA		;SCI2CR1 -
SCI2CR2		EQU	$00EB		;SCI2CR2 -
SCI2SR1		EQU	$00EC		;SCI2SR1 -
SCI2SR2		EQU	$00ED		;SCI2SR2 -
SCI2DRH		EQU	$00EE		;SCI2DRH -
SCI2DRL		EQU	$00EF		;SCI2DRL -

;DAC0 - Digital to Analog converter
D0DACC0		EQU	$F0
D0DACC1		EQU	$F1
D0DACD		EQU	$F2
D0DACDH		EQU	$F2
D0DACDL		EQU	$F3

;DAC1 - Digital to Analog converter
D1DACC0		EQU	$F0
D1DACC1		EQU	$F1
D1DACD		EQU	$F2
D1DACDH		EQU	$F2
D1DACDL		EQU	$F3

;Flash Control Register
FCLKDIV		EQU	$100
FSEC		EQU	$101
FCNFG		EQU	$103
FPROT		EQU	$104
FSTAT		EQU	$105
FCMD		EQU	$106

;TIM1 (Timer 16 Bit 4 Channels)
T1TIOS		EQU	$0140
T1CFORC		EQU	$0141
T1OC7M		EQU	$0142
T1OC7D		EQU	$0143
T1TCNT		EQU	$0144
T1TCNTH		EQU	$0144
T1TCNTL		EQU	$0145
T1TSCR1		EQU	$0146
T1TTOV		EQU	$0147
T1TCTL1		EQU	$0148

T1TCTL3		EQU	$014A
T1TIE		EQU	$014C
T1TSCR2		EQU	$014D

T1TFLG1		EQU	$014E
T1TFLG2		EQU	$014F

T1TC4		EQU	$0158
T1TC4H		EQU	$0158
T1TC4L		EQU	$0159

T1TC5		EQU	$015A
T1TC5H		EQU	$015A
T1TC5L		EQU	$015B

T1TC6		EQU	$015C
T1TC6H		EQU	$015C
T1TC6L		EQU	$015D

T1TC7		EQU	$015E
T1TC7H		EQU	$015E
T1TC7L		EQU	$015F

T1PACTL		EQU	$160
T1PAFLG		EQU	$161
T1PACNT		EQU	$162
T1PACNTH	EQU	$162
T1PACNTL	EQU	$163

;TIM2 (Timer 16 Bit 4 Channels)
T2TIOS		EQU	$0180
T2CFORC		EQU	$0181
T2OC7M		EQU	$0182
T2OC7D		EQU	$0183
T2TCNT		EQU	$0184
T2TCNTH		EQU	$0184
T2TCNTL		EQU	$0185
T2TSCR1		EQU	$0186
T2TTOV		EQU	$0187
T2TCTL1		EQU	$0188

T2TCTL3		EQU	$018A
T2TIE		EQU	$018C
T2TSCR2		EQU	$018D

T2TFLG1		EQU	$018E
T2TFLG2		EQU	$018F

T2TC4		EQU	$0198
T2TC4H		EQU	$0198
T2TC4L		EQU	$0199
	
T2TC5		EQU	$019A
T2TC5H		EQU	$019A
T2TC5L		EQU	$019B

T2TC6		EQU	$019C
T2TC6H		EQU	$019C
T2TC6L		EQU	$019D

T2TC7		EQU	$019E
T2TC7H		EQU	$019E
T2TC7L		EQU	$019F

T2PACTL		EQU	$1A0
T2PAFLG		EQU	$1A1
T2PACNT		EQU	$1A2
T2PACNTH	EQU	$1A2
T2PACNTL	EQU	$1A3

;PWM (Pulse width Modulator)
PWME		EQU	$1E0	
PWMPOL		EQU	$1E1
PWMCLK		EQU	$1E2
PWMPRCLK	EQU	$1E3
PWMCAE		EQU	$1E4
PWMCTL		EQU	$1E5
PWMTST		EQU	$1E6
PWMPRSC		EQU	$1E7
PWMSCLA		EQU	$1E8
PWMSCLB		EQU	$1E9
PWMSCNTA	EQU	$1EA
PWMSCNTB	EQU	$1EB

PWMCNT0		EQU	$1EC
PWMCNT1		EQU	$1ED
PWMCNT2		EQU	$1EE
PWMCNT3		EQU	$1EF
PWMCNT4		EQU	$1F0
PWMCNT5		EQU	$1F1

PWMPER0		EQU	$1F2
PWMPER1		EQU	$1F3
PWMPER2		EQU	$1F4
PWMPER3		EQU	$1F5
PWMPER4		EQU	$1F6
PWMPER5		EQU	$1F7

PWMDTY0		EQU	$1F8
PWMDTY1		EQU	$1F9
PWMDTY2		EQU	$1FA
PWMDTY3		EQU	$1FB
PWMDTY4		EQU	$1FC
PWMDTY5		EQU	$1FD
PWMSDN		EQU	$1FE

PMFCFG0		EQU	$0200
PMFCFG1		EQU	$0201
PMFCFG2		EQU	$0202
PMFCFG3		EQU	$0203
PMFFCTL		EQU	$0204
PMFFPIN		EQU	$0205
PMFFSTA		EQU	$0206
PMFQSMP		EQU	$0207
PMFDMPA		EQU	$0208
PMFDMPB		EQU	$0209
PMFDMPC		EQU	$020A

PMFOUTC		EQU	$20C
PMFOUTD		EQU	$20D
PMFDTMS		EQU	$020E
PMFCCTL		EQU	$020F

PMFVAL0		EQU	$0210
PMFVAL0H	EQU	$0210
PMFVAL0L	EQU	$211

PMFVAL1		EQU	$0212
PMFVAL1H	EQU	$0212
PMFVAL1L	EQU	$0213

PMFVAL2		EQU	$0214
PMFVAL2H	EQU	$0214
PMFVAL2L	EQU	$0215

PMFVAL3		EQU	$0216
PMFVAL3H	EQU	$0216
PMFVAL3L	EQU	$0217

PMFVAL4		EQU	$0218
PMFVAL4H	EQU	$0218
PMFVAL4L	EQU	$0219

PMFVAL5		EQU	$021A
PMFVAL5H	EQU	$021A
PMFVAL5L	EQU	$021B

;
PMFENCA		EQU	$0220
PMFFQCA		EQU	$221

PMFCNTA		EQU	$222
PMFCNTAH	EQU	$222
PMFCNTAL	EQU	$223

PMFMODA		EQU	$224
PMFMODAH	EQU	$224
PMFMODAL	EQU	$225

PMFDTMA		EQU	$226
PMFDTMAH	EQU	$226
PMFDTMAL	EQU	$227

PMFENCB		EQU	$228
PMFFQCB		EQU	$229

PMFCNTB		EQU	$22A
PMFCNTBH	EQU	$22A
PMFCNTBL	EQU	$22B

PMFMODB		EQU	$22C
PMFMODBH	EQU	$22C
PMFMODBL	EQU	$22D

PMFDTMB		EQU	$22E
PMFDTMBH	EQU	$22E
PMFDTMBL	EQU	$22F

PMFENCC		EQU	$230
PMFFQCC		EQU	$231

PMFCNTC		EQU	$232
PMFCNTCH	EQU	$232
PMFCNTCL	EQU	$233

PMFMODC		EQU	$234
PMFMODCH	EQU	$234
PMFMODCL	EQU	$235

PMFDTMC		EQU	$236
PMFDTMCH	EQU	$236
PMFDTMCL	EQU	$237

PORTT:		equ	$0240	; Port T data register (alternate name).
PTT:		equ	$0240	; Port T data register.
PTIT:		equ	$0241	; Port T input pin register.
DDRT:		equ	$0242	; Port T data direction register.
RDRT:		equ	$0243	; Port T Reduced drive enable register.
PERT:		equ	$0244	; Port T pull up/down enable register.
PPST:		equ	$0245	; Port T pull up/down select (polarity) register.
;
PORTS		equ	$0248	; Port S data register (alternate name).
PTS		equ	$0248	; Port S data register.
PTIS		equ	$0249	; Port S input pin register.
DDRS		equ	$024a	; Port S data direction register.
RDRS		equ	$024b	; Port S Reduced drive enable register.
PERS		equ	$024c	; Port S pull up/down enable register.
PPSS		equ	$024d	; Port S pull up/down select (polarity) register.
WOMS		equ	$024E	; Port S Wired-Or (open drain) select register.

PORTM:		equ	$0250	; Port M data register (alternate name).
PTM:		equ	$0250	; Port M data register.
PTIM:		equ	$0251	; Port M input pin register.
DDRM:		equ	$0252	; Port M data direction register.
RDRM:		equ	$0253	; Port M Reduced drive enable register.
PERM:		equ	$0254	; Port M pull up/down enable register.
PPSM:		equ	$0255	; Port M pull up/down select (polarity) register.
WOMM:		equ	$0256	; Port M Wired-Or (open drain) select register.
;
PORTP:		equ	$0258	; Port P data register (alternate name).
PTP:		equ	$0258	; Port P data register.
PTIP:		equ	$0259	; Port P input pin register.
DDRP:		equ	$025a	; Port P data direction register.
RDRP:		equ	$025b	; Port P Reduced drive enable register.
PERP:		equ	$025c	; Port P pull up/down enable register.
PPSP:		equ	$025d	; Port P pull up/down select (polarity) register.
;
PORTQ:		equ	$0260	; Port Q data register (alternate name).
PTQ:		equ	$0260	; Port Q data register.
PTIQ:		equ	$0261	; Port Q input pin register.
DDRQ:		equ	$0262	; Port Q data direction register.
RDRQ:		equ	$0263	; Port Q Reduced drive enable register.
PERQ:		equ	$0264	; Port Q pull up/down enable register.
PPSQ:		equ	$0265	; Port Q pull up/down select (polarity) register.
PIEQ:		equ	$0266	; Port Q interrupt enable register.
;
PORTU:		equ	$0268	; Port U data register (alternate name).
PTU:		equ	$0268	; Port U data register.
PTIU:		equ	$0269	; Port U input pin register.
DDRU:		equ	$026a	; Port U data direction register.
RDRU:		equ	$026b	; Port U Reduced drive enable register.
PERU:		equ	$026c	; Port U pull up/down enable register.
PPSU:		equ	$026d	; Port U pull up/down select (polarity) register.
MODDRR:		equ	$026e	; Port U interrupt enable register.
;
PTADH		equ	$270	; Port ADH
PTADL		equ	$271	; Port ADL
PTIADH		equ	$272	; Port ADH input pin register.
PTIADL		equ	$273	; Port ADL input pin register.
DDRADH		equ	$274	; Port ADH data direction register
DDRADL		equ	$275	; Port ADL data direction register
RDRADH		equ	$276	; Port ADH Reduced drive enable register.
RDRADL		equ	$277	; Port ADL Reduced drive enable register.
PERADH		equ	$278	; Port ADH pull up/down enable register.
PERADL		equ	$279	; Port ADL pull up/down enable register.
PPSADH		equ	$27A	; Port ADH pull up/down select (polarity) register.
PPSADL		equ	$27B	; Port ADL pull up/down select (polarity) register.
PIEADH		equ	$27C	; Port ADH interrupt enable
PIEADL		equ	$27D	; Port ADL interrupt enable
PIFADH		equ	$27E	
PIFADL		equ	$27F


