;HardwareTest.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*July 17, 2003           1.00            Initial release
*
*Author: Exequiel Rarama for the ADAPT9S12E128
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Demo - HardwareTest Routine
; ---------------------------

	include "E128Regs.INC"

;Public Function
	XDEF HardwareTestGo
	XDEF HardwareTestInit
	XDEF HardwareReady

;Public Variables
	XDEF hardware_state
	XDEF testFlag

;Public Tones

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF SendDecByte		;Hex to Decimal conversion


;External Variables

	XREF adflag

DataSec:	SECTION
Var		ds	3
hardware_state	ds	2
count		ds	1
Error		ds	1
testFlag	ds	1

;

PUPAE		equ	%00000001		;Port A pullup
PUPBE		equ	%00000010
PUPEE		equ	%00010000
PUPKE		equ	%10000000

switch		equ	%01000000		;Port A bit 6

;***********************************************************************************************
CodeSec: 	SECTION
;
HardwareTestInit				;Testing the Hardware ports
	bset	PUCR,PUPAE+PUPBE+PUPEE+PUPKE	;Enable all pull up's

	movb	#$FF,PERT
	movb	#$FF,PERS
	movb	#$FF,PERM
	movb	#$FF,PERP
	movb	#$FF,PERQ
	movb	#$FF,PERU
	movb	#$FF,PERADH
	movb	#$FF,PERADL

	movw	#HardwareReady,hardware_state
	clr	testFlag

goEx
	rts

HardwareReady
	rts


HardwareTestGo
	movw	#WaitForChar,hardware_state
	ldx	#WarningMSG1
	jsr	OutStr0

	ldx	#WarningMSG2
	jsr	OutStr0
	movb	#1,testFlag
	rts

WaitForChar
	ldaa	testFlag
	bne	WaitForCharEx

	movw	#HardwareTestAB,hardware_state
WaitForCharEx
	rts

;----------------------------------------------------------------------------------------------
;H2 header
;Port K <=> Port ADH
;Port Q <=> Port M special case where PQ2 <-> PM7
;Port A <=> Port B

;H1 header
;Port U <=> Port S
;Port T <=> Port ADL
;Port P <=> Port E special case where PP5 <-> PE7 and PE0,PE1 are i/p only

;Note: Port A,B,E do not have dedicated Input Port register

HardwareTestAB
;Start checking on Port A driving B
	ldx	#TestMSG1
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRA	;make Port A o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortB20

CheckPortB10
	lsl	Var

CheckPortB20
	dec	Var+1
	beq	CheckPortBDone
	movb	Var,PORTA

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTB
	cmpb	Var
	beq	CheckPortB10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTB
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortB10	;Go continue the test

CheckPortBDone
	ldaa	Error
	beq	CheckPortBDoneEx10

	ldx	#Error1
	jsr	OutStr0
	bra	CheckPortBDoneEx

CheckPortBDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortBDoneEx
	movw	#HardwareTestBA,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestBA
;Start checking on Port B driving A
	ldx	#TestMSG2
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRB	;make Port B o/p
	movb	#$00,DDRA	;make Port A i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortA20

CheckPortA10
	lsl	Var

CheckPortA20
	dec	Var+1
	beq	CheckPortADone

	movb	Var,PORTB

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTA
	cmpb	Var
	beq	CheckPortA10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTA
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortA10	;Go continue the test

CheckPortADone
	ldaa	Error
	beq	CheckPortADoneEx10

	ldx	#Error5
	jsr	OutStr0
	bra	CheckPortADoneEx

CheckPortADoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortADoneEx
	movw	#HardwareTestADLT,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestADLT
;Initialize Analog To Digital
	movb	#$00,ATDCTL2	        ;enable ATD
	movb	#$00,ATDCTL3	        ;8 Channels ATD result
	movb	#$00,ATDCTL4		;Select Sample rate
	movb	#$00,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#1,adflag

;Start checking on Port ADL driving T
	ldx	#TestMSG5
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRADL	;make Port ADL o/p
	movb	#$00,DDRT	;make Port T i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortT20

CheckPortT10
	lsl	Var

CheckPortT20
	dec	Var+1
	beq	CheckPortTDone

	movb	Var,PTADL

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTT
	cmpb	Var
	beq	CheckPortT10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTT
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortT10	;Go continue the test

CheckPortTDone
	ldaa	Error
	beq	CheckPortTDoneEx10

	ldx	#Error7
	jsr	OutStr0
	bra	CheckPortTDoneEx

CheckPortTDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortTDoneEx
	movw	#HardwareTestTADL,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestTADL
;Start checking on Port T driving ADL
	movb	#$FF,ATDDIEN1		;Enable ATD channel as Digital input

	ldx	#TestMSG4
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRT	;make Port T o/p
	movb	#$00,DDRADL	;make Port ADL i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortADL20

CheckPortADL10
	lsl	Var

CheckPortADL20
	dec	Var+1
	beq	CheckPortADLDone
	movb	Var,PORTT

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PTADL
	cmpb	Var
	beq	CheckPortADL10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PTADL
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortADL10	;Go continue the test

CheckPortADLDone
	ldaa	Error
	beq	CheckPortADLDoneEx10

	ldx	#Error6
	jsr	OutStr0
	bra	CheckPortADLDoneEx

CheckPortADLDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortADLDoneEx
	movb	#$80,ATDCTL2	        ;enable ATD
	movb	#$40,ATDCTL3	        ;8 Channels ATD result
	movb	#$60,ATDCTL4		;Select Sample rate
	movb	#$B0,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#$00,ATDDIEN1		;Disable ATD channel as Digital input
	clr	adflag

	movw	#HardwareTestUS,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestUS
;Start checking on Port U driving S
	ldx	#TestMSG6
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRU	;make Port U o/p
	movb	#$00,DDRS	;make Port B i/p

	movb	#%00000100,Var	;Initialize to 2nd bit
	movb	#7,Var+1	;Initialize counter	
	bra	CheckPortS20

CheckPortS10
	lsl	Var

CheckPortS20
	dec	Var+1
	beq	CheckPortSDone
	movb	Var,PORTU

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTS
	andb	#%11111100	;Mask RXD and TXD
	cmpb	Var
	beq	CheckPortS10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTS
	andb	#%11111100	;Mask RXD and TXD
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortS10	;Go continue the test

CheckPortSDone
	ldaa	Error
	beq	CheckPortSDoneEx10

	ldx	#Error8
	jsr	OutStr0
	bra	CheckPortSDoneEx

CheckPortSDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortSDoneEx
	movw	#HardwareTestSU,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestSU
;Start checking on Port S driving U
	ldx	#TestMSG7
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRS	;make Port S o/p
	movb	#$00,DDRU	;make Port U i/p

	movb	#%00000100,Var	;Initialize to 2nd bit
	movb	#7,Var+1	;Initialize counter	
	bra	CheckPortU20

CheckPortU10
	lsl	Var

CheckPortU20
	dec	Var+1
	beq	CheckPortUDone

	movb	Var,PORTS

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTU
	andb	#%11111100	;Mask RXD and TXD
	cmpb	Var
	beq	CheckPortU10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTU
	andb	#%11111100	;Mask RXD and TXD
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortU10	;Go continue the test

CheckPortUDone
	ldaa	Error
	beq	CheckPortUDoneEx10

	ldx	#Error9
	jsr	OutStr0
	bra	CheckPortUDoneEx

CheckPortUDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortUDoneEx
	movw	#HardwareTestKADH,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestKADH
;Start checking on Port K driving ADH
	movb	#$FF,ATDDIEN0	;Enable ATD channel as Digital input

	ldx	#TestMSG8
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRK	;make Port K o/p
	movb	#$00,DDRADH	;make Port ADH i/p

	movb	#%1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortADH20

CheckPortADH10
	lsl	Var

CheckPortADH20
	dec	Var+1
	beq	CheckPortADHDone
	movb	Var,PORTK

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PTADH
	cmpb	Var
	beq	CheckPortADH10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PTADH
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortADH10	;Go continue the test

CheckPortADHDone
	ldaa	Error
	beq	CheckPortADHDoneEx10

	ldx	#Error10
	jsr	OutStr0
	bra	CheckPortADHDoneEx

CheckPortADHDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortADHDoneEx
	movb	#$00,ATDDIEN0	;Disable ATD channel as Digital input
	movw	#HardwareTestADHK,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestADHK
;Start checking on Port ADH driving K
	ldx	#TestMSG9
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRADH	;make Port ADH o/p
	movb	#$00,DDRK	;make Port K i/p

	movb	#%1,Var		;Initialize to 2nd bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortK20

CheckPortK10
	lsl	Var

CheckPortK20
	dec	Var+1
	beq	CheckPortKDone

	movb	Var,PTADH

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTK
	cmpb	Var
	beq	CheckPortK10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTK
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortK10	;Go continue the test

CheckPortKDone
	ldaa	Error
	beq	CheckPortKDoneEx10

	ldx	#Error11
	jsr	OutStr0
	bra	CheckPortKDoneEx

CheckPortKDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortKDoneEx
	movw	#HardwareTestQM,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestQM
;Start checking on Port Q driving Port M
	ldx	#TestMSG10
	jsr	OutStr0

	clr	Error

	movb	#$7F,DDRQ	;make Port Q o/p
	movb	#$00,DDRM	;make Port M i/p

	ldab	#%00000001
	stab	PORTQ
	stab	Var

	jsr	littleDelay

	ldab	PORTM
	cmpb	Var
	beq	Mbit1
	jsr	SendMErr

Mbit1
	ldab	#%00000010
	stab	PORTQ
	stab	Var

	jsr	littleDelay

	ldab	PORTM
	cmpb	Var
	beq	Mbit2
	jsr	SendMErr

Mbit2
	ldab	#%00000100
	stab	PORTQ

	jsr	littleDelay

	ldab	PORTM
	cmpb	#%10000000
	beq	Mbit3
	jsr	SendMErr

Mbit3
	movb	#%00001000,Var	;Initialize to 1st bit
	movb	#5,Var+1	;Initialize counter	
	bra	CheckPortM20

CheckPortM10
	lsl	Var

CheckPortM20
	dec	Var+1
	beq	CheckPortMDone

	movb	Var,PORTQ

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTM
	cmpb	Var
	beq	CheckPortM10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortM10	;Go continue the test

CheckPortMDone
	ldaa	Error
	beq	CheckPortMDoneEx10

	ldx	#Error12
	jsr	OutStr0

	ldx	#Error14
	jsr	OutStr0

	bra	CheckPortMDoneEx

CheckPortMDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortMDoneEx
	movw	#HardwareTestMQ,hardware_state
	rts

SendMErr
	ldx	#Error2
	jsr	OutStr0

	ldab	PORTQ
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	rts


littleDelay
	clrb
	dbne	b,*           ;delay to allow sw pin to pull up
	rts

;----------------------------------------------------------------------------------------------
HardwareTestMQ
;Start checking on Port M driving Q
	ldx	#TestMSG11
	jsr	OutStr0

	clr	Error

	movb	#%11111011,DDRM	;make Port M o/p
	movb	#$00,DDRQ	;make Port Q i/p

	ldab	#%00000001
	stab	PORTM
	stab	Var

	jsr	littleDelay

	ldab	PORTQ
	cmpb	Var
	beq	Qbit1
	jsr	SendMErr

Qbit1
	ldab	#%00000010
	stab	PORTM
	stab	Var

	jsr	littleDelay

	ldab	PORTQ
	cmpb	Var
	beq	Qbit2
	jsr	SendMErr

Qbit2
	ldab	#%10000000
	stab	PORTM

	jsr	littleDelay

	ldab	PORTQ
	cmpb	#%00000100
	beq	Qbit3
	jsr	SendQErr

Qbit3
	movb	#%00001000,Var	;Initialize to 3nd bit
	movb	#5,Var+1	;Initialize counter	
	bra	CheckPortQ20

CheckPortQ10
	lsl	Var

CheckPortQ20
	dec	Var+1
	beq	CheckPortQDone

	movb	Var,PORTM

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTQ
	cmpb	Var
	beq	CheckPortQ10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTQ
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortQ10	;Go continue the test

CheckPortQDone
	ldaa	Error
	beq	CheckPortQDoneEx10

	ldx	#Error13
	jsr	OutStr0

	ldx	#Error14
	jsr	OutStr0

	bra	CheckPortQDoneEx

CheckPortQDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortQDoneEx
	movw	#HardwareTestPE,hardware_state
	rts

SendQErr
	ldx	#Error2
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTQ
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	rts

;---------------------------------------------------------------------------------------------
HardwareTestPE
;Start checking on Port P driving E
	ldx	#TestMSG12
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRP	;make Port P o/p
	movb	#$00,DDRE	;make Port E i/p

	movb	#%1,Var		;Initialize to 2nd bit
	movb	#6,Var+1	;Initialize counter	
	bra	CheckPortE20

CheckPortE10
	lsl	Var

CheckPortE20
	dec	Var+1
	beq	CheckPortEDone

	movb	Var,PORTP

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTE
	cmpb	Var
	beq	CheckPortE10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTE
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortE10	;Go continue the test

CheckPortEDone
	ldaa	Error
	beq	CheckPortEDoneEx10

	ldx	#Error15
	jsr	OutStr0

CheckPortEDoneEx10
	movb	#%00100000,PORTP	;Make Port P bit 5 high to check Port E bit 7

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTE
	cmpb	#%10000000		;Check if Port bit 7 is high
	beq	CheckElow

	ldx	#Error2
	jsr	OutStr0

	ldab	PORTP
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTE
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag

	ldx	#Error16
	jsr	OutStr0

CheckElow
	clr	PORTP	;Make Port P bit 5 low to check Port E bit 7	

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTE
	cmpb	#0
	beq	CheckPortEDoneEx20

	ldx	#Error2
	jsr	OutStr0

	ldab	PORTP
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTE
	jsr	SendDecByte	;Convert Value

	ldx	#Error16
	jsr	OutStr0

	movb	#1,Error	;Set error flag

CheckPortEDoneEx20
	ldaa	Error
	bne	CheckPortEDoneEx	

	ldx	#TestMSG3
	jsr	OutStr0

CheckPortEDoneEx
	movw	#HardwareReady,hardware_state

	ldx	#WarningMSG3
	jsr	OutStr0

	rts

;----------------------------------------------------------------------------------------------
WarningMSG1	dc.b	$D,$A,'Remove Jumper Block JB1, JB6, JB7 and JB8',$D,$A,0
WarningMSG2	dc.b	'Press Any Key when READY',$D,$A,0
WarningMSG3	dc.b	$D,$A,'Press RESET when DONE',$D,$A,0

TestMSG1	dc.b	$D,$A,'Test ->Port A driving Port B on H2',$D,$A,0
TestMSG2	dc.b	$D,$A,'Test ->Port B driving Port A on H2',$D,$A,0
TestMSG3	dc.b	'Pass',$D,$A,0

TestMSG4	dc.b	$D,$A,'Test ->Port T driving Port ADL on H1',$D,$A,0
TestMSG5	dc.b	$D,$A,'Test ->Port ADL driving Port T on H1',$D,$A,0

TestMSG6	dc.b	$D,$A,'Test ->Port U driving Port S on H1',$D,$A,0
TestMSG7	dc.b	$D,$A,'Test ->Port S driving Port U on H1',$D,$A,0

TestMSG8	dc.b	$D,$A,'Test ->Port K driving Port ADH on H2',$D,$A,0
TestMSG9	dc.b	$D,$A,'Test ->Port ADH driving Port K on H2',$D,$A,0

TestMSG10	dc.b	$D,$A,'Test ->Port Q driving Port M on H2',$D,$A,0
TestMSG11	dc.b	$D,$A,'Test ->Port M driving Port Q on H2',$D,$A,0

TestMSG12	dc.b	$D,$A,'Test ->Port P driving Port E on H1',$D,$A,0

Error1		dc.b	$D,$A,'Fail ->Port A driving Port B on H2',$D,$A,0
Error2		dc.b	$D,$A,'Sent    ',0
Error3		dc.b	$D,$A,'Receive ',0

Error5		dc.b	$D,$A,'Fail ->Port B driving Port A on H2',$D,$A,0

Error6		dc.b	$D,$A,'Fail ->Port T driving Port ADL on H1',$D,$A,0
Error7		dc.b	$D,$A,'Fail ->Port ADL driving Port T on H1',$D,$A,0

Error8		dc.b	$D,$A,'Fail ->Port U driving Port S on H1',$D,$A,0
Error9		dc.b	$D,$A,'Fail ->Port S driving Port U on H1',$D,$A,0

Error10		dc.b	$D,$A,'Fail ->Port K driving Port ADH on H2',$D,$A,0
Error11		dc.b	$D,$A,'Fail ->Port ADH driving Port K on H2',$D,$A,0

Error12		dc.b	$D,$A,'Fail ->Port Q driving Port M on H2',$D,$A,0
Error13		dc.b	$D,$A,'Fail ->Port M driving Port Q on H2',$D,$A,0
Error14		dc.b	'Ignore Port M and Q Error if IrDA is stuffed',$D,$A,0

Error15		dc.b	$D,$A,'Fail ->Port P bit 0-4 driving Port E 0-4 on H1',$D,$A,0
Error16		dc.b	$D,$A,'Fail ->Port P bit 5 driving Port E bit 7 on H1',$D,$A,0

	END

	ldab	Var+3
	pshb

	lsrb
	lsrb
	lsrb
	lsrb
	abx
	ldx	#BinTable

BinTable
	dc.b	'0000'	;0
	dc.b	'0001'	;1
	dc.b	'0010'	;2
	dc.b	'0011'	;3

	dc.b	'0100'	;4
	dc.b	'0101'	;5
	dc.b	'0110'	;6
	dc.b	'0111'	;7

	dc.b	'1000'	;8
	dc.b	'1001'	;9
	dc.b	'1010'	;A
	dc.b	'1011'	;B

	dc.b	'1100'	;C
	dc.b	'1101'	;D
	dc.b	'1110'	;E
	dc.b	'1111'	;F

