;RAMTest.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*July 17, 2003           1.00            Initial release
*
*Author: Exequiel Rarama for the ADAPT9S12E128
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Demo - RAM Test Routine
; ---------------------------

	include "E128Regs.INC"

;Public Function
	XDEF CheckExternalRAM

;Public Variables
	XDEF expandedFlag

;Public Tones

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF SendDecByte		;Hex to Decimal conversion
	XREF HardwareReady

;External Variables
	XREF hardware_state


DataSec:	SECTION
expandedFlag	ds	1
Var		ds	2
count		ds	1

;-----------------------------------------------------------------------------------------
CodeSec: 	SECTION

CheckExternalRAM
	movw	#goCheckRAM,hardware_state

	ldx	#RamTest		;Send Ram testing message
	jsr	OutStr0		
	rts

;---------------------------------------------------------------------------------------------
goCheckRAM
	movb	#$0C,PEAR		;$0C ->Enable LSTRE,RDWE = 1
	movb	#$E3,MODE		;$E3 -> Enable MODC,MODA,MODB,EMK,EME = 1
	movb	#$01,EBICTL		;$01 -> Enable ESTR = 1
	movb	#$0D,MISC		;$0F ->Enable EXSTR1, EXSTR0,ROMHM,ROMON = 1

	movw	#$AAAA,Var
	movb	#2,count		;Count how many loops

Check2Loop
	movb	#$10,PPAGE

CheckLoop10
	ldy	#$8000			;Beginning of RAM
	ldd	Var			;Value to be written

CheckLoop20
	std	2,y+			;Store DATA to RAM
	cpy	#$C000			;check if end of RAM		
	bne	CheckLoop20		;Loop until end of RAM

	ldd	Var			;Value to be written	
	ldy	#$8000			;Beginning of RAM

CheckLoop30
	cpy	#$C000
	beq	CheckLoop40

	cpd	2,y+			;Compare previous save DATA to Reg D
	beq	CheckLoop30		;Compare till end of RAM
	bra	CheckLoop50		;Error with the compare

CheckLoop40
	ldab	#$18
	cmpb	PPAGE			;Check if Last Page of RAM
	beq	loop2			;Yes end of Page RAM

	inc	PPAGE			;If not end go back and save and compare data
	bra	CheckLoop10

loop2
	dec	count
	beq	loopEx
	
	ldd	Var
	coma
	comb
	std	Var
	bra	Check2Loop		;Check a 2nd time

CheckLoop50
	ldx	#Error1			;Send Error
	jsr	OutStr0
	movw	#HardwareReady,hardware_state
	rts

loopEx
	ldx	#RamTestOk		;Send Error
	jsr	OutStr0
	movw	#HardwareReady,hardware_state
	rts


;*****************************************************************************************
RamTest		dc.b	'WARNING!! Testing External RAM',$D,$A,0
RamTestOk	dc.b	'Ram External Test Ok',$D,$A,0
Error1		dc.b	'RAM Error',$D,$A,0

	END



