
/*------------------------------------------------------------------------------
	critical.h
		
	Author : Pierre Morency <pmorency@globetrotter.net>

	Created: 15.may.2004
	Revised: 
--------------------------------------------------------------------------------

 Copyright  2004, Pierre Morency.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

    * Neither the name of author nor the names of its contributors
      may be used to endorse or promote products derived from this
      software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

------------------------------------------------------------------------------*/

#ifndef CRITICAL_H
#define CRITICAL_H 1


#define NOP() __asm__("nop\n")
#define SEI() __asm__("sei\n")
#define CLI() __asm__("cli\n")
 

/* Note: ENTER_CRITICAL() and EXIT_CRITICAL() calls cannot be nested */

#ifndef cpu_sr
#define ENTER_CRITICAL() unsigned short cpu_sr; __asm__ __volatile__ ("tpa\n sei\n" : "=d"(cpu_sr)) 
#else
#define ENTER_CRITICAL() __asm__ __volatile__ ("tpa\n sei\n" : "=d"(cpu_sr))
#endif

#define EXIT_CRITICAL()  __asm__ __volatile__ ("tap\n" : : "d"(cpu_sr))


#endif

