
/*------------------------------------------------------------------------------
	lan91c111.h
		
	Author : Pierre Morency <pmorency@globetrotter.net>

	Created: 14.apr.2004
	Revised: 02.jun.2004 - Pre-release version
		     08.jun.2004 - Release V1.0
--------------------------------------------------------------------------------

 Copyright  2004, Technological Arts <www.technologicalarts.com>
 Copyright  2004, Pierre Morency
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

    * Neither the name of the copyright holders nor the names of their
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

------------------------------------------------------------------------------*/

#ifndef LAN91C111_H
#define LAN91C111_H 1

#include "datatypes.h"

/* 48-bit MAC address type for local use */
typedef union		
{
	uint8  byte[6];
	uint16 word[3];

} MAC_address;	



enum { CARD_ADDRESS = 0x8000, CARD_PAGE = 0 };

/* Note: lan_card_init() must be called in single chip mode with the
   address of a 50msec delay routine as argument, then the CPU must
   be switched in expanded mode before using the other functions */

void lan_card_init(void (*)(void));	



/* Starts the auto-negociation process and prepares the ethernet card to receive
   and transmit ethernet frames. Both status LEDs should turn on. Returns the
   MAC address via the 'pa' pointer and exits with a status code.
 
   A 0xFFFF status indicates a problem, otherwise the status code
   comes from the register #18 of the PHY MII. (See status.pdf) */

uint16 ethernet_open(MAC_address *pa);



/* Calling this function stops the lan card from receiving and transmitting.
   A call to ethernet_open() is necessary to restart communication */
   
void ethernet_close(void);				



/* This function returns immediately with zero when no data has been received.
   When data is available, it returns the number of bytes obtained from the
   network and places them in the caller's buffer having 'maxlen' size. */
   
uint16 ethernet_get(void *buf, uint16 maxlen);



/* This function is called to transmit data over the network.
   Data is fetched from both the uip_buffer and the application data buffer */
   
void ethernet_put(void *buf, void *appdata, uint16 len, uint16 header_len);



/* This is the lan card interrupt service routine. This address should be
   placed in the vector table at the IRQ entry. (see mc9s12e_vectors.s file) */
   
void ethernet_service(void) __attribute__((interrupt));

#endif


/*------------------------------------------------------------------------------
	END
------------------------------------------------------------------------------*/


