
/*------------------------------------------------------------------------------
	mc9s12e_vectors.s
		
	MC9S12E-Family interrupt vector table
			
	Author : Pierre Morency <pmorency@globetrotter.net>

	Created: 13.may.2004
	Revised: 
--------------------------------------------------------------------------------

 Copyright  2004, Pierre Morency.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

    * Neither the name of author nor the names of its contributors
      may be used to endorse or promote products derived from this
      software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

------------------------------------------------------------------------------*/

	.sect .text
	.globl _start

;; Default interrupt handler.
	.sect .text

def:	rti

;; Interrupt vectors are in a specific section that is mapped at 0xff80.
;; The reset handler points to the generic _start entry point.

	.sect .vectors
	.globl vectors

vectors:

	.word def					; ff80 (reserved)
	.word def					; ff82 (reserved)
	.word def					; ff84 (reserved)
	.word def					; ff86 (reserved)

	.word def					; ff88 (PWM emergency)
	.word def					; ff8a (VREG LVI)
	.word def					; ff8c (PMF fault 3)
	.word def					; ff8e (PMF fault 2)
	.word def					; ff90 (PMF fault 1)
	.word def					; ff92 (PMF fault 0)
	.word def					; ff94 (PMF generator C)
	.word def					; ff96 (PMF generator B)
	.word def					; ff98 (PMF generator A)
	
	.word def					; ff9a (PAI)
	.word def					; ff9c (PAOVI)
	.word def					; ff9e (TOI)
	.word def					; ffa0 (timer 2, channel 7)
	.word def					; ffa2 (timer 2, channel 6)
	.word def					; ffa4 (timer 2, channel 5)
	.word def					; ffa6 (timer 2, channel 4)

	.word def					; ffa8 (reserved)
	
	.word def					; ffaa (PAI)
	.word def					; ffac (PAOVI)
	.word def					; ffae (TOI)
	.word def					; ffb0 (timer 1, channel 7)
	.word def					; ffb2 (timer 1, channel 6)
	.word def					; ffb4 (timer 1, channel 5)
	.word def					; ffb6 (timer 1, channel 4)
	.word def					; ffb8 (FLASH)

	.word def					; ffba (reserved)
	.word def					; ffbc (reserved)
	.word def					; ffbe (reserved)
	.word def					; ffc0 (IIC Bus)
	.word def					; ffc2 (reserved)
	
	.word def					; ffc4 (Self clock)
	.word def					; ffc6 (PLL lock)

	.word def					; ffc8 (reserved)
	.word def					; ffca (reserved)
	.word def					; ffcc (reserved)
	
	.word def					; ffce (Port AD)
	.word def					; ffd0 (ATD)
	.word def		 			; ffd2 (SCI2)
	.word def		     		; ffd4 (SCI1)
	.word def              		; ffd6 (SCI0)
	.word def					; ffd8 (SPI)
	
	.word def					; ffda (PAII)
	.word def					; ffdc (PAOVI)
	.word def					; ffde (TOI)
	.word def					; ffe0 (timer 0, channel 7)
	.word def					; ffe2 (timer 0, channel 6)
	.word def					; ffe4 (timer 0, channel 5)
	.word def					; ffe6 (timer 0, channel 4)

	.word def					; ffe8 (reserved)
	.word def					; ffea (reserved)
	.word def					; ffec (reserved)
	.word def					; ffee (reserved)

	.word timers_service		; fff0 (RTI)
	.word ethernet_service		; fff2 (IRQ)
	.word def					; fff4 (XIRQ)
	.word def		  			; fff6 (SWI)
	.word def					; fff8 (Illegal OP) 
	.word def		    		; fffa (COP Failure)
	.word def					; fffc (COP Clock monitor)
	.word _start				; fffe (power-on reset)
