/*******************************************************************
 *                   MOTOROLA INTERNAL USE ONLY
 *
 *    DESCRIPTION:   CRG init and rti handler
 *    SOURCE:        crg.c
 *    COPYRIGHT:      07/2002  Made in the USA
 *    AUTHOR:        rat579 
 *    REV. HISTORY:  (not yet)  
 *
 *******************************************************************/
#include "projectglobals.h"
     
/* External Functions */
extern tU08 rti_once_event(void);
extern void rti_1st_event(void);
extern void rti_2nd_event(void);
extern void rti_3rd_event(void);
extern void rti_4th_event(void);
extern void rti_5th_event(void);
extern void rti_6th_event(void);


/* Internal Functions */
void crg_init(void); 
void update_clock(void);
void rti_handler(void);
void LockPll(void);

/* External Variable Declarations */

/* Local Variable Declarations */
tU16 rti_1st_mult;
tU16 rti_2nd_mult;
tU16 rti_3rd_mult;
tU16 rti_4th_mult;
tU16 rti_5th_mult;
tU16 rti_6th_mult;
tU08 rti_tic_rate;

tU08 blink(void);
/***************************************************************************
** blink
***************************************************************************/
tU08 blink(void)
{
  Pim.ptp.byte = Pim.ptp.byte ^ PTP0;
  Regs.portb.byte = Regs.portb.byte ^ PTB0;
  return 1; /* return 1 for successful*/
}
//******************************************************************
//** 
//**               events
//** 
//******************************************************************

 void rti_1st_event(void)
    {
    }
 void rti_2nd_event(void)
    {
    }
 void rti_3rd_event(void)
    {
    }
 void rti_4th_event(void)
    {
    }
 void rti_5th_event(void)
    {
    (void) blink();
    }
 void rti_6th_event(void)
    {
    }
    
/**********************************************************************/
/**		Title: CRG Initialization Subroutine		                 **/
/**		Author: rat579                                               **/
/**     COPYRIGHT:      07/2002  Made in the USA                    **/
/**     Description: This subroutine initializes the CRG on the      **/
/**		HCS12.                                                       **/
/**********************************************************************/

/**********************************************************************
** lock pll
***********************************************************************/
void LockPll(void)
{
 SEI();
 while (Crg.crgflg.bit.lock==0)
 CLI();      
 Crg.clksel.bit.pllsel = 1 ;                  // engage PLL...
 pllclk = (2*oscclk*(Crg.synr.byte+1))/(Crg.refdv.byte+1);
 busclk=pllclk/2;
}
/**********************************************************************/
void crg_init(void)  // subroutine to initialize HCS12 CRG
{
	rti_1st_mult = 10;            //   100ms   event1
	rti_2nd_mult = 20;            //   200ms   event2
	rti_3rd_mult = 30;            //   300ms   event3
	rti_4th_mult = 40;            //   400ms   event4
	rti_5th_mult = 50;            //   500ms   event5
	rti_6th_mult = 60;            //   600ms   event6
	rti_tic_rate = 10;            //   global scaler
	
	Crg.clksel.bit.syswai = 1;
	Crg.clksel.bit.pstp = 1;        // enable P-Stop
	Crg.pllctl.bit.pre = 1;         // enable RTI in P-Stop
/**********************************************************************/
Crg.clksel.bit.pllsel = 0 ;           // disengage PLL...
if (oscclk == 16000)
	{
	   Crg.rtictl.byte = 0x41;         // oscclk/1024/rti (16Mhz osc)
       Crg.synr.byte   = 0x04;         // muliply by 5
	   Crg.refdv.byte  = 0x01;         // divide by 2
	}
 (void) LockPll();
     SEI();
 Crg.crgint.bit.rtie = 1;              // enable rti (local)
}

/***************************************************************************
** update clock
** 
** 
***************************************************************************/
void update_clock(void)
{
    if (rti_count % 15625 != 0)
        {
        run_time++;
        }
    else                             // this adjust clock for 1.024 ms tics
        {
        run_time = run_time+375;     // 15625 tics should be 16000 ms (+375)
        }
    if (run_time >= 86400000-1)      // 86400000 ms = 24 hours
        {                            // it's 12 midnight change date
        run_time = 0;
        }
}
/**************************************************************************
* Name: RTI_Handler
*   This procedure is the interrupt handler for the Real Time Interrupt.
*
* Shared Variables:
*
*  Updates:
//	  Crg.crgflg.bit.rtif = 1;                      // Do Not do this.
//    Crg.crgflg.byte |= (crg.crgflg.byte & RTIF);  // this works also 
**************************************************************************/
void rti_handler(void)
{
	Crg.crgflg.byte = RTIF;          //   Clear_RTI_Flag
    rti_count++;
    CLI();                          // Enable global interrupts
    (void) update_clock();
    if( ((rti_count % rti_tic_rate) == 0))      
    {
      run_count++;

      // Channel 1 updates
      if( ( run_count % rti_1st_mult ) == 0 )
      {
       (void)rti_1st_event();
      }
      // Channel 2 updates
      if( ( run_count % rti_2nd_mult ) == 0 )
      {
       (void)rti_2nd_event();
      }
      // Channel 3 updates
      if( ( run_count % rti_3rd_mult ) == 0 )
      {
       (void)rti_3rd_event();
      }
      // Channel 4 updates
      if( ( run_count % rti_4th_mult ) == 0 )
      {
       (void)rti_4th_event();
      }
      // Channel 5 updates
      if( ( run_count % rti_5th_mult ) == 0 )
      {
       (void)rti_5th_event();
      }
      // Channel 6 updates
      if( ( run_count % rti_6th_mult ) == 0 )
      {
       (void)rti_6th_event();
      }
   }
}

