/*******************************************************************
 *                   MOTOROLA INTERNAL USE ONLY
 *
 *    DESCRIPTION:   
 *    SOURCE:        main.c
 *    COPYRIGHT:      07/2002  Made in the USA
 *    AUTHOR:        rat579 
 *    REV. HISTORY:  (not yet)  
 *
 *******************************************************************/
#include <hidef.h>
#include "output.h"
#include "projectglobals.h"

extern void rti_handler(void);
extern void tim0_ch7_handler(void);
extern void crg_init(void); 
extern void LockPll(void);

/* Local Variable Declarations */
tU32 oscclk, busclk, pllclk;
tU32 run_time, rti_count, run_count;

int sampleCounter=2,     /*Variable used to count current sample location in array. Offset*/ 
                        /*at 2 to avoid counting 1st 2 bytes of size data */
    samplePlayFlag=0,    /*Used to flag main procedure that end of array has been detected */  
    sampleControl=0,    /*Used to control value of current page data is being read from */ 
    z;                    /*Simple loop control variable */

unsigned long arraySize;            /*Stores size of current array */
const unsigned char *far wavPtr;    /*Far pointer used to mark current point in paged memory*/

union     {                                /*Union to allow type long variable (array size) to */
           unsigned long wavSize_long;     /*be read in 2 chunks and then made a long */ 
           unsigned char wavSize_char[2];
           } wavSize;
    
int dSamplePos;
/*******************************************************************
 *          tim0_init - Timer 0 used for sample timer
 *******************************************************************/
void tim0_init(void){
    Tim0.tscr2.byte = 0x00;    // prescale is (0x00+1)/2   <-- prescale needs fixed in h file
    Tim0.tios.bit.ios7 = 1;    // 1 = channel seven used to reduce main free run counter
                                // nom = bus / 2 / 0xFFFF ; ~5 ms at 24 MHz CPU.
    Tim0.tctl1.bit.ol7 = 1;    
    Tim0.tctl1.bit.om7 = 0;    // 1 , 0 = toggle channel 7 for measurement.
    Tim0.ttov.bit.tov7 = 1;                             
    Tim0.tscr2.bit.tcre = 1;   // 1 = allow channel 7 to reset main counter.
    Tim0.tc[7] = 0x0716;       // start with 1/2 total count
    Tim0.tie.bit.c7i = 1;      // enable timer 7 int on OC
    Tim0.tscr1.bit.ten = 1;    // 1 = Start up the timer !!!
    return;
}

#pragma CODE_SEG NON_BANKED        
void main(){
     oscclk = 16000;
     crg_init();
     LockPll();
     tim0_init();
     dSamplePos = 0;
     samplePlayFlag = 1;
     Pim.ddrp.byte=0xFF;
     Crg.crgint.byte = 0x80;
     Dac0.dacc0.byte = 0x89;    
     Dac1.dacc0.byte = 0x89;
     CLI();

while(1)     /* Forever loop */             
{
  if( run_time % (0x000DBBA0) == 0 )  //  every 15 min
  {    
    for (sampleControl=0; sampleControl<=5; sampleControl++) /*Play all n (in this example 3) pages*/
                
                /*Note that while variable in for loop above should be set to (number of WAV pages)-1, depening on*/
                /*number of pages produces by arraycreator.c. Likewise the sampleControl if statements below should*/
                /*be added to or deleted depending of this value.*/
                
                {                                            
                    samplePlayFlag = 0; /*Reset flag from ISR */

                    if (sampleControl == 0)     /*If first time around loop*/
                        wavPtr = wav01;            /*Point at first sample*/                    
                    if (sampleControl == 1)        /*If second time around loop*/
                        wavPtr = wav02;            /*Point at second sample*/
                    if (sampleControl == 2)        /*Etc.*/
                        wavPtr = wav03;        
                    if (sampleControl == 3)
                        wavPtr = wav04;        
                    if (sampleControl == 4)
                        wavPtr = wav05;        
                    if (sampleControl == 5)
                        wavPtr = wav06;        
//                    if (sampleControl == 6)
//                        wavPtr = wav07;        
                    
                    wavSize.wavSize_long = 0;     /*Reset wavesize to 0*/
                
                       for (z=0; z<=1; z++)        /*Loop for 2 count */
                           wavSize.wavSize_char[z] = *(wavPtr + z);     /*Read array page size from first 2 array elements*/
                               
                    arraySize = ((wavSize.wavSize_long) >> 16);        /*Bitwise shift to move data to readable location*/
                     
                    while (samplePlayFlag==0)    /*Delay until sample played*/
                        (1);                    /*Wait*/
                }
            }
        }
}        
#pragma CODE_SEG DEFAULT
/*******************************************************************
 *                   tim0_ch7_handler
 *******************************************************************/
void tim0_ch7_handler(){
    if (sampleCounter<(arraySize) & (samplePlayFlag ==0))                    /* If not end of file */
    {    
        Dac0.dacdr = Dac1.dacdr =  *(wavPtr + sampleCounter);     /* Load sample to PWM duty register */
        sampleCounter ++;                             /*Increment sampleCounter */
//        Dac1.dacdr =  *(wavPtr + sampleCounter);     /* Load sample to PWM duty register */
//        sampleCounter ++;                             /*Increment sampleCounter */
    }    
    else
    {
        sampleCounter = 2;             /*Reset sample counter (offset to avoid reading size of file data) */
        samplePlayFlag = 1;         /*Set flag to inform main sample has been played */
    }
   Tim0.tflg1.byte = C7F;      // Clear OC flag 
   return;
}
