/******************************************************************************
*                                             COPYRIGHT (c) MOTOROLA 2002   
* FILE NAME: projectglobals.h     REVISION 1.0                                        
*                                                                           
* PURPOSE: header file for project level defines global variables
*		   and includes module drivers.  							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE METROWERKS COMPILER AND **  
**      THE HCS12 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.       **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  project setup (peripherals and drivers)        
*                                                                           
* NOTE: Modify this file to specify which maskset peripheral you are using by
*		uncommenting desired maskset peripheral file. Also uncomment the 
*		drivers which are used by your main application.  
*                                                                           
* AUTHOR: Eduardo Montanez    LOCATION: OHT     LAST EDIT DATE: 04/02/02  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe    	03/11/02	- Original coding                                         
*                                                                           
******************************************************************************/

/*===========================================================================*/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/

#ifndef PROJECTGLOBALS_H        /*prevent duplicated includes*/
#define PROJECTGLOBALS_H

/*****************************************************************************/
/*Global Includes															 */
/*****************************************************************************/

#include <hidef.h>				//Includes Code Warrior definitions	
#include <stdlib.h>
#include "projectvectors.h"		//Includes Vector prototypes

/*****************************************************************************/
/*Mask Set Selection		//Modify below to select maskset peripheral file */
/*****************************************************************************/

//#define DP256_1K79X
#define E128_0L08M
//#define D64_0L86D
//#define A256_1K79X
//#define H256_0K78X
//#define DT128_0L85D
//#define A128_0L85D
//#define DP256_0K79X


/*****************************************************************************/
/*Macro Definitions															 */
/*****************************************************************************/

#define stop_enable() {asm andcc   #0x7F;}
#define CLI()         {asm cli;}	//enable global interrupts
#define SEI()         {asm sei;}	// disable global interrupts
#define Set_sp()      {asm lds     #0x3FF0;}  // set stack pointer
#define wait()        {asm wai;}
#define stop()        {asm stop;}
#define nop()         {asm nop;}
#define bgnd()        {asm bgnd; asm NOP; }
#define ON 1
#define OFF 0
#define true 1
#define false 0
#define yes 1
#define no 0
#define NUL     0x00
#define ESC     0x1B
#define LEFT    0x4B
#define RIGHT   0x4D
#define HOME    0x47
#define END     0x4F
#define INSERT  0x52
#define DELETE  0x53
#define BACKSPC 0x08
#define ENTER   0x0D
#define CTLEND  0x75
#define CTLHOME 0x77
#define CTLRT   0x74
#define CTLLFT  0x73

/******************************************************************************
* ROUTINE: Peripheral File Includes
*
* DESCRIPTION:  includes from project definitions library        
*                                                                           
* NOTE: Modify by selecting which maskset to include into your main 
*		application by uncommenting the appropriate define at the top
*		of projectglobals.h (Mask Set Selection)                                           
*                                                            
******************************************************************************/

#ifdef H256_0K78X
#include "per_H256_0K78X.h"		
#endif /*H256_0K78X*/

#ifdef DP256_0K79X
#include "per_DP256_0K79X.h"	
#endif /*DP256_0K79X*/

#ifdef DP256_1K79X
#include "per_DP256_1K79X.h"	
#endif /*DP256_1K79X*/

#ifdef A256_1K79X
#include "per_A256_1K79X.h"
#endif /*A256_1K79X*/

#ifdef DT128_0L85D
#include "per_DT128_0L85D.h"	
#endif /*DT128_0L85D*/

#ifdef A128_0L85D
#include "per_A128_0L85D.h"
#endif /*A128_0L85D*/

#ifdef D64_0L86D
#include "per_D64_0L86D.h"		
#endif /*D64_0L86D*/

#ifdef E128_0L08M
#include "per_E128_0L08M.h"	//Modify include to read correct mask set
#endif /*E128_0L08M*/


/******************************************************************************
* ROUTINE:	
* DESCRIPTION:          
* NOTE:    
* AUTHOR:         LOCATION:       LAST EDIT DATE:   
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      		                                         
*******************************************************************************/

/****User Defines ****/
extern tU32 oscclk, busclk, pllclk;  
extern tU32 run_time, rti_count, run_count;
extern tU16 lock_time;

#endif /*PROJECTGLOBALS_H*/
