//************************************************************************
// Interrupt service routines (ISRs) header file
//
// NOTES:
// Interrupt vectors must point to fixed paged address. From the fixed
// routine a call can redirect to paged memory. 
// 
// If routine is unused it is recommended to provide minimal code to 
// record when isr illegally taken. Save address of last instruction.
// This is useful in determining source of illegal isr.
//************************************************************************

#ifndef PROJECTVECTORS_H        /*prevent duplicated includes*/
#define PROJECTVECTORS_H

/*Include Files*/
#include "projectglobals.h"


#pragma CODE_SEG NON_BANKED        
void unused_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void pwm_shutdown_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void portp_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan4_tx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan4_rx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan4_error_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan4_wakeup_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan3_tx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan3_rx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan3_error_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan3_wakeup_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan2_tx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan2_rx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan2_error_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan2_wakeup_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan1_tx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan1_rx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan1_error_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan1_wakeup_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan0_tx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan0_rx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan0_error_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void mscan0_wakeup_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void flash_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void eeprom_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void spi2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void spi1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void iic_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void bdlc_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void crg_scm_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void crg_pll_lock_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void pa_b_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_mdc_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void porth_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void portj_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void atd1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void atd0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void sci1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void sci0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void spi0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void pa_a_edge_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void pa_a_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch7_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch6_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch5_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch4_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch3_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void ect_ch0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void rti_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void irq_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void xirq_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void swi_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void trap_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void cop_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED
void clockmonitor_isr(void);
#pragma CODE_SEG DEFAULT

/*****************************************/

#pragma CODE_SEG NON_BANKED        
void mc_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void bf_rx_fifo_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void bf_rx_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void bf_sync_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void bf_general_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch3_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch4_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch5_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch6_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_ch7_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_pa_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim0_pa_edge_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void sci2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void portad_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch3_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch4_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch5_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch6_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_ch7_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_pa_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim1_pa_edge_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch3_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch4_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch5_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch6_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_ch7_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_pa_overflow_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void tim2_pa_edge_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_gen_a_reload_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_gen_b_reload_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_gen_c_reload_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_fault0_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_fault1_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_fault2_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void pmf_fault3_isr(void);
#pragma CODE_SEG DEFAULT

#pragma CODE_SEG NON_BANKED        
void vreg_lvi_isr(void);
#pragma CODE_SEG DEFAULT

#endif /*PROJECTVECTORS_H*/










 












 






