/****	  MOTOROLA INTERNAL USE ONLY    *****/

/*****************************************************************************/
/*                                             COPYRIGHT (c) MOTOROLA 2000   */
/* FILE NAME: S12ATD10B8CV2.h                                                      */
/*                                                                           */
/* PURPOSE: header file for Star12 ATD block     					 		 */
/*                                                                           */
/*  ***********************************************************************  */
/*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  */
/*  *  METROWERKS COMPILER AND THE STAR12 EVB AND HAS ONLY BEEN GIVEN A   *  */
/*  *  MIMIMUM LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES *  */
/*  *  AND NO PROMISE OF SUPPORT.                                         *  */
/*  ***********************************************************************  */
/*                                                                           */
/* DESCRIPTION: Defines the ATD convertor module register block as a         */
/* datastructure of type tATD.                           					 */
/* 																		     */
/* ATD Datastructure base address (out of reset) -                           */
/*                                                                           */
/* S12DP256      : (ATD0) 0x0080, (ATD1) 0x0120                              */
/*                                                                           */
/* The datastructure compiled is determined by the #define's S12DP256,       */
/* S12xxx, etc. These definitions can be found in "s12_common.h".            */
/* The MCU id can be #defined in a "target.h" header file or included as a   */
/* complier command line argument as -DS12DP256.                             */
/* Currently only S12DP256 is supported.									 */
/*																			 */
/* ATDSTAT1 module offset address -                                          */
/*                                                                           */
/* DP256REV1     : ATDSTAT1 0x07                                             */
/* DP256REV2     : ATDSTAT1 0x0B                                             */
/*                                                                           */
/* The location of the ATDSTAT1 register changed from the first S12DP256 mask*/
/* set (K36N) to the second (K79X). Optional compilation is controlled by    */
/* including #define DP256REV1 or #define DP256REV2 in the application or    */ 
/* adding either one as a complier argument.                                 */
/*                                                                           */
/* Multiple register descriptions are used when a differing bit structure    */
/* exists between parts. In the case of additional bit definitions within    */
/* the same register, then only the full register description is used.       */
/*                                                                           */
/*                                                                           */
/* AUTHOR: Martyn Gallop        LOCATION: EKB      LAST EDIT DATE: 26.07.01  */
/*                                                                           */
/* UPDATE HISTORY                                                            */
/* REV  AUTHOR       DATE       DESCRIPTION OF CHANGE                        */
/* ---  ------      --------    ---------------------                        */
/* 1.0	M.Gallop	1/5/00		- Initial coding                             */
/*								- Added some bits detail to partid comments. */
/* 1.1  M.Gallop	10/5/00 	- fixed missing terminator on 2 comments     */
/*     							- Changed #include <s12_common.h> 		     */
/* 							      to #include "s12_common.h"			     */
/* 2.0  M.Gallop    26/07/01	- UPDATED TO SUPPORT MASK 0K79X              */ 
/*                              - changed CPU id MCSDP256 to S12DP256        */
/*                              - Added optional compile switches DP256REV1  */
/*                                and DP256REV2 for optional compilation of  */
/*                                relocated ATDSTAT1 register.               */
/*                              - Added disclaimer and reformated file info. */
/*                                                                           */
/*===========================================================================*/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/

#ifndef S12ATD10B8CV2_H			/*prevent duplicated includes */
#define S12ATD10B8CV2_H

#ifndef MOTTYPES_H		/*prevent duplicated includes */
#include "MOTTYPES.h"
#endif

typedef union uATDCTL2
  {
  tU08	byte;
  struct
    {
    tU08 ascif	 :1;		/*atd sequence interrupt flag */
    tU08 ascie	 :1;		/*atd complete interrupt enable */
    tU08 etrige	 :1;		/*external trigger mode enable */
    tU08 etrigp	 :1;		/*external trigger polarity */
    tU08 etrigle :1;		/*external trigger level/edge control */
    tU08 awai	 :1;		/*atd stops in wait mode */
    tU08 affc	 :1;		/*atd fast flag clear all */
    tU08 adpu	 :1;		/*atd enable */
    }bit;
  }tATDCTL2;

#define ASCIF	0x01	/*bit masks */
#define ASCIE	0x02
#define ETRIGE	0x04
#define ETRIGP	0x08
#define ETRIGLE	0x10
#define AWAI	0x20
#define AFFC	0x40
#define ADPU	0x80

typedef union uATDCTL3
  {
  tU08	byte;
  struct
    {
    tU08 frz	:2;		/*atd background mode */
    tU08 fifo	:1;		/*results mapped to fifo mode */
    //tU08 s1c	:1;		/*sequence length = +1 */
    //tU08 s2c	:1;		/*sequence length = +2 */
    //tU08 s4c	:1;		/*sequence length = +4 */
    //tU08 s8c	:1;		/*sequence length =  8 */
    tU08 slc	:4;		
    tU08		:1;		/*not used */
    }bit;
  }tATDCTL3;

#define FRZ0	0x01	/*bit masks */
#define FRZ1	0x02
#define FIFO	0x04
#define S1C 	0x08
#define S2C 	0x10
#define S4C 	0x20
#define S8C 	0x40
#define SLC		0x78

typedef union uATDCTL4
  {
  tU08	byte;
  struct
    {
    tU08 prs	:5;		/*atd P clock prescaler */
    tU08 smp	:2;		/*atd sample time */
    tU08 sres8	:1;		/*atd 8-bit mode */
    }bit;
  }tATDCTL4;

#define PRS0	0x01	/*bit masks */
#define PRS1	0x02
#define PRS2	0x04
#define PRS3	0x08
#define PRS4	0x10
#define SMP0	0x20
#define SMP1	0x40
#define SRES8	0x80

typedef union uATDCTL5
  {
  tU08	byte;
  struct
    {
    tU08 cx		:3;		/*atd channel select */
    tU08		:1;		/*not used */
    tU08 mult	:1;		/*atd multichannel conversion enable */
    tU08 scan	:1;		/*atd continuous scan enable */
    tU08 dsgn	:1;		/*signed/unsigned result mode */
    tU08 djm	:1;		/*result data register justification mode */
    }bit;
  }tATDCTL5;

#define CA		0x01	/*bit masks */
#define CB		0x02
#define CC		0x04
#define MULT	0x10
#define SCAN	0x20
#define DSGN	0x40
#define DJM 	0x80

typedef union uATDSTAT0
  {
  tU08	byte;
  struct
    {
    tU08 ccx	:3;		/*conversion counter for current sequence */
    tU08		:1;		/*not used */
    tU08 fifor	:1;		/*fifo overrun flag */
    tU08 etorf	:1;		/*external trigger overrun flag */
    tU08		:1;		/*not used */
    tU08 scf	:1;		/*atd sequence complete flag */
    }bit;
  }tATDSTAT0;

#define CC0		0x01	/*bit masks */
#define CC1		0x02
#define CC2		0x04
#define FIFOR	0x10
#define ETORF	0x20
#define SCF		0x80

typedef union uATDSTAT1
  {
  tU08	byte;
  struct
    {
    tU08 ccf0	:1;		/*atd conversion complete flags */
    tU08 ccf1	:1;
    tU08 ccf2	:1;
    tU08 ccf3	:1;
    tU08 ccf4	:1;
    tU08 ccf5	:1;
    tU08 ccf6	:1;
    tU08 ccf7	:1;
    }bit;
  }tATDSTAT1;

#define	CCF0	0x01	/*bit masks	*/
#define CCF1	0x02
#define CCF2	0x04
#define CCF3	0x08
#define CCF4	0x10
#define CCF5	0x20
#define CCF6	0x40
#define CCF7	0x80

typedef union uATDTEST0
  {
  tU08	byte;
  struct
    {
    tU08 sar2	:1;		/*atd successive approximation register */
    tU08 sar3	:1;
    tU08 sar4	:1;
    tU08 sar5	:1;
    tU08 sar6	:1;
    tU08 sar7	:1;
    tU08 sar8	:1;
    tU08 sar9	:1;
    }bit;
  }tATDTEST0;

#define SAR2	0x01	/*bit masks */
#define SAR3	0x02
#define SAR4	0x04
#define SAR5	0x08
#define SAR6	0x10
#define SAR7	0x20
#define SAR8	0x40
#define SAR9	0x80

typedef union uATDTEST1
  {
  tU08	byte;
  struct
    {
    tU08 sc		:1;		/*special channel conversion mode */
    tU08 atdclk	:1;		/*atd conversion clock state */
    tU08 rst	:1;		/*atd reset */
    tU08       	:3;		/*not used */
    tU08 sar0	:1;		/*atd successive approximation register,  */
    tU08 sar1	:1;		/*the two lsb's in 10-bit mode */
    }bit;
  }tATDTEST1;

#define SC  	0x01	/*bit masks */
#define ATDCLK	0x02
#define RST		0x04
#define SAR0	0x40
#define SAR1	0x80

typedef union uATDDIEN
  {
  tU08	byte;
  struct
    {
    tU08 dien0	:1;		/*input enable mask */
    tU08 dien1	:1;
    tU08 dien2	:1;
    tU08 dien3 	:1;
    tU08 dien4 	:1;
    tU08 dien5	:1;
    tU08 dien6	:1;
    tU08 dien7	:1;
    }bit;
  }tATDDIEN;

#define DIEN0	0x01	/*bit masks */
#define DIEN1 	0x02
#define DIEN2 	0x04
#define DIEN3 	0x08
#define DIEN4 	0x10
#define DIEN5 	0x20
#define DIEN6 	0x40
#define DIEN7 	0x80

typedef union uPORTAD
  {
  tU08	byte;
  struct
    {
    tU08 pad0	:1;		/*input port pins */
    tU08 pad1	:1;
    tU08 pad2	:1;
    tU08 pad3 	:1;
    tU08 pad4 	:1;
    tU08 pad5	:1;
    tU08 pad6	:1;
    tU08 pad7	:1;
    }bit;
  }tPORTAD;

#define PAD0	0x01	/*bit masks */
#define PAD1 	0x02
#define PAD2 	0x04
#define PAD3 	0x08
#define PAD4 	0x10
#define PAD5 	0x20
#define PAD6 	0x40
#define PAD7 	0x80

typedef union uATDDR		/*ATD data register */
  {
  tU16	d10;			
  struct				
    {
    tU08 datah;			
    tU08 datal;			
    }d8;
  }tATDDR;

typedef struct						/*atd module */ 
  {
           tU08		 	atdctl0;	/*reserved */
           tU08		 	atdctl1;	/*reserved */
  volatile tATDCTL2	 	atdctl2;	/*atd control register 2 */
           tATDCTL3	 	atdctl3;	/*atd control register 3 */
           tATDCTL4	 	atdctl4;	/*atd control register 4 */
           tATDCTL5  	atdctl5;	/*atd control register 5 */
  volatile tATDSTAT0 	atdstat0;	/*atd status register 0 */           
           tU08		 	rsv3;		/*reserved (maintaining memory map) */
  volatile tATDTEST0 	atdtest0;	/*atd test register */ 
  volatile tATDTEST1    atdtest1;	/*atd test register */ 
           tU08		 	rsv4;		/*reserved (maintaining memory map) */
  volatile tATDSTAT1 	atdstat1;	/*atd status register 1 */
           tU08		 	rsv5;		/*reserved (maintaining memory map) */
           tATDDIEN	 	atddien0;	/*atd digital i/p buffer enable */
           tU08		 	rsv2;		/*reserved (maintaining memory map) */  
  volatile tPORTAD	 	portad;		/*port AD input register */
  volatile tATDDR	  	atddr[8];	/*atd result registers*/
  }tATD;

#endif /*S12ATD10B8CV2_H*/