/****	  MOTOROLA INTERNAL USE ONLY    ****

Filename : S12DAC8B1CV1.h

Written by Eduardo Montanez (R9AABE)

****/

#ifndef S12DAC8B1CV1_H			/*prevent duplicated includes */
#define S12DAC8B1CV1_H

#ifndef MOTTYPES_H		/*prevent duplicated includes */
#include "MOTTYPES.h"
#endif

typedef union uDACC0
  {
  tU08	byte;
  struct
    {
    tU08 dacoe	 :1;		/*dac output enable */
    tU08 dacwai	 :1;		/*dac stop in WAIT mode */
    tU08 dacdsgn :1;		/*data register signed */
    tU08 dacdjm	 :1;		/*data register data justification */
    tU08 		 :2;		/*not used */
    tU08 dacte	 :1;		/*read only*/
    tU08 dace	 :1;		/*dac enable */
    }bit;
  }tDACC0;

#define DACOE	0x01	/*bit masks */
#define DACWAI	0x02
#define DACDSGN	0x04
#define DACDJM	0x08
#define DACTE	0x40
#define DACE	0x80


typedef struct						/*dac module */ 
  {
  volatile tDACC0	 	dacc0;		/*dac control register 0 */
           tU08		 	dacc1;		/*dac reserved register */
           tU08		 	dacdl;		/*dac data register - left justified */
           tU08		  	dacdr;		/*dac data register - right justified */
    }tDAC;

#endif /*S12DAC8B1CV1_H*/