/****	  MOTOROLA INTERNAL USE ONLY    ****

Filename : S12EETS2KV1.h

Defines the user eeprom register block as a datastructure

EEPROM datastructure base address (out of reset) -

MCSDP256	  : 0x0110

The datastructure used is determined by the #define's MCSDP256, MCSxxx, etc. 
These definitions can be found in "s12_common.h".

Written by Martyn Gallop (R32151)

Revision history -

11/5/00	- Initial coding
25/5/00 - Corrected declaration of rsvee2 - reserved area for test 
 

****/

#ifndef S12EETS2KV1_H			/*prevent duplicated includes */
#define S12EETS2KV1_H

#ifndef MOTTYPES_H			/*prevent duplicated includes */
#include "MOTTYPES.h"
#endif

typedef union uECLKDIV
  {
  tU08	byte;
  struct
    {
    tU08 ediv	:6;		/*clk divider */
    tU08 ediv8	:1;		/*clk /8 prescaler enable */
    tU08 edivld	:1;		/*clock divider loaded flag */
    }bit;
  }tECLKDIV;

#define EDIV	0x3F	/*bit masks	*/
#define EDIV8	0x40
#define EDIVLD	0x80

typedef union uECNFG
  {
  tU08	byte;
  struct
    {
    tU08		:4;		/*not used */
    tU08 		:1;		/*not used */
    tU08		:1;		/*not used */
    tU08 ccie	:1;		/*command complete interrupt enable */
    tU08 cbeie	:1;		/*command buffer empty interrupt enable	*/
    }bit;
  }tECNFG;

#define ESWAI	0x10	/*bit masks	*/
#define CCIE	0x40	
#define CCBIE	0x80

typedef union uEPROT
  {
  tU08	byte;
  struct
    {
    tU08 ep			:3;		/*protection block size: (ep+1)*64 bytes */
    tU08 epdis		:1;		/*protection disable */
    tU08 			:3;		/*contain value of equivalent bits in protection byte */
    tU08 eopen		:1;		/*open block for program/erase */
    }bit;
  }tEPROT;

#define EP0		0x01	/*bit masks	*/
#define EP1		0x02
#define EP2		0x04	
#define EP		0x07	/*ep block mask */
#define EPDIS   0x08
#define EOPEN	0x80

typedef union uESTAT
  {
  tU08	byte;
  struct
    {
    tU08 		:2;		/*not used */
    tU08 blank	:1;		/*blank verify flag */
    tU08 		:1;		/*not used */
    tU08 accerr	:1;		/*access error flag */
    tU08 pviol	:1;		/*protection violation flag */
    tU08 ccif	:1;		/*command complete interrupt flag */
    tU08 cbeif	:1;		/*command buffer empty interrupt flag */
    }bit;
  }tESTAT;

#define BLANK	0x04	/*bit masks	*/
#define ACCERR	0x10
#define PVIOL 	0x20
#define CCIF	0x40
#define CBEIF	0x80

typedef union uECMD
  {
  tU08	byte;
  struct
    {
    tU08 mass	:1;		/*mass erase enable	*/
	tU08 		:1;		/*not used */
    tU08 erver	:1;		/*erase verify enable */
	tU08 		:2;		/*not used */
    tU08 prog	:1;		/*word programming */
    tU08 erase	:1;		/*erase control */
	tU08 		:1;		/*not used */
    }bit;
  }tECMD;

#define MASS	0x01	/*bit masks	*/
#define ERVER	0x04
#define PROG	0x20
#define ERASE	0x40


typedef struct						/*eeprom datastructure */
  {
  volatile tECLKDIV		eclkdiv;	/*eeprom clock divider register */
		   tU08			rsvee1[2];	/*reserved */
           tECNFG		ecnfg;		/*eeprom configuration register */
  volatile tEPROT		eprot;		/*eeprom protection register */
  volatile tESTAT		estat;		/*eeprom status register */
  		   tECMD		ecmd;		/*eeprom command buffer & status register */
  volatile tU08			rsvee2[5];	/*reserved */
  }tEEPROM;


#endif /*S12EETS2KV1_H */