/****	  MOTOROLA INTERNAL USE ONLY    ****

Filename : S12FTS64KV1.h

Defines the FLASH eeprom register block as a datastructure

FLASH FEEPROM datastructure base address (out of reset) -

MCSDP256	  : 0x0100

The datastructure used is determined by the #define's MCSDP256, MCSxxx, etc. 
These definitions can be found in "s12_common.h".

Written by Martyn Gallop (R32151)

Revision history -

11/5/00	- Initial coding
25/5/00 - Corrected declaration of rsvfee2 - reserved area for test 

****/

#ifndef S12FTS64KV1_H			/*prevent duplicated includes */
#define S12FTS64KV1_H

#ifndef MOTTYPES_H		/*prevent duplicated includes */
#include "MOTTYPES.h"
#endif

typedef union uFCLKDIV
  {
  tU08	byte;
  struct
    {
    tU08 fdiv	:6;		/*clk divider */
    tU08 fdiv8	:1;		/*clk /8 prescaler enable */
    tU08 fdivld	:1;		/*clock divider loaded flag */
    }bit;
  }tFCLKDIV;

#define FDIV	0x3F	/*bit masks	*/
#define FDIV8	0x40
#define FDIVLD	0x80

typedef union uFSEC
  {
  tU08	byte;
  struct
    {
    tU08 sec	:2;		/*memory security bit */
    tU08 nv		:5;		/*user non volatile flag bits */
    tU08 keyen	:1;		/*security key access enable */
    }bit;
  }tFSEC;

#define SEC0	0x01	/*bit masks	*/
#define SEC1	0x02
#define SEC		0x03
#define NV2		0x04
#define NV3		0x08
#define NV4		0x10
#define NV5 	0x20
#define NV6		0x40
#define KEYEN	0x80

typedef union uFCNFG
  {
  tU08	byte;
  struct
    {
    tU08		:5;		/*not used */
    tU08 keyacc	:1;		/*security key writing enable */
    tU08 ccie	:1;		/*command complete interrupt enable */
    tU08 cbeie	:1;		/*command buffer empty interrupt enable	*/
    }bit;
  }tFCNFG;

#define BKSEL0	0x01	/*bit masks	*/
#define BKSEL1	0x02
#define BKSEL	0x03	/*bank select mask */
#define KEYACC	0x20	
#define CCIE	0x40	
#define CCBIE	0x80

typedef union uFPROT
  {
  tU08	byte;
  struct
    {
    tU08 fpls		:2;		/*flash protection lower address size */
    tU08 fpldis		:1;		/*flash protection lower address range disable */
    tU08 fphs		:2;		/*flash protection higher address size */
    tU08 fphdis		:1;		/*flash protection higher address range disable */
    tU08 			:1;		/*contains value of equivalent bit in protection byte */
    tU08 fopen		:1;		/*open block for program/erase control */
    }bit;
  }tFPROT;

#define FPLS0		0x01	/*bit masks	*/
#define FPLS1		0x02
#define FPLS		0x03	/*fpls block size mask */
#define FPLDIS		0x04	
#define FPHS0		0x08	
#define FPHS1		0x10
#define FPHS		0x18	/*fphs block size mask */
#define FPHDIS		0x20	
#define FOPEN		0x80

typedef union uFSTAT
  {
  tU08	byte;
  struct
    {
    tU08 		:2;		/*not used */
    tU08 blank	:1;		/*blank verify flag */
    tU08 		:1;		/*not used */
    tU08 accerr	:1;		/*access error flag */
    tU08 pviol	:1;		/*protection violation flag */
    tU08 ccif	:1;		/*command complete interrupt flag */
    tU08 cbeif	:1;		/*command buffer empty interrupt flag */
    }bit;
  }tFSTAT;

#define BLANK	0x04	/*bit masks	*/
#define ACCERR	0x10
#define PVIOL 	0x20
#define CCIF	0x40
#define CBEIF	0x80

typedef union uFCMD
  {
  tU08	byte;
  struct
    {
    tU08 mass	:1;		/*mass erase enable	*/
	tU08 		:1;		/*not used */
    tU08 erver	:1;		/*erase verify enable */
	tU08 		:2;		/*not used */
    tU08 prog	:1;		/*word programming */
    tU08 erase	:1;		/*erase control */
	tU08 		:1;		/*not used */
    }bit;
  }tFCMD;

#define MASS	0x01	/*bit masks	*/
#define ERVER	0x04
#define PROG	0x20
#define ERASE	0x40


typedef struct						/*flash datastructure */
  {
  volatile tFCLKDIV		fclkdiv;	/*flash clock divider register */
  volatile tFSEC		fsec;		/*flash security register */
		   tU08			rsvfee1;	/*reserved */
           tFCNFG		fcnfg;		/*flash configuration register */
  volatile tFPROT		fprot;		/*flash protection register */
  volatile tFSTAT		fstat;		/*flash status register */
  		   tFCMD		fcmd;		/*flash command buffer & status register */
  volatile tU08			rsvfee2[9];	/*reserved */
  }tFLASH;


#endif /*S12FTS64KV1_H */