/****	  MOTOROLA INTERNAL USE ONLY    ****

Filename : S12MSCANV2.h

Defines the Star12 msCAN module register block as a datastructure

msCAN datastructure base address (out of reset) -

MCSDP256	  : (CAN0) 0x0140, (CAN1) 0x0180, (CAN2) 0x01C0, 
				(CAN3) 0x0200, (CAN4) 0x0280

The datastructure used is determined by the #define's MCSDP256, MCSxxx, etc. 
These definitions can be found in "s12_common.h".

Written by Martyn Gallop (R32151)

Revision history -

9/5/00	- Initial coding based on HC12 mscan.h by Ross McLuckie
10/5/00	- Updated transmitter registers comments
		- Changed #include <s12_common.h> to #include "s12_common.h"
		- corrected type name tCANRIER (was incorrectly tCANRFLG)
26/7/00 - added time stamp registers to tTXBUF & tRXBUF buffer structures
		- corrected spelling of SPLAK to SLPAK in tCANCTL1 definition
		- split idam :2  into idam0 & idam1 bits in tCANIDAC definition
2/8/00  - replaced missing #define
3/8/00  - corrected spelling of rxfie & ovrie in CANRIER definition	
          as per the spec.	 

****/

#ifndef S12MSCANV2_H		/*prevent duplicated includes */
#define S12MSCANV2_H

#ifndef MOTTYPES_H		/*prevent duplicated includes */
#include "MOTTYPES.h"
#endif

typedef union uCANCTL0
  {
  tU08	byte;
  struct
    {
    tU08 initrq	:1;		/*initialization mode request */
    tU08 slprq	:1;		/*sleep mode request */
    tU08 wupe	:1;		/*wake-up enable */
    tU08 time	:1;		/*time stamp enable	*/
    tU08 synch	:1;		/*synchronized status */
    tU08 cswai	:1;		/*msCAN stops in wait mode */
    tU08 rxact	:1;		/*receiver active status */
    tU08 rxfrm	:1;		/*frame recieved flag */
    }bit;
  }tCANCTL0;

#define INITRQ	0x01	/*bit masks	*/
#define SLPRQ	0x02
#define WUPE	0x04
#define TIME	0x08
#define SYNCH	0x10
#define CSWAI	0x20
#define RXACT	0x40
#define RXFRM	0x80

typedef union uCANCTL1
  {
  tU08	byte;
  struct
    {
    tU08 initak	:1;		/*initialization mode acknowledge */
    tU08 slpak	:1;		/*sleep mode acknowledge*/
    tU08 wupm	:1;		/*wake-up mode low pass filter */
    tU08		:1;		/*not used */
    tU08 listen	:1;		/*listen only mode */
    tU08 loopb	:1;		/*loop back self test mode */
    tU08 clksrc	:1;		/*msCAN clock source */
    tU08 cane	:1;		/*msCAN enabled */
    }bit;
  }tCANCTL1;

#define INITAK	0x01	/*bit masks	*/
#define SLPAK	0x02
#define WUPM	0x04
#define LISTEN	0x10
#define LOOPB	0x20
#define CLKSRC	0x40
#define CANE	0x80

typedef union uCANBTR0
  {
  tU08	byte;
  struct
    {
    tU08 brp	:6;		/*baud rate prescaler */
    tU08 sjw	:2;		/*synchronization jump width */
    }bit;
  }tCANBTR0;

#define BRP0	0x01	/*bit masks	*/
#define BRP1	0x02
#define BRP2	0x04
#define BRP3	0x08
#define BRP4	0x10
#define BRP5	0x20
#define SJW0	0x40
#define SJW1	0x80

typedef union uCANBTR1
  {
  tU08	byte;
  struct
    {
    tU08 tseg1	:4;		/*time segment bits	*/
    tU08 tseg2	:3;
    tU08 samp	:1;		/*sample rate (0:1 per bit;1:3 per bit)	*/
    }bit;
  }tCANBTR1;

#define TSEG10	0x01	/*bit masks	*/
#define TSEG11	0x02
#define TSEG12	0x04
#define TSEG13	0x08
#define TSEG20	0x10
#define TSEG21	0x20
#define TSEG22	0x40
#define SAMP	0x80

typedef union uCANRFLG
  {
  tU08	byte;
  struct
    {
    tU08 rxf	:1;		/*receive buffer full flag */
    tU08 ovrif	:1;		/*overrun flag */
    tU08 tstat	:2;		/*transmitter status bits */
    tU08 rstat	:2;		/*receiver status bits */
    tU08 cscif	:1;		/*status change interrupt flag	*/
    tU08 wupif	:1;		/*wake-up flag */
    }bit;
  }tCANRFLG;

#define RXF		0x01	/*bit masks	*/
#define OVRIF	0x02
#define TSTAT0	0x04
#define TSTAT1	0x08
#define RSTAT0	0x10
#define RSTAT1	0x20
#define CSCIF	0x40
#define WUPIF	0x80

typedef union uCANRIER
  {
  tU08	byte;
  struct
    {
    tU08 rxfie	:1;		/*receiver full interrupt enable */
    tU08 ovrie	:1;		/*overrun interrupt enable */
    tU08 tstate	:2;		/*transmitter status change enable */
    tU08 rstate	:2;		/*receiver status change enable */
    tU08 cscie	:1;		/*status change interrupt enable	*/
    tU08 wupie	:1;		/*wake-up interrupt enable */
    }bit;
  }tCANRIER;

#define RXFIE	0x01	/*bit masks	*/
#define OVRIE	0x02
#define TSTATE0	0x04
#define TSTATE1	0x08
#define RSTATE0	0x10
#define RSTATE1	0x20
#define CSCIE	0x40
#define WUPIE	0x80

typedef union uCANTFLG
  {
  tU08	byte;
  struct
    {
    tU08 txe	:3;		/*transmitter buffer empty flag	*/
    tU08		:5;		/*not used */
    }bit;
  }tCANTFLG;

#define TXE0	0x01	/*bit masks	*/
#define TXE1	0x02
#define TXE2	0x04

typedef union uCANTIER
  {
  tU08	byte;
  struct
    {
    tU08 txeie	:3;		/*transmitter empty interrupt enable */
    tU08		:5;		/*not used */
    }bit;
  }tCANTIER;

#define TXEIE0	0x01	/*bit masks	*/
#define TXEIE1	0x02
#define TXEIE2	0x04


typedef union uCANTARQ
  {
  tU08	byte;
  struct
    {
    tU08 abtrq	:3;		/*transmitter abort request */
    tU08		:5;		/*not used */
    }bit;
  }tCANTARQ;

#define ABTRQ0	0x01
#define ABTRQ1	0x02
#define ABTRQ2	0x04

typedef union uCANTAAK
  {
  tU08	byte;
  struct
    {
    tU08 abtak	:3;		/*transmitter abort acknowledge	*/
    tU08		:5;		/*not used */
    }bit;
  }tCANTAAK;

#define ABTAK0	0x01
#define ABTAK1	0x02
#define ABTAK2	0x04

typedef union uCANTBSEL
  {
  tU08	byte;
  struct
    {
    tU08 tx		:3;		/*transmitter buffer select	*/
    tU08		:5;		/*not used */
    }bit;
  }tCANTBSEL;

#define TX0		0x01
#define TX1		0x02
#define TX2		0x04

typedef union uCANIDAC
  {
  tU08	byte;
  struct
    {
    tU08 idhit	:3;		/*identifier acceptance hit indicator */
    tU08		:1;		/*not used */
    tU08 idam0	:1;		/*identifier acceptance mode, set = 4 x 16-bit*/
    tU08 idam1	:1;		/*identifier acceptance mode, set = 8 x 8-bit*/
						/*both cleared = 1 x 32 bit */
						/*both set = filter closed */
    tU08		:2;		/*not used */
    }bit;
  }tCANIDAC;

#define IDHIT0	0x01	/*bit masks	*/
#define IDHIT1	0x02
#define IDHIT2	0x04
#define IDAM0	0x10	
#define IDAM1	0x20


typedef union uCANID
  {
  tU32	l;
  tU16	w[2];
  tU08	b[4];
  }tCANID;

typedef struct
  {
  tCANID	canidar;
  tCANID	canidmr;
  }tCID;

typedef struct
  {
  tCANID	id;						/*message id */
  tU08		dsr[8];					/*8 x data bytes */
  tU08		dlr;					/*data length value */
  tU08		rsv;					/*not used */
  tU16		tsr;					/*time stamp register */
  }tRXBUF;

typedef struct
  {
  tCANID	id;						/*message id */
  tU08		dsr[8];					/*8 x data bytes */
  tU08		dlr;					/*data length value */
  tU08		tbpr;					/*transmit buffer priority */
  tU16		tsr;					/*time stamp register */
  }tTXBUF;

typedef struct						
  {
  volatile tCANCTL0	canctl0;		/*control register 0 */
           tCANCTL1	canctl1;		/*control register 1 */
           tCANBTR0	canbtr0;		/*bus timing register 0	*/
           tCANBTR1	canbtr1;		/*bus timing register 1	*/
  volatile tCANRFLG	canrflg;		/*receiver flag register */
           tCANRIER	canrier;		/*receiver interrupt enable register */
  volatile tCANTFLG	cantflg;		/*transmitter flag register	*/
           tCANTIER	cantier;		/*transmitter interrupt enable register */
           tCANTARQ	cantarq;		/*transmitter message abort control register */
  volatile tCANTAAK	cantaak;		/*transmitter message abort flag register */
  volatile tCANTBSEL cantbsel;		/*transmitter buffer select */
  volatile tCANIDAC	canidac;		/*identifier acceptance control register */
           tU08		rsv[2];			/*reserved */
  volatile tU08		canrxerr;		/*receive error counter	*/
  volatile tU08		cantxerr;		/*transmit error counter */
           tCID		canid[2];		/*identifier acceptance/mask registers */
  volatile tRXBUF	rxbuf;			/*foreground receive buffer */
           tTXBUF	txbuf;			/*foreground transmit buffer */
  }tMSCAN;

#endif /*S12MSCANV2_H */