/****	  MOTOROLA INTERNAL USE ONLY    ****

Filename : S12SCIV3.h

Defines the serial communications interface register block as a datastructure

SCI datastructure base address (out of reset) -

MCSDP256	  : (SCI0) 0x00C8, (SCI1) 0x00D0

The datastructure used is determined by the #define's MCSDP256, MCSxxx, etc. 
These definitions can be found in "s12_common.h".

Written by Martyn Gallop (R32151)

Revision history -

9/5/00	- Initial coding based on HC12 ssi.h by Ross McLuckie
10/5/00 - Changed #include <s12_common.h> to #include "s12_common.h"
		- fixed missing terminator on 2 comments
28/1/02	- changed bit name in tSCISR1 from 'or' to 'orf' to avoid clash
          with C reserved word.  
****/

#ifndef S12SCIV3_H			/*prevent duplicated includes */
#define S12SCIV3_H

#ifndef MOTTYPES_H		/*prevent duplicated includes */
#include "MOTTYPES.h"
#endif

typedef union uSCIBDH
  {
  tU08	byte;
  struct
    {
    tU08 sbr8	:1;		/*msb baud rate select bits	*/
    tU08 sbr9	:1;
    tU08 sbr10	:1;
    tU08 sbr11	:1;
    tU08 sbr12	:1;    
    tU08 tnp 	:2;		/*transmitter narrow pulse bit */
    tU08 iren	:1;		/*infrared enable bit */
    }bit;
  }tSCIBDH;
  
#define SBR8	0x01	/*bit masks	*/
#define SBR9	0x02
#define SBR10	0x04
#define SBR11	0x08
#define SBR12	0x10
#define TNP0	0x20
#define TNP1	0x40
#define IREN	0x80
  
typedef union uSCIBDL
  {
  tU08	byte;
  struct
    {
    tU08 sbr0	:1;		/*msb baud rate select bits	*/
    tU08 sbr1	:1;
    tU08 sbr2	:1;
    tU08 sbr3	:1;
    tU08 sbr4	:1;
    tU08 sbr5	:1;		
    tU08 sbr6	:1;		
    tU08 sbr7   :1;		
    }bit;
  }tSCIBDL;

#define SBR0	0x01	/*bit masks	*/
#define SBR1	0x02
#define SBR2	0x04
#define SBR3	0x08
#define SBR4	0x10
#define SBR5	0x20
#define SBR6	0x40
#define SBR7	0x80

typedef union uSCIBD
  {
  tU16	word;
  struct
    {
    tSCIBDH	msb;
    tSCIBDL	lsb;
    }byte;
  }tSCIBD;

typedef union uSCICR1
  {
  tU08	byte;
  struct
    {
    tU08 pt			:1;		/*parity type */
    tU08 pe			:1;		/*parity enable	*/
    tU08 ilt		:1;		/*idle line type */
    tU08 wake		:1;		/*wake up by address mark/idle */
    tU08 m			:1;		/*mode select */
    tU08 rsrc		:1;		/*receiver source */
    tU08 sciswai	:1;		/*stop in wait mode	*/
    tU08 loops		:1;		/*loop mode/single wire mode enable	*/
    }bit;
  }tSCICR1;

#define PT		0x01	/*bit masks	*/
#define PE		0x02
#define ILT		0x04
#define WAKE	0x08
#define M	    0x10
#define RSRC	0x20
#define SCISWAI	0x40
#define LOOPS	0x80

typedef union uSCICR2
  {
  tU08	byte;
  struct
    {
    tU08 sbk	:1;		/*send break character */
    tU08 rwu	:1;		/*receiver wake-up control */
    tU08 re		:1;		/*receiver enable */
    tU08 te		:1;		/*transmitter enable */
    tU08 ilie	:1;		/*idle line interrupt enable */
    tU08 rie	:1;		/*receiver interrupt enable	*/
    tU08 tcie	:1;		/*transmit complete interrupt enable */
    tU08 tie	:1;		/*transmit interrupt enable	*/
    }bit;
  }tSCICR2;

#define SBK		0x01	/*bit masks	*/
#define RWU		0x02
#define RE		0x04
#define TE		0x08
#define ILIE	0x10
#define RIE		0x20
#define TCIE	0x40
#define TIE		0x80

typedef union uSCISR1
  {
  tU08	byte;
  struct
    {
    tU08 pf		:1;		/*parity error flag	*/
    tU08 fe		:1;		/*framing error flag */
    tU08 nf		:1;		/*noise error flag */
    tU08 orf	:1;		/*overrun error flag - 'or' in specification */
    tU08 idle	:1;		/*idle line detected flag */
    tU08 rdrf	:1;		/*receive data register full flag */
    tU08 tc		:1;		/*transmit complete flag */
    tU08 tdre	:1;		/*transmit data register empty flag	*/
    }bit;
  }tSCISR1;

#define PF		0x01	/*bit masks	*/
#define FE		0x02
#define NF		0x04
#define ORF		0x08	/* 'OR' in specification */
#define IDLE	0x10
#define RDRF	0x20
#define TC		0x40
#define TDRE	0x80

typedef union uSCISR2
  {
  tU08	byte;
  struct
    {
    tU08 raf	:1;		/*receiver active flag */
	tU08 txdir	:1;		/*receiver active flag */
    tU08 brk13	:1;		/*brk transmit character length */
    tU08 		:5;		/*not used */
    }bit;
  }tSCISR2;

#define RAF		0x01	/*bit masks	*/
#define TXDIR	0x02	
#define BRK13	0x04	

typedef union uSCIDRH
  {
  tU08	byte;
  struct
    {
    tU08		:6;		/*not used */
    tU08 t8		:1;		/*transmit bit 9 */
    tU08 r8		:1;		/*receive bit 9	*/
    }bit;
  }tSCIDRH;

#define T8		0x40	/*bit masks	*/
#define R8		0x80

typedef struct				/*sci datastructure	*/
  {
           tSCIBD	scibd;	/*sci baud rate registers */
           tSCICR1	scicr1;	/*sci control register 1 */
           tSCICR2	scicr2;	/*sci control register 2 */
  volatile tSCISR1	scisr1;	/*sci status register 1	*/
  volatile tSCISR2	scisr2;	/*sci status register 2	*/
  volatile tSCIDRH	scidrh;	/*sci data register high */
  volatile tU08		scidrl;	/*sci data register low	*/
  }tSCI;


#endif /*S12SCIV3_H */