/******************************************************************************
*                                                   COPYRIGHT (c) MOTOROLA 2002   
* FILE NAME: per_C32_0L45J.h     REVISION 1.0                                        
*                                                                           
* PURPOSE: declaration of peripheral variables for an MC9S12C32
*		   Mask Set: 0L45J							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE METROWERKS COMPILER AND **  
**      THE HCS12 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.       **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  declarations of control register blocks for on-chip peripherals.        
*                                                                           
*                                                                           
* AUTHOR: Eduardo Montanez   LOCATION: OHT      LAST EDIT DATE: 09.23.02  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe  	09/23/02	Original coding                                         
*                                                              
*                                                                           
******************************************************************************/
/******************************************************************************
* Peripheral Versions for MCS12C32 - Mask Set: 0L45J
* 
* Peripheral	Peripheral UG	  Version	Doc. Order #		Header File
* ----------	---------------   -------	---------------		---------------
* REF			CPU REF Manual	  --		CPU12RM/D			--
* CORE			HCS12 V1.5 Core   V1.5		S12CPU15UG/D		S12CPU15V1_5.h
* CRG			CRG  			  V04		S12CRGV4/D			S12CRGV4.h
* TIMER			TIM_16B8C		  V01		S12TIM16B8CV1/D		S12TIM16B8CV1.h
* ATD			ATD_10B8C		  V02		S12ATD10B8CV2/D		S12ATD10B8CV2.h
* SCI			SCI				  V02		S12SCIV2/D			S12SCIV2.h
* SPI			SPI	  			  V03		S12SPIV3/D			S12SPIV3.h
* PWM			PWM_8B6C		  V01		S12PWM8B6CV1/D		S12PWM8B6CV1.h
* SRAM			SRAM2K			  V01		S12SRAM2KV1/D		--
* FLASH			FTS32K			  V01		S12FTS32KV1/D		S12FTS32KV1.h
* MSCAN			MSCAN			  V02		S12MSCANV2/D		S12MSCANV2.h
* VREG			VREG_3v3		  V03		S12VREG3V3V1/D		--
* PIM			PIM_9C32	   	  V01		S12PIMC32V1/D		S12PIMC32V1.h
*
******************************************************************************/ 				
/*===========================================================================*/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/

#ifndef PER_C32_0L45J_H			//prevent duplicated includes
#define PER_C32_0L45J_H

#ifndef REG_BASE
#define REG_BASE			0x0000
#endif

#include "S12ATD10B8CV2.h"			//ATD
#include "S12CPU15V1_5.h"			//CORE(PAGE/REG)
#include "S12CRGV4.h"				//CRG
#include "S12FTS32KV1.h"			//FLASH
#include "MOTTYPES.h"				//TYPE DEFS
#include "S12MSCANV2.h"				//MSCAN
#include "S12PIMC32V1.h"			//PIM
#include "S12PWM8B6CV1.h"			//PWM
#include "S12SCIV2.h"				//SCI
#include "S12SPIV3.h"				//SPI
#include "S12TIM16B8CV1.h"			//TIMER



extern tREGISTER Regs 	@ (0x0000 + REG_BASE);
extern tPAGE     Page   @ (0x0030 + REG_BASE);
extern tCRG	  	 Crg  	@ (0x0034 + REG_BASE);
extern tTIMER	 Tim0	@ (0x0040 + REG_BASE);
extern tATD	 	 Atd0   @ (0x0080 + REG_BASE);
extern tSCI      Sci0   @ (0x00C8 + REG_BASE);
extern tSPI      Spi0   @ (0x00D8 + REG_BASE);
extern tPWM	 	 Pwm	@ (0x00E0 + REG_BASE);
extern tFLASH    Flash  @ (0x0100 + REG_BASE);
extern tMSCAN	 Can0	@ (0x0140 + REG_BASE);
extern tPIM	  	 Pim	@ (0x0240 + REG_BASE);

#endif /*PER_C32_0L45J_H*/