/******************************************************************************
*                                                   COPYRIGHT (c) MOTOROLA 2001   
* FILE NAME: per_DT128_0L85D.h     REVISION 1.0                                        
*                                                                           
* PURPOSE: declaration of peripheral variables for an MC9S12DT128
*		   Mask Set: 0L85D							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE METROWERKS COMPILER AND **  
**      THE HCS12 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.      **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  declarations of control register blocks for on-chip peripherals.        
*                                                                           
*                                                                           
* AUTHOR: Eduardo Montanez   LOCATION: OHT      LAST EDIT DATE: 03.12.02  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe  	03/07/02	Original coding                                         
*                                                              
*                                                                           
******************************************************************************/
/******************************************************************************
* Peripheral Versions for MCS12DT128 - Mask Set: 0L85D
* 
* Peripheral	Peripheral UG	  Version	Doc. Order #		Header File
* ----------	---------------   -------	---------------		---------------
* REF			CPU REF Manual	  --		CPU12RM/D			--
* CORE			HCS12 V1.5 Core   V1.2		S12CPU15UG/D		S12CPU15V1_2.h
* CRG			CRG  			  V03		S12CRGV3/D			S12CRGV3.h
* TIMER			ECT_16B8C		  V01		S12ECT16B8CV1/D		S12ECT16B8CV1.h
* ATD			ATD_10B8C		  V02		S12ATD10B8CV2/D		S12ATD10B8CV2.h
* IIC			IIC				  V02		S12IICV2/D			S12IICV2.h
* SCI			SCI				  V02		S12SCIV2/D			S12SCIV2.h
* SPI			SPI	  			  V02		S12SPIV2/D			S12SPIV2.h
* PWM			PWM_8B8C		  V01		S12PWM8B8CV1/D		S12PWM8B8CV1.h
* FLASH			FTS128K			  V01		S12FTS128KV1/D		S12FTS128KV1.h
* EEPROM		EETS2K			  V01		S12EETS2KV1/D		S12EETS2KV1.h
* BDLC			BDLC			  V01		S12BDLCV1/D			S12BDLCV1.h
* MSCAN			MSCAN			  V02		S12MSCANV2/D		S12MSCANV2.h
* VREG			VREG			  V01		S12REGV1/D			--
* PIM			PIM_9DT128	   	  V01		S12PIMDT128V1/D		S12PIMDT128V1.h
* BF			BF				  V01		S12BFV1/D			S12BFV1.h
*
******************************************************************************/ 				
/*===========================================================================*/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/

#ifndef PER_DT128_0L85D_H			//prevent duplicated includes
#define PER_DT128_0L85D_H

#ifndef REG_BASE
#define REG_BASE			0x0000
#endif

#include "S12ATD10B8CV2.h"			//ATD
#include "S12BDLCV1.h" 				//BDLC
#include "S12BFV1.h"				//BF
#include "S12CPU15V1_2.h"			//CORE(PAGE/REG)
#include "S12CRGV3.h"				//CRG
#include "S12EETS2KV1.h"			//EEPROM
#include "S12FTS128KV1.h"			//FLASH
#include "S12IICV2.h"				//IIC
#include "MOTTYPES.h"				//TYPE DEFS
#include "S12MSCANV2.h"				//MSCAN
#include "S12PIMDT128V1.h"			//PIM
#include "S12PWM8B8CV1.h"			//PWM
#include "S12SCIV2.h"				//SCI
#include "S12SPIV2.h"				//SPI
#include "S12ECT16B8CV1.h"			//TIMER



extern tREGISTER Regs 	@ (0x0000 + REG_BASE);
extern tPAGE     Page   @ (0x0030 + REG_BASE);
extern tCRG	  	 Crg  	@ (0x0034 + REG_BASE);
extern tTIMER	 Tim0	@ (0x0040 + REG_BASE);
extern tATD	     Atd0   @ (0x0080 + REG_BASE);
extern tPWM	     Pwm	@ (0x00A0 + REG_BASE);
extern tSCI      Sci0   @ (0x00C8 + REG_BASE);
extern tSCI      Sci1   @ (0x00D0 + REG_BASE);
extern tSPI      Spi0   @ (0x00D8 + REG_BASE);
extern tIIC	     Iic	@ (0x00E0 + REG_BASE);
extern tBDLC	 Bdlc   @ (0x00E8 + REG_BASE);
extern tSPI      Spi1   @ (0x00F0 + REG_BASE);
extern tFLASH    Flash  @ (0x0100 + REG_BASE);
extern tEEPROM   Eeprom @ (0x0110 + REG_BASE);
extern tATD	     Atd1   @ (0x0120 + REG_BASE);
extern tMSCAN	 Can0	@ (0x0140 + REG_BASE);
extern tMSCAN	 Can1	@ (0x0180 + REG_BASE);
extern tPIM	     Pim	@ (0x0240 + REG_BASE);
extern tMSCAN	 Can4	@ (0x0280 + REG_BASE);
extern tBF		 Bf		@ (0x0300 + REG_BASE);


#endif /*PER_DT128_0L85D_H*/





