/******************************************************************************
*                                                   COPYRIGHT (c) MOTOROLA 2002   
* FILE NAME: per_E128_0L08M.c     REVISION 1.0                                        
*                                                                           
* PURPOSE: declaration of peripheral variables for an MC9S12E128
*		   Mask Set: 0L08M							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE METROWERKS COMPILER AND **  
**      THE HCS12 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.       **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  declarations of control register blocks for on-chip peripherals.        
*                                                                           
*                                                                           
* AUTHOR: Eduardo Montanez   LOCATION: OHT      LAST EDIT DATE: 04.17.02  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe  	04/17/02	Original coding                                         
*                                                              
*                                                                           
******************************************************************************/
/******************************************************************************
* Peripheral Versions for MCS12E128 - Mask Set: 0L08M
* 
* Peripheral	Peripheral UG	  Version	Doc. Order #		Header File
* ----------	---------------   -------	---------------		---------------
* REF			CPU REF Manual	  --		CPU12RM/D			--
* CORE			HCS12 V1.5 Core   V1.5		S12CPU15UG/D		S12CPU15V1_5.h
* CRG			CRG  			  V04		S12CRGV4/D			S12CRGV4.h
* TIMER			TIM_16B4C		  V01		S12TIM16B4CV1/D		S12TIM16B4CV1.h
* ATD			ATD_10B16C		  V02		S12ATD10B16CV2/D	S12ATD10B16CV2.h
* IIC			IIC				  V02		S12IICV2/D			S12IICV2.h
* SCI			SCI				  V03		S12SCIV3/D			S12SCIV3.h
* SPI			SPI	  			  V02		S12SPIV2/D			S12SPIV2.h
* PWM			PWM_8B6C		  V01		S12PWM8B6CV1/D		S12PWM8B6CV1.h
* FLASH			FTS128K			  V01		S12FTS128KV1/D		S12FTS128KV1.h
* SRAM			SRAM8K			  V01		S12SRAM8KV1/D		--
* DAC			DAC_8B1C		  V01		S12DAC8B1CV1/D		S12DAC8B1CV1.h
* PMF			PMF_15B6C		  V01		S12PMF15B6CV1/D		S12PMF15B6CV1.h
* VREG			VREG_3V3		  V01		S12REG3V3V1/D		--
* PIM			PIM_9E128	   	  V01		S12PIME128V1/D		S12PIME128V1.h
*
******************************************************************************/ 				
/*===========================================================================*/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/

#ifndef REG_BASE
#define REG_BASE			0x0000
#endif

#include "S12ATD10B16CV2.h"			//ATD
#include "S12CPU15V1_5.h"			//CORE(PAGE/REG)
#include "S12CRGV4.h"				//CRG
#include "S12DAC8B1CV1.h"			//DAC
#include "S12FTS128KV1.h"			//FLASH
#include "S12IICV2.h"				//IIC
#include "MOTTYPES.h"				//TYPE DEFS
#include "S12PIME128V1.h"			//PIM
#include "S12PMF15B6CV1.h"			//PMF
#include "S12PWM8B6CV1.h"			//PWM
#include "S12SCIV3.h"				//SCI
#include "S12SPIV2.h"				//SPI
#include "S12TIM16B4CV1.h"			//TIMER



tREGISTER Regs 	@ (0x0000 + REG_BASE);
tPAGE     Page  @ (0x0030 + REG_BASE);
tCRG	  Crg  	@ (0x0034 + REG_BASE);
tTIMER	  Tim0	@ (0x0040 + REG_BASE);
tATD	  Atd0  @ (0x0080 + REG_BASE);
tSCI      Sci0  @ (0x00C8 + REG_BASE);
tSCI      Sci1  @ (0x00D0 + REG_BASE);
tSPI      Spi0  @ (0x00D8 + REG_BASE);
tIIC	  Iic	@ (0x00E0 + REG_BASE);
tSCI	  Sci2  @ (0x00E8 + REG_BASE);
tDAC      Dac0  @ (0x00F0 + REG_BASE);
tDAC      Dac1  @ (0x00F4 + REG_BASE);
tFLASH    Flash @ (0x0100 + REG_BASE);
tTIMER	  Tim1	@ (0x0140 + REG_BASE);
tTIMER	  Tim2	@ (0x0180 + REG_BASE);
tPWM	  Pwm	@ (0x01E0 + REG_BASE);
tPMF	  Pmf	@ (0x0200 + REG_BASE);
tPIM	  Pim	@ (0x0240 + REG_BASE);










