/******************************************************************************
*                                                   COPYRIGHT (c) MOTOROLA 2001   
* FILE NAME: per_H256_0K78X.h     REVISION 1.0                                        
*                                                                           
* PURPOSE: declaration of peripheral variables for an MC9S12H256
*		   Mask Set: 0K78X							 
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE METROWERKS COMPILER AND **  
**      THE HCS12 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.       **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION:  declarations of control register blocks for on-chip peripherals.        
*                                                                           
*                                                                           
* AUTHOR: Eduardo Montanez   LOCATION: OHT      LAST EDIT DATE: 03.07.02  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe  	03/07/02	Original coding                                         
*                                                              
*                                                                           
******************************************************************************/
/******************************************************************************
* Peripheral Versions for MCS12H256 - Mask Set: 0K78X
* 
* Peripheral	Peripheral UG	  Version	Doc. Order #		Header File
* ----------	---------------   -------	---------------		---------------
* REF			CPU REF Manual	  --		CPU12RM/D			--
* CORE			HCS12 V1.5 Core   V1.2		S12CPU15UG/D		S12CPU15V1_2.h
* CRG			CRG  			  V02		S12CRGV2/D			S12CRGV2.h
* TIMER			TIM_16B8C		  V01		S12TIM16B8CV1/D		S12TIM16B8CV1.h
* ATD			ATD_10B16C		  V02		S12ATD10B16CV2/D	S12ATD10B16CV2.h
* IIC			IIC				  V02		S12IICV2/D			S12IICV2.h
* SCI			SCI				  V02		S12SCIV2/D			S12SCIV2.h
* SPI			SPI	  			  V02		S12SPIV2/D			S12SPIV2.h
* PWM			PWM_8B6C		  V01		S12PWM8B6CV1/D		S12PWM8B6CV1.h
* FLASH			FTS256K			  V02		S12FTS256KV2/D		S12FTS256KV2.h
* EEPROM		EETS4K			  V02		S12EETS4KV2/D		S12EETS4KV2.h
* LCD			LCD_32F4B		  V01		S12LCD32F4BV1/D		S12LCD32F4BV1.h
* MSCAN			MSCAN			  V02		S12MSCANV2/D		S12MSCANV2.h
* MC			MC_10B12C		  V02		S12MC10B12CV2/D		S12MC10B12CV2.h
* PIM			PIM_9H256	   	  V01		S12PIMH256V1/D		S12PIMH256V1.h
*
******************************************************************************/ 				
/*===========================================================================*/
/* Motorola reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Motorola does */
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Motorola */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Motorola product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Motorola */
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Motorola  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Motorola */
/* was negligent regarding the  design  or manufacture of the part. Motorola */
/* and the Motorola logo* are registered trademarks of Motorola Ltd.         */
/*****************************************************************************/


#ifndef PER_H256_0K78X_H			//prevent duplicated includes
#define PER_H256_0K78X_H

#ifndef REG_BASE
#define REG_BASE			0x0000
#endif

#include "S12ATD10B16CV2.h"			//ATD
#include "S12CPU15V1_2.h"			//CORE(PAGE/REG)
#include "S12CRGV2.h"				//CRG
#include "S12EETS4KV2.h"			//EEPROM
#include "S12FTS256KV2.h"			//FLASH
#include "S12IICV2.h"				//IIC
#include "MOTTYPES.h"				//TYPE DEFS
#include "S12LCD32F4BV1.h"			//LCD
#include "S12MC10B12CV2.h"			//MC
#include "S12MSCANV2.h"				//MSCAN
#include "S12PIMH256V1.h"			//PIM
#include "S12PWM8B6CV1.h"			//PWM
#include "S12SCIV2.h"				//SCI
#include "S12SPIV2.h"				//SPI
#include "S12TIM16B8CV1.h"			//TIMER



extern tREGISTER Regs 	@ (0x0000 + REG_BASE);
extern tPAGE     Page   @ (0x0030 + REG_BASE);
extern tCRG	     Crg  	@ (0x0034 + REG_BASE);
extern tTIMER	 Tim0	@ (0x0040 + REG_BASE);
extern tATD	     Atd0   @ (0x0080 + REG_BASE);
extern tIIC	     Iic	@ (0x00C0 + REG_BASE);
extern tSCI      Sci0   @ (0x00C8 + REG_BASE);
extern tSCI      Sci1   @ (0x00D0 + REG_BASE);
extern tSPI      Spi0   @ (0x00D8 + REG_BASE);
extern tPWM	     Pwm	@ (0x00E0 + REG_BASE);
extern tFLASH    Flash  @ (0x0100 + REG_BASE);
extern tEEPROM   Eeprom @ (0x0110 + REG_BASE);
extern tLCD	     Lcd	@ (0x0120 + REG_BASE);
extern tMSCAN	 Can0	@ (0x0140 + REG_BASE);
extern tMSCAN	 Can1	@ (0x0180 + REG_BASE);
extern tMC		 Mc     @ (0x01C0 + REG_BASE);
extern tPIM	     Pim	@ (0x0200 + REG_BASE);



#endif /*PER_H256_0K78X_H*/





