#ifndef _UEXEC_H
#define _UEXEC_H
/* header file micro-executive
 * Copyright (c) 1998 ImageCraft and Richard F. Man
 * http://www.imagecraft.com
 */
/* Number of tasks, change this to suit your need
 */
#ifndef NUM_TASKS
#define NUM_TASKS	10
#endif

extern int uexc_ticks;	/* current tick value */
						/* 4000 ticks/sec for 8Mhz clock 2000 cycles/tick */
int UEXC_CreateTask(void (*func)(void), 
                    unsigned char *stack_start, 
                    unsigned stack_size, 
                    unsigned ticks);
void UEXC_Defer(void);
void UEXC_HogProcessor(void);
void UEXC_KillTask(int pid);
int UEXC_StartScheduler(void);
void UEXC_SystemInterrupt(void);
extern void (*UEXC_InterruptDriver)(void);

/* Minimum stack size for a task function that does not use "any" stack space.
 * This should be the interrupt stack frame, plus some fudge factor for
 * frame pointer, a single function call, etc.
 * For HC11/12/16, the interrupt frame is 10/12 bytes.
 */
#define UEXC_MIN_STACK_SIZE	(40)
#define UEXC_STACK_ARG(stack)	stack, sizeof (stack)

#ifndef INTR_ON
/* These are valid for HC11, HC12 using the ImageCraft compilers
 */
#define INTR_ON()	asm("	cli");
#define INTR_OFF()	asm("	sei");

#endif
#endif
