	.module uexec.c
	.area text
_UEXC_StartScheduler::
; /* set ts=4 */
; #include <stdlib.h>
; #include "_uexec.h"
; 
; /* Micro-Executive
;  * Copyright (c) 1998 ImageCraft and Richard F. Man
;  * http://www.imagecraft.com
;  */
; static TaskControlBlock free_list[NUM_TASKS], *free_list_ptr;
; static TaskControlBlock *current_task;
; unsigned char *uexc_current_sp;
; void (*uexc_current_func)(void);
; void (*UEXC_InterruptDriver)(void);
; 
; static int next_tid;
; static unsigned char null_task_stack[UEXC_MIN_STACK_SIZE];
; static void InitSystem(void);
; static void NullTask(void);
; static void KillTask(int tid);
; 
; int uexc_ticks;
; 
; /* User Callable  Functions
;  * ========================
;  */
; 
; /* Start the multi-tasking system
;  */
; int UEXC_StartScheduler(void)
; 	{
; 	if (current_task == 0)
	ldd _current_task
	bne L3
; 		return -1;
	ldd #-1
	bra L2
L3:
; 	UEXC_StartTimer();
	jsr _UEXC_StartTimer
; 	INTR_ON();
			cli

; 	UEXC_Schedule();
	jsr _UEXC_Schedule
; 	return 0;	/* never execute */
	ldd #0
L2:
	.dbline 0 ; func end
	rts
;          ?temp -> -8,x
;          ?temp -> -6,x
;           next -> -4,x
;              p -> -2,x
;          ticks -> 10,x
;     stack_size -> 8,x
;    stack_start -> 6,x
;           func -> 2,x
_UEXC_CreateTask::
	pshd
	pshx
	tfr s,x
	leas -8,sp
; 	}
; 
; /* Create a new process and link it to the task list
;  */
; int UEXC_CreateTask(void (*func)(void), 
;                     unsigned char *stack_start,
;                     unsigned stack_size,
;                     unsigned ticks)
; 	{
; 	TaskControlBlock *p, *next;
; 
; 	if (free_list_ptr == 0)
	ldd _free_list_ptr
	bne L6
; 		InitSystem();
	jsr _InitSystem
L6:
; 	INTR_OFF();
			sei

; 	p = free_list_ptr;
	movw _free_list_ptr,-2,x
; 	free_list_ptr = free_list_ptr->next;
	ldy _free_list_ptr
	ldy 0,y
	sty _free_list_ptr
; 	p->func = func;
	ldy -2,x
	ldd 2,x
	std 6,y
; 	p->state = T_CREATED;
	ldy -2,x
	clr 3,y
; 	p->tid = next_tid++;
	movw _next_tid,-6,x
	ldd -6,x
	addd #1
	std _next_tid
	ldd -6,x
	ldy -2,x
	stab 2,y
; 	p->ticks = (ticks == 0) ? DEFAULT_TICKS : ticks;
	ldd 10,x
	bne L9
	ldd #5
	std -8,x
	bra L10
L9:
	movw 10,x,-8,x
L10:
	ldd -8,x
	ldy -2,x
	stab 4,y
; 
; 	/* stack grows from high address to low address
; 	 */
; 	p->stack_start = stack_start;
	ldy -2,x
	ldd 6,x
	std 8,y
; 	p->stack_end = stack_start+stack_size-1;
	ldd 8,x
	addd 6,x
	addd #-1
	ldy -2,x
	std 10,y
; 
; 	/* align stack here, if needed
; 	 */
; 	p->sp = p->stack_end;
	ldy -2,x
	ldd 10,y
	ldy -2,x
	std 12,y
; 
; 	/* create a circular linked list
; 	 */
; 	if (current_task == 0)
	ldd _current_task
	bne L11
; 		p->next = p, current_task = p;
	ldy -2,x
	ldd -2,x
	std 0,y
	movw -2,x,_current_task
	bra L12
L11:
; 	else
; 		next = current_task->next, current_task->next = p, p->next = next;
	ldy _current_task
	ldy 0,y
	sty -4,x
	ldy _current_task
	ldd -2,x
	std 0,y
	ldy -2,x
	ldd -4,x
	std 0,y
L12:
; 	INTR_ON();
			cli

; 	return p->tid;
	ldy -2,x
	ldab 2,y
	clra
L5:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
_UEXC_Defer::
; 	}
; 
; /* Give up timeslice
;  */
; void UEXC_Defer(void)
; 	{
; 	INTR_OFF();
			sei

; 	uexc_current_sp = (unsigned char *)&current_task->sp;
	ldd _current_task
	addd #12
	std _uexc_current_sp
; 	UEXC_SavregsAndResched();
	jsr _UEXC_SavregsAndResched
; 	}
L13:
	.dbline 0 ; func end
	rts
_UEXC_HogProcessor::
; 
; /* Hog the processor for more cycle time
;  */
; void UEXC_HogProcessor(void)
; 	{
; 	INTR_OFF();
			sei

; 	current_task->current_ticks = current_task->ticks;
	ldy _current_task
	ldab 4,y
	ldy _current_task
	stab 5,y
; 	INTR_ON();
			cli

; 	}
L14:
	.dbline 0 ; func end
	rts
;          ?temp -> -6,x
;              p -> -4,x
;             qb -> -2,x
;            tid -> 2,x
_UEXC_KillTask::
	pshd
	pshx
	tfr s,x
	leas -6,sp
; 
; /* kill a process
;  */
; void UEXC_KillTask(int tid)
; 	{
; 	TaskControlBlock **qb, *p;
; 
; 	/* tid == 0 -> null task, never kill that 
; 	 */
; 	if (tid == 0)
	ldd 2,x
	bne L16
; 		return;
	bra L15
L16:
; 
; 	INTR_OFF();
			sei

; 	/* search the circular list until we find a match or gone through
; 	 * the whole list
; 	 */
; 	for (qb = &(current_task)->next; (*qb)->tid != tid && *qb != current_task;
	movw _current_task,-2,x
	bra L21
L18:
L19:
	ldd [-2,x]
	std -2,x
L21:
	ldd [-2,x]
	std -6,x
	tfr d,y
	ldab 2,y
	clra
	cpd 2,x
	beq L22
	ldd -6,x
	cpd _current_task
	bne L18
L22:
; 	     qb = &(*qb)->next)
; 		;
; 	/* if found, then delete the process
; 	 */
; 	if ((*qb)->tid == tid)
	ldy [-2,x]
	ldab 2,y
	clra
	cpd 2,x
	bne L23
; 		{
; 		/* If this is the head of the task list, reassign the
; 		 * head. This has the effect of skipping the next task
; 		 * for one round of scheduling but should not matter
; 		 * much.
; 		 */
; 		if ((*qb) == current_task)
	ldd [-2,x]
	cpd _current_task
	bne L25
; 			current_task = current_task->next;
	ldy _current_task
	ldy 0,y
	sty _current_task
L25:
; 
; 		/* delink and free the memory
; 		 */
; 		p = *qb;
	ldd [-2,x]
	std -4,x
; 		*qb = (*qb)->next;
	ldy [-2,x]
	ldd 0,y
	ldy -2,x
	std 0,y
; 		p->next = free_list_ptr;
	ldy -4,x
	ldd _free_list_ptr
	std 0,y
; 		free_list_ptr = p;
	movw -4,x,_free_list_ptr
; 		}
L23:
; 	INTR_ON();
			cli

; 	}
L15:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;          ?temp -> -4,x
;              i -> -2,x
_InitSystem:
	pshx
	tfr s,x
	leas -10,sp
; 
; /* Internal Functions
;  * ==================
;  */
; 
; /* Initialize the system.
;  */
; static void InitSystem(void)
; 	{
; 	int i;
; 
; 	/* initialize the free list
; 	 */
; 	for (i = 0; i < NUM_TASKS-1; i++)
	ldd #0
	std -2,x
L28:
	ldd #14
	ldy -2,x
	emuls
	std -4,x
	addd #_free_list
	xgdy
	ldd -4,x
	addd #_free_list+14
	std 0,y
L29:
	ldd -2,x
	addd #1
	std -2,x
	ldd -2,x
	cpd #9
	blt L28
; 		free_list[i].next = &free_list[i+1];
; 	free_list_ptr = &free_list[0];
	ldd #_free_list
	std _free_list_ptr
; 
; 	/* null task has tid of 0 
; 	 */
; 	UEXC_CreateTask(NullTask, null_task_stack, sizeof (null_task_stack), 0);
	ldd #0
	std 4,sp
	ldd #40
	std 2,sp
	ldd #_null_task_stack
	std 0,sp
	ldd #_NullTask
	jsr _UEXC_CreateTask
; 	}
L27:
	tfr x,s
	pulx
	.dbline 0 ; func end
	rts
_UEXC_KillSelf::
; 
; /* This is the "return point" of a new task. Reclaim storage
;  * and reschdule
;  */
; void UEXC_KillSelf(void)
; 	{
; 	UEXC_KillTask(current_task->tid);
	ldy _current_task
	ldab 2,y
	clra
	jsr _UEXC_KillTask
; 	UEXC_Schedule();
	jsr _UEXC_Schedule
; 	}
L33:
	.dbline 0 ; func end
	rts
_NullTask:
; 
; /* Always runnable task. This has the tid of zero
;  */
; static void NullTask(void)
; 	{
	bra L36
L35:
	jsr _UEXC_Defer
L36:
; 	while (1)
	bra L35
X0:
; 		UEXC_Defer();
; 	}
L34:
	.dbline 0 ; func end
	rts
;          ?temp -> -5,x
;          ?temp -> -4,x
;          ?temp -> -2,x
_UEXC_CheckTask::
	pshx
	tfr s,x
	leas -6,sp
; 
; /* called by the timer interrupt. See if we need to reschedule
;  */
; void UEXC_CheckTask(void)
; 	{
; 	uexc_ticks++;
	ldd _uexc_ticks
	addd #1
	std _uexc_ticks
; 
; 	/* call any user installed interrupt routine
; 	 */
; 	if (UEXC_InterruptDriver)
	ldd _UEXC_InterruptDriver
	beq L39
; 		(*UEXC_InterruptDriver)();
	ldy _UEXC_InterruptDriver
	jsr 0,y
L39:
; 
; 	UEXC_RestartTimer();
	jsr _UEXC_RestartTimer
; 	/* Kill the task if the stack pointer is bad.
; 	 * There ought to be a way to inform the user...
; 	 */
; 	if (uexc_current_sp > current_task->stack_end ||
	ldd _uexc_current_sp
	std -2,x
	ldy _current_task
	ldd -2,x
	cpd 10,y
	bhi L43
	ldy _current_task
	ldd -2,x
	cpd 8,y
	bhs L41
L43:
; 	    uexc_current_sp < current_task->stack_start)
; 		UEXC_KillSelf();
	jsr _UEXC_KillSelf
L41:
; 
; 	/* decrement the tick value and reschedule if needed
; 	 */
; 	if (--current_task->current_ticks == 0)
	ldd _current_task
	addd #5
	std -4,x
	tfr d,y
	ldab 0,y
	clra
	subd #1
	stab -5,x
	ldy -4,x
	ldab -5,x
	stab 0,y
	tst -5,x
	bne L44
; 		{
; 		/* memorize the state
; 		 */
; 		current_task->sp = uexc_current_sp;
	ldy _current_task
	ldd _uexc_current_sp
	std 12,y
; 		UEXC_Schedule();
	jsr _UEXC_Schedule
; 		}
L44:
; 	}
L38:
	tfr x,s
	pulx
	.dbline 0 ; func end
	rts
_UEXC_Schedule::
; 
; /* Run a different task. Set the current task as the next one in the (circular)
;  * list, then set the global variables and call the appropriate asm routines
;  * to do the job.
;  */
; void UEXC_Schedule(void)
; 	{
; 	/* pick the next task in the list
; 	 */
; 	current_task = current_task->next;
	ldy _current_task
	ldy 0,y
	sty _current_task
; 	current_task->current_ticks = current_task->ticks;
	ldy _current_task
	ldab 4,y
	ldy _current_task
	stab 5,y
; 
; 	/* set the global variables and go
; 	 */
; 	uexc_current_sp = current_task->sp;
	ldy _current_task
	ldy 12,y
	sty _uexc_current_sp
; 	if (current_task->state == T_READY)
	ldy _current_task
	ldab 3,y
	cmpb #1
	bne L47
; 		UEXC_Resume();
	jsr _UEXC_Resume
	bra L48
L47:
; 	else /* if (task->state == T_CREATED) */
; 		{
; 		current_task->state = T_READY;
	ldy _current_task
	ldab #1
	stab 3,y
; 		uexc_current_func = current_task->func;
	ldy _current_task
	ldy 6,y
	sty _uexc_current_func
; 		UEXC_StartNewTask();
	jsr _UEXC_StartNewTask
; 		}
L48:
; 	}
L46:
	.dbline 0 ; func end
	rts
	.area bss
_null_task_stack:
	.blkb 40
_next_tid:
	.blkb 2
_uexc_current_func::
	.blkb 2
_uexc_current_sp::
	.blkb 2
_current_task:
	.blkb 2
_free_list_ptr:
	.blkb 2
_free_list:
	.blkb 140
_UEXC_InterruptDriver::
	.blkb 2
_uexc_ticks::
	.blkb 2
