;EEPROM.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 15, 2005	1.00		Initial release
*
*
*Author: Exequiel Rarama for the Adapt9S12NE64
*******************************************************************************
;Assembled using CW
;
; ---------------------------
; DEMO - Flash write Routine
; ---------------------------
;
;	include "NE64Regs.INC"

;Public	Function

	XDEF WriteFlash
	XDEF SectorErase	;Sector erase first then program after an erase
	XDEF CheckWriteFLASH

;Public Variable

	XDEF WriteFlg
	XDEF FProtStart

;External Function

	XREF SerOutput0


RamLast:     equ    $3fff         ;last RAM location (all devices)
Window:      equ    $8000         ;PPAGE Window start
RomStart:    equ    $4000         ;start of flash

;FProtStart:  equ    $FF00         ;start of FLASH protection/security
FProtBlksz:  equ    $C7           ;protect code for boot block ($C7 2K)
;FProtBlksz:  equ    $FF           ;protect code for boot block (none)
FSecure:     equ    %10100100		;Disable Security and backdoor access
;FSecure:     equ    $00           ;Enable Security and backdoor access

ErrNone:     equ    $E0           ;code for no errors
ErrCmnd:     equ    $E1           ;command not recognized
ErrRun:      equ    $E2           ;command not allowed in run mode
ErrSP:       equ    $E3           ;SP was out of range
ErrWriteSP:  equ    $E4           ;attempted to write bad SP value
ErrByteNVM:  equ    $E5           ;write_byte attempt NVM
ErrFlash:    equ    $E6           ;FACCERR or FPVIOL error
ErrFlErase:  equ    $E7           ;Error code not implemented
ErrGoVec:    equ    $E8           ;Error code not implemented
ErrEeErase   equ    $E9			  ;EACCERR or EPVIOL error

;****  Flash Control Register  *********************************************************
;*
;
CBEIF:       equ    %10000000     ;command buffer empty interrupt flag
CCIF:        equ    %01000000     ;command complete interrupt flag
PVIOL:       equ    %00100000     ;protection violation
ACCERR:      equ    %00010000     ;flash access error


CMDB6:       equ    %01000000     ;valid flash user mode commands
CMDB5:       equ    %00100000     ;valid flash user mode commands
CMDB2:       equ    %00000100     ;valid flash user mode commands
CMDB0:       equ    %00000001     ;valid flash user mode commands

MassErase:   equ     CMDB6+CMDB0
SecErase:    equ     CMDB6
ProgWord:    equ     CMDB5

;
C32:
EEpromStart:   equ   $0000         ;eeprom start (no EEprom)
EEpromEnd:     equ   $0000         ;eeprom End
RamStart:      equ   $3800         ;first RAM location
FlashBlks:     equ   $01           ;# of flash blks
SectorSize:    equ   $0200         ;Flash sector size
LowestPage:    equ   $3E           ;lowest page
PagesBlk:      equ   $02           ;pages per block
softwareID4:   equ   $3300		    ;device ID #

;---------------------------------------------------------------------
CORE1:       equ    $0000         ;ports A, B, E, modes, inits, test
DEVID:       equ    $001A         ;device ID register
CORE2:       equ    $001C         ;memsiz, IRQ, HPRIO
CORE3:       equ    $0020         ;debug register
CORE4:       equ    $0030         ;PPAGE, port K
CRGV4:       equ    $0034         ;clock and reset generator
SCI0V3:      equ    $00C8         ;serial communications interface SCI0
FTS:         equ    $0100         ;Flash control registers
EE			 equ	$0110		  ;EEPROM control registers
PIM:         equ    $0240         ;port integration module


;****  Clock and Reset Generator (PLL, RTI, COP)  ************************************************
;*
SYNR:        equ    CRGV4+$00     ;CRG synthesizer register
REFDV:       equ    CRGV4+$01     ;CRG reference divider register

CRGFLG:      equ    CRGV4+$03     ;CRG flags register
LOCK:        equ    %00001000     ;lock status bit

CLKSEL:      equ    CRGV4+$05     ;CRG clock select register
PLLSEL:      equ    %10000000     ;PLL select bit

PLLCTL:      equ    CRGV4+$06     ;CRG PLL control register
PLLON:       equ    %01000000     ;phase lock loop on bit

;****  CORE4 (PPAGE, Port K)  ************************************************
;*
PPAGE:       equ    CORE4+$00     ;program page index register

FCMD:        equ    FTS+$06 ;flash command register
FCLKDIV:     equ    FTS+$00 ;flash clock divider register

FSEC:        equ    FTS+$01 ;flash security register

FCNFG:       equ    FTS+$03 ;flash configuration register
CBEIE:       equ    %10000000     ;command buffer empty interrupt enable
CCIE:        equ    %01000000     ;command complete interrupt enable

FSTAT:       equ    FTS+$05 ;flash status register

COPCTL:      equ    CRGV4+$08     ;CRG COP control register
RSBCK:       equ    %01000000     ;COP and RTI stop in active BDM mode bit
CR2:         equ    %00000100     ;COP watchdog timer rate select
CR1:         equ    %00000010     ;COP watchdog timer rate select
CR0:         equ    %00000001     ;COP watchdog timer rate select

;External Variables

	XREF RAMEeprom		;Start of DATA to be saved

DataSec:SECTION
WordWriteCnt	ds	1
WordVar		ds	2
FlashPtr	ds	2
WriteFlg	ds	1

NON_BANKED:SECTION

WriteFlash
	ldx	#$4000			;point to the start of the FLASH storage space
	stx	WordVar
	movb	#%0011,WriteFlg		;Set for Write

	ldy	#RAMEeprom		;Start of DATA to be saved
	sty	FlashPtr	

WriteFlashEx
	rts

CheckWriteFLASH
	ldaa	WriteFlg		;Check if Set for Write
	beq	CheckWriteFLASHEx

WriteFlashLp
	bsr	abClr			; abort commands and clear errors
	movb	#$3E,PPAGE

	ldx	WordVar
	ldy	FlashPtr
	ldd	2,y+
	sty	FlashPtr
	jsr	WriteD2IX

	ldx	WordVar
	inx
	inx
	stx	WordVar

	ldy	FlashPtr
	cpy	#RAMEeprom+199		;End of DATA to be saved
	bhi	DoneWrite
	bra	CheckWriteFLASHEx

DoneWrite
	movb	#%0000,WriteFlg		;Clear for No Write	

CheckWriteFLASHEx
	rts


;-------------------------------------------------------------------------------------
SectorErase				;Sector erase first then program after an erase
	bsr	abClr			; abort commands and clear errors
	ldx	#Window			; point to the start of the PPAGE window.
	movb	#$3E,PPAGE
	ldy	#1	 		; get number of sectors in Y

;Erase 'y' (accumulator) sectors beginning at address 'x' (index register)
;

ErsSectLp:
	std	,x
	movb	#SecErase,FCMD		;perform a sector erase.
	jsr	DoOnStack		;finish command from stack-based sub
	tsta				;check for 0=OK
	bne	ErsSectErr		;back to prompt-flash erase error
	leax	SectorSize,x		;point to the next sector.
	dbne	y,ErsSectLp		;continue to erase remaining sectors.
	rts

ErsSectErr:
	puld				; clear stack
	ldaa	#ErrFlash		;code for Flash error ($E6)
	rts


;-------------------------------------------------------------------------------------
; and clear any pending errors
;
abClr:
	psha
	ldaa	#PVIOL+ACCERR		;mask
	staa	FSTAT			;abort any command and clear errors
	pula
        rts

;*********************************************************************
;* WriteD2IX - Write the data in D (word) to the address in IX
;*  The location may be RAM, FLASH, EEPROM, or a register
;*  if FLASH or EEPROM, the operation is completed before return
;*  IX and A preserved, returns Z=1 (.EQ.) if OK
;*
;*********************************************************************
WriteD2IX:
	pshx				;preserve original address
	pshd				;preserve original data

; Programs D to IX in FLASH
DoProgram:
	bsr	abClr			;abort commands and clear errors
	bsr	ProgFlash		;program the requested location

; exit Write?2IX functions (Z indicates good or bad)
ExitWrite:
	puld				;restore original data (D)
	pulx				;restore original address (IX)
	rts

;-------------------------------------------------------------------------------------

;* Progflash - programs one byte of HCS9S12 FLASH
;*  This routine waits for the command to complete before returning.
;*  assumes location was blank. This routine can be run from FLASH
;*
;* On entry... IX - points at the FLASH byte to be programmed
;*             A holds the data for the location to be programmed
;*
;* Calling convention:
;*           bsr    Prog1flash
;*
;* Uses: DoOnStack which uses SpSub
;* Returns: IX unchanged and A = FSTAT bits PVIOL and ACCERR only
;*  Z=1 if OK, Z=0 if protect violation or access error
;*********************************************************************
ProgFlash:
	pshd
	cpx	#$8000			; if <$8000 then bank 3E
	blo	its3E			;set ppage to 3E
	cpx	#$C000			; if > $BFFF then bank 3F
	blo	ProgFlash1		;set ppage 3F
	movb	#$3F,PPAGE
	bra	ProgFlash1

its3E:
	movb	#$3E,PPAGE

ProgFlash1:
	ldab	PPAGE
	lsrb				; calculate the value of the block select bits based
	lsrb				; on bits 3:2 of the PPAGE register value. (<256k)
	ldy	#SectorSize		; get high byte of size
	cpy	#$0200			; if larger than $200 shift again
	beq	nBlockLoopb
	lsrb				; on bits 4:3 of the PPAGE register value. (512k)

nBlockLoopb:
	comb
	andb	#$03			; mask off all but the lower 2 bits.
	stab	FCNFG			; select the block to program.
	cmpb	#$00			; if block zero use DoOnStack method
	puld
	beq	ProgFlashSP
	bra	ProgFlashSP

ProgFlshRom:
	std	,x			;latch address & data to program
	ldaa	#ProgWord		;Select program word command
	staa	FCMD			;issue byte program command
	ldaa	#CBEIF
	bsr	SpSub			;register command & wait to finish
	ldaa	FSTAT
	anda	#$30			;mask all but PVIOL or ACCERR
	rts

ProgFlashSP:
	std	,x			;latch address and data
	ldaa	#ProgWord		;Select program word command
	staa	FCMD			;issue byte program command

DoOnStack:
	pshx				;save IX
	ldx	#SpSubEnd-2		;point at last word to move to stack

SpmoveLoop:
	ldd	2,x-			;read from flash
	pshd				;move onto stack
	cpx	#SpSub-2		;past end?
	bne	SpmoveLoop		;loop till whole sub on stack
	tfr	sp,x			;point to sub on stack
	ldaa	#CBEIF			;preload mask to register command
	jsr	0,x			;execute the sub on the stack
	leas	SpSubEnd-SpSub,sp	;de-allocate space used by sub
	ldaa	FSTAT			;get result of operation
	anda	#$30			;and mask all but PVIOL or ACCERR
	pulx				;restore IX
	rts				;to flash where DoOnStack was called

;*********************************************************************
;* SpSub - register flash command and wait for Flash CCIF
;*  this subroutine is copied onto the stack before executing
;*  because you can't execute out of flash while a flash command is
;*  in progress (see DoOnStack to see how this is used)
;*
;* Uses 18 bytes on stack + 2 bytes if a BSR/bsr calls it
;*********************************************************************
	EVEN				;Make code start word aligned
SpSub:       
	tfr	ccr,b			;get copy of ccr
	orcc	#$10			;disable interrupts
	staa	FSTAT			;[PwO] register command
	nop				;[O] wait min 4~ from w cycle to r
	nop				;[O]
	nop				;[O]
	brclr	FSTAT,CCIF,*		;[rfPPP] wait for queued commands to finish
	tfr	b,ccr			;restore ccr and int condition
	rts				;back into DoOnStack in flash

SpSubEnd:

;*********************************************************************
;* FLASH configuration: protection, security
;*********************************************************************

;EEPROM:SECTION

FProtStart:				; enable protection
	dc.w	$FFFF			; Skip Backdoor Key
	dc.w	$FFFF			; Skip Backdoor Key
	dc.w	$FFFF			; Skip Backdoor Key
	dc.w	$FFFF			; Skip Backdoor Key

	dc.w	$FFFF			; Skip Reserved

	dc.b	$FF			; protection block 3
	dc.b	$FF			; protection block 2
	dc.b	$FF			; protection block 1
	dc.b	$FF			; protection block 0
	dc.b	$FF			; Skip

	dc.b	%11011100		; set security and backdoor access

;filler
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF
	dc.w	$FFFF

	END
