;Author: Exequiel Rarama
;September 18, 2004
;
;MC9S12NE64 REGISTER MAP

REG:	EQU	$0000

PORTA:		EQU	$0000		;PORTA
PORTB:		EQU	$0001		;PORTB
DDRA:		EQU	$0002		;PORTA - DATA DIRECTION REGISTER
DDRB:		EQU	$0003		;PORTB - DATA DIRECTION REGISTER

PORTE:		EQU	$0008		;PORTE
DDRE:		EQU	$0009		;PORTE - DATA DIRECTION REGISTER
PEAR:		EQU	$000A		;PEAR - PORTE ASSIGNMENT REGISTER
MODE:		EQU	$000B		;MODE - MODE REGISTER
PUCR:		EQU	$000C		;PUCR - PULL UP CONTROL REGISTER
RDRIV:		EQU	$000D		;RDRIV - REDUCED DRIVE OF I/O LINES
EBICTL:		EQU	$000E		;EBITCTL - ESTR

INITRM:		EQU	$0010		;INITRM - INITIALIZATION OF INTERNAL RAM POSITION REGISTER
INITRG:		EQU	$0011		;INITRG - INITIALIZATION OF INTERNAL REGISTER POSITION REGISTER
INITEE:		EQU	$0012		;INITEE - INITIALIZATION OF INTERNAL EEPROM POSITION REGISTER
MISC:		EQU	$0013		;MISC - MISCELLANEOUS MAPPING CONTROL REGISTER
MTST0:		EQU	$0014
ITCR:		EQU	$0015
ITEST:		EQU	$0016
MTST1:		EQU	$0017


PARTIDH:	EQU	$001A
PARTIDL:	EQU	$001B
MEMSIZ0:	EQU	$001C
MEMSIZ1:	EQU	$001D

INTCR:		EQU	$001E           ;INTCR - INTERRUPT CONTROL REGISTER
HPRIO:		EQU	$001F           ;HPRIO - HIGHEST PRIORITY I INTERRRUPT

;Debug12
DBGC1:		EQU	$20
DBGSC:		EQU	$21
DBGTBH:	EQU	$22
DBGTBL:		EQU	$23
DBGCNT:	EQU	$24
DBGCCX:	EQU	$25
DBGCCH:	EQU	$26
DBGCCL:	EQU	$27
DBGC2:		EQU	$28
BKPCT0:		EQU	$28
DBGC3:		EQU	$29		
BKPCT1:		EQU	$29
DBGCAX:	EQU	$2A
BKP0X:		EQU	$2A
DBGCAH:	EQU	$2B
BKP0H:		EQU	$2B
DBGCAL:	EQU	$2C
BKP0L:		EQU	$2C
DBGCBX:	EQU	$2D
BKP1X:		EQU	$2D

DBGCBH:	EQU	$2E
BKP1H:		EQU	$2E
DBGCBL:	EQU	$2F
BKP1L:		EQU	$2F

PPAGE:		EQU	$0030

PORTK:		EQU	$0032
DDRK:		EQU	$0033

;CRG - Clock and Reset Generator
SYNR:		EQU	$0034           ;CRG synthesizer register
REFDV:		EQU	$0035           ;CRG reference divider register
CTFLG:		EQU	$0036
CRGFLG:	EQU	$0037		;CRG flags register
CRGINT:		EQU	$0038
CLKSEL:		EQU	$0039		;CRG clock select register
PLLCTL:		EQU	$003A		;CRG PLL control register
RTICTL:		EQU	$003B
COPTCTL:	EQU	$003C
FORBYP:	EQU	$003D
CTCTL:		EQU	$003E
ARMCOP:	EQU	$003F

;TIM0 - Timer 16 Bit 4 Channels
T0TIOS:		EQU	$0040		;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
T0CFORC:	EQU	$0041		;CFORC - TIMER COMPARE FORCE REGISTER
T0OC7M:		EQU	$0042		;OC7M - OUTPUT COMPARE 7 MASK REGISTER
T0OC7D:		EQU	$0043		;OC7D - OUTPUT COMPARE 7 DATA REGISTER

T0TCNT:		EQU	$0044
T0TCNTH:	EQU	$0044
T0TCNTL:	EQU	$0045

T0TSCR1:	EQU	$0046		;TSCR - TIMER SYSTEM CONTROL REGISTER
T0TTOV:		EQU	$0047
T0TCTL1:		EQU	$0048		;TCTL1 - TIMER CONTROL REGISTER 1
T0TCTL3:		EQU	$004A		;TCTL3 - TIMER CONTROL REGISTER 3

T0TIE:		EQU	$004C

T0TSCR2:	EQU	$004D
T0TFLG1:	EQU	$004E		;TFLG1 - TIMER INTERRUPT FLAG 1
T0TFLG2:	EQU	$004F		;TFLG2 - TIMER INTERRUPT FLAG2

T0TC4:		EQU	$0058		;TC4 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
T0TC5:		EQU	$005A		;TC5 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
T0TC6:		EQU	$005C		;TC6 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
T0TC7:		EQU	$005E		;TC7 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0

T0PACTL:	EQU	$0060		;PATCL - PULSE ACCUMULATOR CONTROL REGISTER
T0PAFLG:	EQU	$0061		;PAFLG - PULSE ACCUMULATOR FLAG REGISTER
T0PACNT:	EQU	$0062		;PACN3 - HI BYTE
T0PACNTH:	EQU	$0062		;PACN3 - HI BYTE
T0PACNTL:	EQU	$0063		;PACN2 - LO BYTE

;ATD - Analog to Digital Converter 10 Bit 16 Channel
ATDCTL0:	EQU	$0080		;ATDCTL0 - RESERVED
ATDCTL1:	EQU	$0081		;ATDCTL1 - RESERVED
ATDCTL2:	EQU	$0082		;ATDCTL2 - ATD CONTROL REGISTER
ATDCTL3:	EQU	$0083		;ATDCTL3 - ATD CONTROL REGISTER
ATDCTL4:	EQU	$0084		;ATDCTL4 - ATD CONTROL REGISTER
ATDCTL5:	EQU	$0085		;ATDCTL5 - ATD CONTROL REGISTER
ATDSTAT0: 	EQU	$0086	

ATDTEST0:	EQU	$0088	;ATDTEST
ATDTEST1:	EQU	$0089	;ATDTEST

ATDSTAT2:	EQU	$8A
ATDSTAT1:	EQU	$8B

ATDDIEN:	EQU	$8D
PTAD:		EQU	$008F
PORTAD:		EQU	$008F		;PORTAD - PORT AD DATA INPUT REGISTER

ATDDR0H:	EQU	$0090
ATDDR0L:	EQU	$0091
ATDDR1H:	EQU	$0092
ATDDR1L:	EQU	$0093
ATDDR2H:	EQU	$0094
ATDDR2L:	EQU	$0095
ATDDR3H:	EQU	$0096
ATDDR3L:	EQU	$0097
ATDDR4H:	EQU	$0098
ATDDR4L:	EQU	$0099
ATDDR5H:	EQU	$009A
ATDDR5L:	EQU	$009B
ATDDR6H:	EQU	$009C
ATDDR6L:	EQU	$009D
ATDDR7H:	EQU	$009E
ATDDR7L:	EQU	$009F

;Registers $A0 to $C7 are reserved

;SCI0 - Asynchronous Serial Interface
SCI0BDH:	EQU	$00C8		;SCI0BDH - SCI BAUD RATE CONTROL REGISTER
SCI0BDL:	EQU	$00C9		;SCI0BDL - SCI BAUD RATE CONTROL REGISTER
SCI0CR1:	EQU	$00CA		;SCI0CR1 - SCI CONTROL REGISTER
SCI0CR2:	EQU	$00CB		;SCI0CR2 - SCI CONTROL REGISTER
SCI0SR1:	EQU	$00CC		;SCI0SR1 - SCI STATUS REGISTER
SCI0SR2:	EQU	$00CD		;SCI0SR2 - SCI STATUS REGISTER
SCI0DRH:	EQU	$00CE		;SCI0DRH - SCI DATA REGISTER
SCI0DRL:	EQU	$00CF		;SCI0DRL - SCI DATA REGISTER

;SCI1 - Asynchronous Serial Interface
SCI1BDH:	EQU	$00D0		;SCI1BDH -
SCI1BDL:	EQU	$00D1		;SCI1BDL -
SCI1CR1:	EQU	$00D2		;SCI1CR1 -
SCI1CR2:	EQU	$00D3		;SCI1CR2 -
SCI1SR1:	EQU	$00D4		;SCI1SR1 -
SCI1SR2:	EQU	$00D5		;SCI1SR2 -
SCI1DRH:	EQU	$00D6		;SCI1DRH -
SCI1DRL:	EQU	$00D7		;SCI1DRL -

;SPI - Serial Peripheral Interface
SPI0CR1:	EQU	$00D8		;SPI0CR1 - SPI CONTROL REGISTER
SPI0CR2:	EQU	$00D9		;SPI0CR2 - SPI CONTROL REGISTER
SPI0BR:		EQU	$00DA		;SPI0BR - SPI BAUD RATE REGISTER
SPI0SR:		EQU	$00DB		;SPI0SR - SPI STATUS REGISTER
SPI0DR:		EQU	$00DD		;SPI0DR - SPI DATA REGISTER

;IIC - Inter-IC Bus
IBAD:		EQU	$00E0		;IBAD -
IBFD:		EQU	$00E1		;IFBD -
IBCR:		EQU	$00E2		;IBCR -
IBSR:		EQU	$00E3		;IBSR -
IICDR:		EQU	$00E4		;IIBDR -

;Registers $E8 to $FF are reserved 

;Flash Control Register
FCLKDIV:	EQU	$100
FSEC:		EQU	$101
FCNFG:		EQU	$103
FPROT:		EQU	$104
FSTAT:		EQU	$105
FCMD:		EQU	$106

;Registers $10C to $11F are reserved 

;Ethernet Physical Transceiver (EPHY)
EPHYCTL0:	EQU	$120
EPHYCTL1:	EQU	$121
EPHYSR:	EQU	$122
EPHYTST:	EQU	$123

;Registers $124 to $13F are reserved 

;Ethernet Media Access Controller (EMAC)
NETCTL:		EQU	$0140

RXCTS:		EQU	$0143
TXCTS:		EQU	$0144
ETCTL:		EQU	$0145
ETYPE:		EQU	$0146
PTIME:		EQU	$0148
IEVENT:		EQU	$014A
IMASK:		EQU	$014C
T1TCTL3:		EQU	$014A
T1TIE:		EQU	$014C
T1TSCR2:	EQU	$014D
SWRST:		EQU	$014E

MPADR:		EQU	$0150
MWDATA:	EQU	$0152
MRDATA:	EQU	$0154
MCMST:		EQU	$0156

BUFCFG:	EQU	$0158
RXAEFP:		EQU	$015A
RXBEFP:		EQU	$015C
TXEFP:		EQU	$015E

MCHASH:	EQU	$0160
MACAD:		EQU	$0168
EMACMISC:	EQU	$016E

;Registers $170 to $23F are reserved 

PORTT:		equ	$0240	; Port T data register (alternate name).
PTT:		equ	$0240	; Port T data register.
PTIT:		equ	$0241	; Port T input pin register.
DDRT:		equ	$0242	; Port T data direction register.
RDRT:		equ	$0243	; Port T Reduced drive enable register.
PERT:		equ	$0244	; Port T pull up/down enable register.
PPST:		equ	$0245	; Port T pull up/down select (polarity) register.
;
PORTS:		equ	$0248	; Port S data register (alternate name).
PTS:		equ	$0248	; Port S data register.
PTIS:		equ	$0249	; Port S input pin register.
DDRS:		equ	$024a	; Port S data direction register.
RDRS:		equ	$024b	; Port S Reduced drive enable register.
PERS:		equ	$024c	; Port S pull up/down enable register.
PPSS:		equ	$024d	; Port S pull up/down select (polarity) register.
WOMS:		equ	$024E	; Port S Wired-Or (open drain) select register.

PORTG:		equ	$0250	; Port G data register (alternate name).
PTG:		equ	$0250	; Port G data register.
PTIG:		equ	$0251	; Port G input pin register.
DDRG:		equ	$0252	; Port G data direction register.
RDRG:		equ	$0253	; Port G Reduced drive enable register.
PERG:		equ	$0254	; Port G pull up/down enable register.
PPSG:		equ	$0255	; Port G pull up/down select (polarity) register.
PIEG:		equ	$0256	; Port G interrupt enable register.
PIFG:		equ	$0257	; Port G interrupt flag register.
;
PORTH:		equ	$0258	; Port H data register (alternate name).
PTH:		equ	$0258	; Port H data register.
PTIH:		equ	$0259	; Port H input pin register.
DDRH:		equ	$025a	; Port H data direction register.
RDRH:		equ	$025b	; Port H Reduced drive enable register.
PERH:		equ	$025c	; Port H pull up/down enable register.
PPSH:		equ	$025d	; Port H pull up/down select (polarity) register.
PIEH:		equ	$025e	; Port H interrupt enable register.
PIFH:		equ	$025f	; Port H interrupt flag register.
;
PORTJ:		equ	$0260	; Port J data register (alternate name).
PTJ:		equ	$0260	; Port J data register.
PTIJ:		equ	$0261	; Port J input pin register.
DDRJ:		equ	$0262	; Port J data direction register.
RDRJ:		equ	$0263	; Port J Reduced drive enable register.
PERJ:		equ	$0264	; Port J pull up/down enable register.
PPSJ:		equ	$0265	; Port J pull up/down select (polarity) register.
PIEJ:		equ	$0266	; Port J interrupt enable register.
PIFJ:		equ	$0267	; Port J interrupt flag register.
;
PORTL:		equ	$0268	; Port L data register (alternate name).
PTL:		equ	$0268	; Port L data register.
PTIL:		equ	$0269	; Port L input pin register.
DDRL:		equ	$026a	; Port L data direction register.
RDRL:		equ	$026b	; Port L Reduced drive enable register.
PERL:		equ	$026c	; Port L pull up/down enable register.
PPSL:		equ	$026d	; Port L pull up/down select (polarity) register.
WOML:		equ	$026e	; Port L Wired-Or (open drain) select register.
;
;Registers $270 to $3FF are reserved


