
/*------------------------------------------------------------------------------
	mc9s12e_vectors.s
		
	MC9S12NE-Family interrupt vector table
			
	Author : Pierre Morency <pmorency@globetrotter.net>

	Created: 24.jun.2004
	Revised: 
--------------------------------------------------------------------------------

 Copyright  2004, Pierre Morency.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

    * Neither the name of author nor the names of its contributors
      may be used to endorse or promote products derived from this
      software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

------------------------------------------------------------------------------*/

	.sect .text
	.globl _start

;; Default interrupt handler.
	.sect .text

def:	rti

;; Interrupt vectors are in a specific section that is mapped at 0xff80.
;; The reset handler points to the generic _start entry point.

	.sect .vectors
	.globl vectors

vectors:

	.word def					; ff80 (reserved)
	.word def					; ff82 (reserved)
	.word def					; ff84 (reserved)
	.word def					; ff86 (reserved)
	.word def					; ff88 (reserved)
	.word def					; ff8a (reserved)
	.word def					; ff8c (reserved)
	.word def					; ff8e (reserved)
	.word def					; ff90 (reserved)
	.word def					; ff92 (reserved)
	.word def					; ff94 (reserved)
	.word def					; ff96 (reserved)
	.word def					; ff98 (reserved)
	.word def					; ff9a (reserved)
	.word def					; ff9c (reserved)
	.word def					; ff9e (reserved)

	.word emac_EC_service		; ffa0 (EMAC excessive collision)
	.word emac_LC_service		; ffa2 (EMAC late collision)
	.word emac_BRE_service		; ffa4 (EMAC babbling rx error)
	.word emac_RXO_service		; ffa6 (EMAC rx B overrun)
	.word emac_RXO_service		; ffa8 (EMAC rx A overrrun)
	.word emac_RXE_service		; ffaa (EMAC rx error)
	.word def					; ffac (EMAC MII management)
	.word emac_RFC_service		; ffae (EMAC rx flow control)
	.word emac_TXC_service		; ffb0 (EMAC tx complete)
	.word def					; ffb2 (EMAC rx B complete)
	.word def					; ffb4 (EMAC rx A complete)
	.word def					; ffb6 (EPHY)
	
	.word def					; ffb8 (FLASH)
	.word def					; ffba (reserved)
	.word def					; ffbc (reserved)
	.word def					; ffbe (reserved)

	.word def					; ffc0 (IIC Bus)
	.word def					; ffc2 (reserved)

	.word def					; ffc4 (Self clock)
	.word def					; ffc6 (PLL lock)
	.word def					; ffc8 (reserved)

	.word def					; ffca (Port G)
	.word def					; ffcc (Port H)
	.word def					; ffce (Port J)
	.word def					; ffd0 (reserved)

	.word def		 			; ffd2 (ATD)
	.word def		     		; ffd4 (SCI1)
	.word def              		; ffd6 (SCI0)
	.word def					; ffd8 (SPI)
	
	.word def					; ffda (PAII)
	.word def					; ffdc (PAOVI)
	.word def					; ffde (TOI)
	.word def					; ffe0 (timer channel 7)
	.word def					; ffe2 (timer channel 6)
	.word def					; ffe4 (timer channel 5)
	.word timers_service		; ffe6 (timer channel 4)

	.word def					; ffe8 (reserved)
	.word def					; ffea (reserved)
	.word def					; ffec (reserved)
	.word def					; ffee (reserved)

	.word def					; fff0 (RTI)
	.word def					; fff2 (IRQ)
	.word def					; fff4 (XIRQ)
	.word def		  			; fff6 (SWI)
	.word def					; fff8 (Illegal OP) 
	.word def		    		; fffa (COP Failure)
	.word def					; fffc (COP Clock monitor)
	.word _start				; fffe (power-on reset)
