;HardwareTest.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 15, 2005	1.00		Initial release
*
*
*Author: Exequiel Rarama for the Adapt9S12NE64
*******************************************************************************
;Assembled using CW
;
; ---------------------------
; Demo - HardwareTest Routine
; ---------------------------

	include "NE64Regs.INC"
	include "PacketFrame.inc"

;Public Function
	XDEF HardwareTestGo
	XDEF HardwareTestInit
	XDEF HardwareReady

;Public Variables
	XDEF hardware_state
	XDEF testFlag

;Public Tones

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF SendDecByte		;Hex to Decimal conversion


;External Variables

	XREF adflag

DataSec:SECTION
Var		ds	3
hardware_state	ds	2
count		ds	1
Error		ds	1
testFlag	ds	1
PassFailFlag	ds	1

;

PUPAE		equ	%00000001		;Port A pullup
PUPBE		equ	%00000010
PUPEE		equ	%00010000
PUPKE		equ	%10000000

switch		equ	%01000000		;Port A bit 6

;***********************************************************************************************
NON_BANKED:SECTION
;
HardwareTestInit				;Testing the Hardware ports
	bset	PUCR,PUPAE+PUPBE+PUPEE+PUPKE	;Enable all pull up's

	movb	#$FF,PERT
	movb	#$FF,PERS
	movb	#$FF,PERJ

	movw	#HardwareReady,hardware_state
	clr	testFlag
	clr	PassFailFlag

goEx
	rts

HardwareReady
	rts


HardwareTestGo
	movw	#WaitForChar,hardware_state

	ldx	#WarningMSG1
	jsr	OutStr0

	bclr	RXCTS,PROM			;Enable Promiscuous
	bclr	NETCTL,EMACE			;Enable EMAC

	movb	#%01110000,EPHYCTL0		;Disable Link LED
	nop
	nop
;	bclr	EPHYCTL0,EPHYEN			;Disable EPHY

	ldx	#WarningMSG1a
	jsr	OutStr0

	ldx	#WarningMSG2
	jsr	OutStr0
	movb	#1,testFlag

	clr	PassFailFlag
	rts

WaitForChar
	ldaa	testFlag
	bne	WaitForCharEx

	movw	#HardwareTestAB,hardware_state
	clr	PassFailFlag

WaitForCharEx
	rts

;---------------------------------------------------------------------------------------------
HardwareTestAB
;Start checking on Port A driving B

	ldx	#TestMSG1
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRA	;make Port A o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortB20

CheckPortB10
	lsl	Var

CheckPortB20
	dec	Var+1
	beq	CheckPortBDone
	movb	Var,PORTA

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTB
	stab	Var+2
	cmpb	Var
	beq	CheckPortB10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortB10	;Go continue the test

CheckPortBDone
	ldaa	Error
	beq	CheckPortBDoneEx10

	ldx	#Error1
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortBDoneEx

CheckPortBDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortBDoneEx
	movw	#HardwareTestBA,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestBA
;Start checking on Port B driving A

	ldx	#TestMSG2
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRB	;make Port B o/p
	movb	#$00,DDRA	;make Port A i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortA20

CheckPortA10
	lsl	Var

CheckPortA20
	dec	Var+1
	beq	CheckPortADone

	movb	Var,PORTB

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTA
	stab	Var+2
	cmpb	Var
	beq	CheckPortA10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortA10	;Go continue the test

CheckPortADone
	ldaa	Error
	beq	CheckPortADoneEx10

	ldx	#Error2
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortADoneEx

CheckPortADoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortADoneEx
	movw	#HardwareTestKA,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;---------------------------------------------------------------------------------------------
HardwareTestKA
;Start checking on Port K driving A

	ldx	#TestMSG4
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRK	;make Port K o/p
	movb	#$00,DDRA	;make Port A i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortAA20

CheckPortAA10
	lsl	Var

CheckPortAA20
	dec	Var+1
	beq	CheckPortAADone

	movb	Var,PORTK

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTA
	stab	Var+2
	cmpb	Var
	beq	CheckPortAA10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortAA10	;Go continue the test

CheckPortAADone
	ldaa	Error
	beq	CheckPortAADoneEx10

	ldx	#Error4
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortAADoneEx

CheckPortAADoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortAADoneEx
	movw	#HardwareTestAK,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;---------------------------------------------------------------------------------------------
HardwareTestAK
;Start checking on Port A driving K

	ldx	#TestMSG3
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRA	;make Port A o/p
	movb	#$00,DDRK	;make Port K i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortK20

CheckPortK10
	lsl	Var

CheckPortK20
	dec	Var+1
	beq	CheckPortKDone
	movb	Var,PORTA

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTK
	stab	Var+2
	cmpb	Var
	beq	CheckPortK10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortK10	;Go continue the test

CheckPortKDone
	ldaa	Error
	beq	CheckPortKDoneEx10

	ldx	#Error3
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortKDoneEx

CheckPortKDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortKDoneEx
	movw	#HardwareTestKL,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------

HardwareTestKL
;Start checking on Port K driving L

	ldx	#TestMSG5
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRK	;make Port K o/p
	movb	#$00,DDRL	;make Port L i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#8,Var+1	;Initialize counter	
	bra	CheckPortL20

CheckPortL10
	lsl	Var

CheckPortL20
	dec	Var+1
	beq	CheckPortLDone

	movb	Var,PORTK

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTL
	andb	#%01111111
	stab	Var+2
	cmpb	Var
	beq	CheckPortL10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortL10	;Go continue the test

CheckPortLDone
	ldaa	Error
	beq	CheckPortLDoneEx10

	ldx	#Error5
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortLDoneEx

CheckPortLDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortLDoneEx
	movw	#HardwareTestLK,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestLK
;Start checking on Port L driving K

	ldx	#TestMSG5
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRL	;make Port L o/p
	movb	#$00,DDRK	;make Port K i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#8,Var+1	;Initialize counter	
	bra	CheckPortKK20

CheckPortKK10
	lsl	Var

CheckPortKK20
	dec	Var+1
	beq	CheckPortKKDone

	movb	Var,PORTL

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTK
	andb	#%01111111
	stab	Var+2
	cmpb	Var
	beq	CheckPortKK10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortKK10	;Go continue the test

CheckPortKKDone
	ldaa	Error
	beq	CheckPortKKDoneEx10

	ldx	#Error6
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortKKDoneEx

CheckPortKKDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortKKDoneEx
	movw	#HardwareTestBJ,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestBJ
;Start checking on Port B driving J

	ldx	#TestMSG7
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRB	;make Port B o/p
	movb	#$00,DDRJ	;make Port J i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#5,Var+1	;Initialize counter	
	bra	CheckPortJ20

CheckPortJ10
	lsl	Var

CheckPortJ20
	dec	Var+1
	beq	CheckPortJDone

	movb	Var,PORTB

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTJ
	andb	#%00001111
	stab	Var+2
	cmpb	Var
	beq	CheckPortJ10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortJ10	;Go continue the test

CheckPortJDone
	ldaa	Error
	beq	CheckPortJDoneEx10

	ldx	#Error7
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortJDoneEx

CheckPortJDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortJDoneEx
	movw	#HardwareTestJB,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;---------------------------------------------------------------------------------------------
HardwareTestJB
;Start checking on Port J driving B

	ldx	#TestMSG8
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRJ	;make Port J o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#5,Var+1	;Initialize counter	
	bra	CheckPortBB20

CheckPortBB10
	lsl	Var

CheckPortBB20
	dec	Var+1
	beq	CheckPortBBDone
	movb	Var,PORTJ

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTB
	andb	#%00001111
	stab	Var+2
	cmpb	Var
	beq	CheckPortBB10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortBB10	;Go continue the test

CheckPortBBDone
	ldaa	Error
	beq	CheckPortBBDoneEx10

	ldx	#Error8
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortBBDoneEx

CheckPortBBDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortBBDoneEx
	movw	#HardwareTestB67J67,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestB67J67
;Start checking on Port B driving J

	ldx	#TestMSG9
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRB	;make Port B o/p
	movb	#$00,DDRJ	;make Port J i/p

	movb	#%01000000,Var	;Initialize to 6th bit
	movb	#3,Var+1	;Initialize counter	
	bra	CheckPortJJ20

CheckPortJJ10
	lsl	Var

CheckPortJJ20
	dec	Var+1
	beq	CheckPortJJDone

	movb	Var,PORTB

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTJ
	andb	#%11000000
	stab	Var+2
	cmpb	Var
	beq	CheckPortJJ10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortJJ10	;Go continue the test

CheckPortJJDone
	ldaa	Error
	beq	CheckPortJJDoneEx10

	ldx	#Error9
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortJJDoneEx

CheckPortJJDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortJJDoneEx
	movw	#HardwareTestJ67B67,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;---------------------------------------------------------------------------------------------
HardwareTestJ67B67
;Start checking on Port J driving B

	ldx	#TestMSG10
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRJ	;make Port J o/p
	movb	#$00,DDRB	;make Port B i/p

	movb	#%01000000,Var	;Initialize to 6th bit
	movb	#3,Var+1	;Initialize counter	
	bra	CheckPortBBB20

CheckPortBBB10
	lsl	Var

CheckPortBBB20
	dec	Var+1
	beq	CheckPortBBBDone
	movb	Var,PORTJ

	clrb
	dbne	b,*           ;delay to allow sw pin to pull up

	ldab	PORTB
	andb	#%11000000
	stab	Var+2
	cmpb	Var
	beq	CheckPortBBB10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortBBB10	;Go continue the test

CheckPortBBBDone
	ldaa	Error
	beq	CheckPortBBBDoneEx10

	ldx	#Error10
	jsr	OutStr0
	inc	PassFailFlag		;Error increment flag
	bra	CheckPortBBBDoneEx

CheckPortBBBDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortBBBDoneEx
	movw	#HardwareTestSG,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestSG
;Start checking on Port S driving G
	ldx	#TestMSG13
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRS		;make Port S o/p
	movb	#$00,DDRG		;make Port G i/p

	movb	#%00000100,Var		;Initialize to 1st bit
	movb	#7,Var+1		;Initialize counter	
	bra	CheckPortG20

CheckPortG10
	lsl	Var

CheckPortG20
	dec	Var+1
	beq	CheckPortGDone
	movb	Var,PORTS

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTG
	andb	#%11111100
	stab	Var+2
	cmpb	Var
	beq	CheckPortG10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortG10	;Go continue the test

CheckPortGDone
	ldaa	Error
	beq	CheckPortGDoneEx10

	ldx	#Error13
	jsr	OutStr0
	bra	CheckPortGDoneEx

CheckPortGDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortGDoneEx
	movw	#HardwareTestGS,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestGS
;Start checking on Port G driving S
	ldx	#TestMSG12
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRG		;make Port G o/p
	movb	#$00,DDRS		;make Port S i/p

	movb	#%00000100,Var		;Initialize to 1st bit
	movb	#7,Var+1		;Initialize counter	
	bra	CheckPortS20

CheckPortS10
	lsl	Var

CheckPortS20
	dec	Var+1
	beq	CheckPortSDone
	movb	Var,PORTG

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTS
	andb	#%11111100
	stab	Var+2
	cmpb	Var
	beq	CheckPortS10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortS10	;Go continue the test

CheckPortSDone
	ldaa	Error
	beq	CheckPortSDoneEx10

	ldx	#Error12
	jsr	OutStr0
	bra	CheckPortSDoneEx

CheckPortSDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortSDoneEx
	movw	#HardwareTestHG,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestHG
;Start checking on Port H driving G
	ldx	#TestMSG14
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRH		;make Port H o/p
	movb	#$00,DDRG		;make Port G i/p

	movb	#%00000001,Var		;Initialize to 1st bit
	movb	#8,Var+1		;Initialize counter	
	bra	CheckPortGG20

CheckPortGG10
	lsl	Var

CheckPortGG20
	dec	Var+1
	beq	CheckPortGGDone
	movb	Var,PORTH

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTG
	andb	#%01111111
	stab	Var+2
	cmpb	Var
	beq	CheckPortGG10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortGG10	;Go continue the test

CheckPortGGDone
	ldaa	Error
	beq	CheckPortGGDoneEx10

	ldx	#Error14
	jsr	OutStr0
	bra	CheckPortGGDoneEx

CheckPortGGDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortGGDoneEx
	movw	#HardwareTestGH,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestGH
;Start checking on Port G driving H
	ldx	#TestMSG15
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRG		;make Port G o/p
	movb	#$00,DDRH		;make Port H i/p

	movb	#%00000001,Var		;Initialize to 1st bit
	movb	#8,Var+1		;Initialize counter	
	bra	CheckPortH20

CheckPortH10
	lsl	Var

CheckPortH20
	dec	Var+1
	beq	CheckPortHDone
	movb	Var,PORTG

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTH
	andb	#%01111111
	stab	Var+2
	cmpb	Var
	beq	CheckPortH10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortH10	;Go continue the test

CheckPortHDone
	ldaa	Error
	beq	CheckPortHDoneEx10

	ldx	#Error15
	jsr	OutStr0
	bra	CheckPortHDoneEx

CheckPortHDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortHDoneEx
	movw	#HardwareTestTS,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestTS
;Start checking on Port T driving S
	ldx	#TestMSG16
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRT		;make Port T o/p
	movb	#$00,DDRS		;make Port S i/p

	movb	#%00010000,Var		;Initialize to 1st bit
	movb	#5,Var+1		;Initialize counter	
	bra	CheckPortSS20

CheckPortSS10
	lsl	Var

CheckPortSS20
	dec	Var+1
	beq	CheckPortSSDone
	movb	Var,PORTT

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTS
	andb	#%11110000
	stab	Var+2
	cmpb	Var
	beq	CheckPortSS10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortSS10	;Go continue the test

CheckPortSSDone
	ldaa	Error
	beq	CheckPortSSDoneEx10

	ldx	#Error16
	jsr	OutStr0
	bra	CheckPortSSDoneEx

CheckPortSSDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortSSDoneEx
	movw	#HardwareTestST,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestST
;Start checking on Port S driving T
	ldx	#TestMSG17
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRS		;make Port S o/p
	movb	#$00,DDRT		;make Port T i/p

	movb	#%00010000,Var		;Initialize to 1st bit
	movb	#5,Var+1		;Initialize counter	
	bra	CheckPortT20

CheckPortT10
	lsl	Var

CheckPortT20
	dec	Var+1
	beq	CheckPortTDone
	movb	Var,PORTS

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTT
	andb	#%11110000
	stab	Var+2
	cmpb	Var
	beq	CheckPortT10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortT10	;Go continue the test

CheckPortTDone
	ldaa	Error
	beq	CheckPortTDoneEx10

	ldx	#Error17
	jsr	OutStr0
	bra	CheckPortTDoneEx

CheckPortTDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortTDoneEx
	movw	#HardwareTestSE,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestSE
;Start checking on Port S driving E
	ldx	#TestMSG18
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRS		;make Port S o/p
	movb	#$00,DDRE		;make Port E i/p

	movb	#%00000100,Var		;Initialize to 1st bit
	movb	#4,Var+1		;Initialize counter	
	bra	CheckPortE20

CheckPortE10
	lsl	Var

CheckPortE20
	dec	Var+1
	beq	CheckPortEDone
	movb	Var,PORTS

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%00011100
	stab	Var+2
	cmpb	Var
	beq	CheckPortE10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortE10	;Go continue the test

CheckPortEDone
	ldaa	Error
	beq	CheckPortEDoneEx10

	ldx	#Error18
	jsr	OutStr0
	bra	CheckPortEDoneEx

CheckPortEDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortEDoneEx
	movw	#HardwareTestHE,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestHE
;Start checking on Port H driving E
	ldx	#TestMSG19
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRH		;make Port H o/p
	movb	#$00,DDRE		;make Port E i/p

	movb	#%00000001,Var		;Initialize to 1st bit
	movb	#3,Var+1		;Initialize counter	
	bra	CheckPortEE20

CheckPortEE10
	lsl	Var

CheckPortEE20
	dec	Var+1
	beq	CheckPortEEDone
	movb	Var,PORTH

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%00000011
	stab	Var+2
	cmpb	Var
	beq	CheckPortEE10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortEE10	;Go continue the test

CheckPortEEDone
	ldaa	Error
	beq	CheckPortEEDoneEx10

	ldx	#Error19
	jsr	OutStr0
	bra	CheckPortEEDoneEx

CheckPortEEDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortEEDoneEx
	movw	#HardwareTestSlE,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
;Start Testing Port S bit 7 driving Port E bit 7 Low
;
HardwareTestSlE
	movb	#$80,DDRS		;make Port S o/p
	movb	#$00,DDRE		;make Port E i/p

	ldx	#TestMSG20
	jsr	OutStr0

	clr	Error

	movb	#0,PORTS
	clr	Var

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%10000000
	stab	Var+2
	cmpb	Var
	beq	CheckPortEEE10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte		;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte		;Convert Value

	movb	#1,Error		;Set error flag
	inc	PassFailFlag		;Error increment flag

CheckPortEEE10
	ldaa	Error
	beq	CheckPortEEEDoneEx10

	ldx	#Error20
	jsr	OutStr0
	bra	CheckPortEEEDoneEx

CheckPortEEEDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortEEEDoneEx
	movw	#HardwareTestShE,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts


;----------------------------------------------------------------------------------------------
;Start Testing Port S bit 7 driving Port E bit 7 high
;
HardwareTestShE
	movb	#$80,DDRS		;make Port S o/p
	movb	#$00,DDRE		;make Port E i/p

	ldx	#TestMSG21
	jsr	OutStr0

	clr	Error

	movb	#$80,PORTS
	movb	#$80,Var

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%10000000
	stab	Var+2
	cmpb	Var
	beq	CheckPortEEEE10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte		;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte		;Convert Value

	movb	#1,Error		;Set error flag
	inc	PassFailFlag		;Error increment flag

CheckPortEEEE10
	ldaa	Error
	beq	CheckPortEEEEDoneEx10

	ldx	#Error21
	jsr	OutStr0
	bra	CheckPortEEEEDoneEx

CheckPortEEEEDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortEEEEDoneEx
	movw	#HardwareTestGAD,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

	rts

;----------------------------------------------------------------------------------------------
HardwareTestGAD			   ;The AD is input only
;Initialize Analog To Digital
	movb	#$00,ATDCTL2	        ;Power down or disable ATD
	movb	#$00,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#1,adflag

;Start checking on Port G driving AD
	ldx	#TestMSG11
	jsr	OutStr0

	clr	Error

	movb	#$FF,ATDDIEN		;Enable ATD channel as Digital input
	movb	#$FF,DDRG		;make Port T o/p

	movb	#1,Var			;Initialize to 1st bit
	movb	#9,Var+1		;Initialize counter	
	bra	CheckPortAD20

CheckPortAD10
	lsl	Var

CheckPortAD20
	dec	Var+1
	beq	CheckPortADDone
	movb	Var,PORTG

	clrb
	dbne	b,*         		 ;delay to allow sw pin to pull up

	ldab	PTAD
	stab	Var+2
	cmpb	Var
	beq	CheckPortAD10

	ldx	#TestMSGSent
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#TestMSGReceive
	jsr	OutStr0

	ldab	Var+2
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	bra	CheckPortAD10	;Go continue the test

CheckPortADDone
	ldaa	Error
	beq	CheckPortADDoneEx10

	ldx	#Error11
	jsr	OutStr0
	bra	CheckPortADDoneEx

CheckPortADDoneEx10
	ldx	#TestMSGPass
	jsr	OutStr0

CheckPortADDoneEx
	movw	#HardwareTestGS,hardware_state

	movb	#$00,DDRA
	movb	#$00,DDRB
	movb	#$00,DDRE
	movb	#$00,DDRG
	movb	#$00,DDRH
	movb	#$00,DDRJ
	movb	#$00,DDRK
	movb	#$00,DDRL
	movb	#$00,DDRS
	movb	#$00,DDRT

;	rts


;----------------------------------------------------------------------------------------------


CheckPortMMMMDoneEx
	ldaa	PassFailFlag	;Check Pass or Fail flag
	beq	ExitTest10

	ldx	#HardwareFailed
	jsr	OutStr0

	bra	ExitTest20

ExitTest10
	ldx	#HardwarePass
	jsr	OutStr0

ExitTest20
	movw	#HardwareReady,hardware_state
	ldx	#WarningMSG3
	jsr	OutStr0
	rts


littleDelay
	clrb
	dbne	b,*           ;delay to allow sw pin to pull up
	rts


;----------------------------------------------------------------------------------------------
WarningMSG1	dc.b	$D,$A,'Ethernet Disabled',0
WarningMSG1a	dc.b	$D,$A,'Remove Jumper Block JB2 and JB3',$D,$A,0
WarningMSG2	dc.b	'Press Any Key when READY',$D,$A,0
WarningMSG3	dc.b	$D,$A,'Press RESET when DONE',$D,$A,0

HardwareFailed	dc.b	$D,$A,'Port TEST = FAILED',$D,$A,0
HardwarePass	dc.b	$D,$A,'Port TEST = PASS',$D,$A,0
TestMSGPass	dc.b	'Pass',$D,$A,0

TestMSGSent	dc.b	$D,$A,'Sent     ',0
ErrorSent	equ	TestMSGSent	
TestMSGReceive	dc.b	$D,$A,'Received ',0
ErrorReceive    equ	TestMSGReceive


TestMSG1	dc.b	$D,$A,'Test ->Port A driving Port B on H2',$D,$A,0
TestMSG2	dc.b	$D,$A,'Test ->Port B driving Port A on H2',$D,$A,0

TestMSG3	dc.b	$D,$A,'Test ->Port A driving Port K on H2',$D,$A,0
TestMSG4	dc.b	$D,$A,'Test ->Port K driving Port A on H2',$D,$A,0

TestMSG5	dc.b	$D,$A,'Test ->Port K driving Port L on H2',$D,$A,0
TestMSG6	dc.b	$D,$A,'Test ->Port L driving Port K on H2',$D,$A,0

TestMSG7	dc.b	$D,$A,'Test ->Port B bit 0-3 driving Port J bit 0-3 on H2',$D,$A,0
TestMSG8	dc.b	$D,$A,'Test ->Port J bit 0-3 driving Port B bit 0-3 on H2',$D,$A,0

TestMSG9	dc.b	$D,$A,'Test ->Port B bit 6 and 7 driving Port J bit 6 and 7 on H2',$D,$A,0
TestMSG10	dc.b	$D,$A,'Test ->Port J bit 6 and 7 driving Port B bit 6 and 7 on H2',$D,$A,0

TestMSG11	dc.b	$D,$A,'Test ->Port G driving Port AD on H1',$D,$A,0

TestMSG12	dc.b	$D,$A,'Test ->Port G bit 2-7 driving Port S bit 2-7 on H1',$D,$A,0
TestMSG13	dc.b	$D,$A,'Test ->Port S bit 2-7 driving Port G bit 2-7 on H1',$D,$A,0

TestMSG14	dc.b	$D,$A,'Test ->Port H bit 0-6 driving Port G bit 0-6 on H1',$D,$A,0
TestMSG15	dc.b	$D,$A,'Test ->Port G bit 0-6 driving Port H bit 0-6 on H1',$D,$A,0

TestMSG16	dc.b	$D,$A,'Test ->Port T bit 4-7 driving Port S bit 4-7 on H1',$D,$A,0
TestMSG17	dc.b	$D,$A,'Test ->Port S bit 4-7 driving Port T bit 4-7 on H1',$D,$A,0

TestMSG18	dc.b	$D,$A,'Test ->Port S bit 2-4 driving Port E bit 2-4 on H1',$D,$A,0

TestMSG19	dc.b	$D,$A,'Test ->Port H bit 0-1 driving Port E bit 0-1 (XIRQ, IRQ) on H1',$D,$A,0

TestMSG20	dc.b	$D,$A,'Test ->Port S bit 7 driving Port E bit 7 Low',$D,$A,0
TestMSG21	dc.b	$D,$A,'Test ->Port S bit 7 driving Port E bit 7 High',$D,$A,0

;==============================================================================

Error1		dc.b	$D,$A,'Fail ->Port A driving Port B on H2',$D,$A,0
Error2		dc.b	$D,$A,'Fail ->Port B driving Port A on H2',$D,$A,0

Error3		dc.b	$D,$A,'Fail ->Port A driving Port K on H2',$D,$A,0
Error4		dc.b	$D,$A,'Fail ->Port K driving Port A on H2',$D,$A,0

Error5		dc.b	$D,$A,'Fail ->Port K driving Port L on H2',$D,$A,0
Error6		dc.b	$D,$A,'Fail ->Port L driving Port K on H2',$D,$A,0

Error7		dc.b	$D,$A,'Fail ->Port B bit 0-3 driving Port J bit 0-3 on H2',$D,$A,0
Error8		dc.b	$D,$A,'Fail ->Port J bit 0-3 driving Port B bit 0-3 on H2',$D,$A,0

Error9		dc.b	$D,$A,'Fail ->Port B bit 6 and 7 driving Port J bit 6 and 7 on H2',$D,$A,0
Error10		dc.b	$D,$A,'Fail ->Port J bit 6 and 7 driving Port B bit 6 and 7 on H2',$D,$A,0

Error11		dc.b	$D,$A,'Fail ->Port G driving Port AD on H1',$D,$A,0

Error12		dc.b	$D,$A,'Fail ->Port G bit 2-7 driving Port S bit 2-7 on H1',$D,$A,0
Error13		dc.b	$D,$A,'Fail ->Port S bit 2-7 driving Port G bit 2-7 on H1',$D,$A,0

Error14		dc.b	$D,$A,'Fail ->Port H bit 0-6 driving Port G bit 0-6 on H1',$D,$A,0
Error15		dc.b	$D,$A,'Fail ->Port G bit 0-6 driving Port H bit 0-6 on H1',$D,$A,0

Error16		dc.b	$D,$A,'Fail ->Port T bit 4-7 driving Port S bit 4-7 on H1',$D,$A,0
Error17		dc.b	$D,$A,'Fail ->Port S bit 4-7 driving Port T bit 4-7 on H1',$D,$A,0

Error18		dc.b	$D,$A,'Fail ->Port S bit 2-4 driving Port E bit 2-4 on H1',$D,$A,0

Error19		dc.b	$D,$A,'Fail ->Port H bit 0-1 driving Port E bit 0-1 (XIRQ, IRQ) on H1',$D,$A,0

Error20		dc.b	$D,$A,'Fail ->Port S bit 7 driving Port E bit 7 Low',$D,$A,0
Error21		dc.b	$D,$A,'Fail ->Port S bit 7 driving Port E bit 7 High',$D,$A,0

;---------------------------------------------------------------------------





	END

