;http.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 15, 2005	1.00		Initial release
*
*
*Author: Exequiel Rarama for the Adapt9S12NE64
*******************************************************************************
;Assembled using CW
;
; ---------------------------
; Demo - Http Routine
; ---------------------------

	include "NE64Regs.INC"		;NE64regs.INC CONTAINS ALL REGISTERS
	include "PacketFrame.inc"

;Public Function

	XDEF CheckHttp


;Public Variables


;External Messages
	XREF CurrentIPMsg

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF Dump_word
	XREF Dump_byte

	XREF RXABFlag

	XREF CalCRC
	XREF WriteBuff
	XREF CalAddOffset

	XREF ProcessTCP
	XREF CheckWhichRXBuff
	XREF ProcessFrameBuff
	XREF CopyMSG

	XREF DoTCP1
	XREF DoTCP2
;	XREF DoTCP2Session

	XREF DoTCP3
	XREF DoTCP4
	XREF DoTCP5

	XREF HTOD

;------------------------------------------------------------------------------------------------------
;External Variables

	XREF PacketBasePtr
	XREF RAMMAC

	XREF LANState
	XREF TXWriteLen
	XREF CharCounter
	XREF RAMIPAddress
	XREF TCPIPFlag

	XREF SessionFlag

	XREF DBUFR

DataSec:	SECTION

HTTPState:	ds.b	2
HttpFlag:	ds.b	1

WaitAckFlg:	ds.b	1			;This flag is set if waiting for an ACK
temp:		ds.b	2
Var1:		ds.b	2

;------------------------------------------------------------------------------------------------------
NON_BANKED:SECTION

HttpInit:
	movw	#CheckHttp,HTTPState
	clr	HttpFlag
	rts

CheckHttp:
	ldd	PacketBasePtr
	addd	#TCPFlags
	xgdx
	ldaa	0,x

	cmpa	#SYN
	lbeq	HttpSYN				;Trying to Synchronize

	cmpa	#ACK				;Only ACK, okay to send new DATA
	lbeq	HttpACK

	cmpa	#ACK+PSH			;ACK and PSH, okay to send new DATA
	lbeq	HttpPSHACK

	cmpa	#ACK+PSH+FIN			;ACK, PSH, FIN 
	lbeq	HttpFIN				;Send End of Session

	cmpa	#ACK+FIN			;ACK, FIN 
	lbeq	HttpFIN				;Send End of Session

	cmpa	#RST        			;If reset then end session
	lbeq	HttpRST				;Send End of Session

	cmpa	#RST+ACK       			;If reset then end session
	lbeq	HttpRST				;Send End of Session

ClearRXABuff:
	ldaa	RXABFlag			;Check which buffer
	bne	ClearRXBBuff

	bset	IEVENT,RXACIF			;clear Flag for next RX
	bra	CheckHttpEx

ClearRXBBuff:
	bset	IEVENT,RXBCIF			;clear Flag for next RX
						;If gets here then clear RXbuffer
CheckHttpEx:
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	clr	TCPIPFlag
	rts


HttpSYN:
	clr	HttpFlag
	movw	#goHttpSYN,LANState
	rts

HttpACK:
	clr	HttpFlag
	movw	#goHttpACK,LANState
	rts

HttpPSHACK:
	clr	HttpFlag
	movw	#goHttpPSHACK,LANState
	rts

HttpFIN:
	clr	HttpFlag
	movw	#goHttpFIN,LANState
	rts

HttpRST:
	clr	HttpFlag
	movw	#goHttpRST,LANState
	rts


;---------------------------------------------------------------------------------------------
goHttpSYN:
	movb	#1,TCPIPFlag

	ldx	#TCP0Msg
;	jsr	OutStr0

	movw	#$0000,CharCounter		;Initialize Character Counter

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$002C				;IP (= 20bytes) + TCP (= 24bytes)
	std	0,x
	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	ldd	PacketBasePtr
	addd	#IPChecksum			;Initialize IP checksum to 0
	xgdx
	movw	#00,0,x	

	clr	SessionFlag			;Make sure to increment 

	jsr	HttpIP
	jsr	ProcessTCP
	jsr	DoTCP1

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

	movb	#1,SessionFlag	;*****		;We have a telnet session

	clr	WaitAckFlg			;Make sure to clear this flag for SYN
	clr	TCPIPFlag
	clr	WaitAckFlg

	rts

;--------------------------------------------------------------------------------------------
goHttpACK:
	movb	#1,TCPIPFlag

	ldx	#TCP1Msg
;	jsr	OutStr0

	ldaa	SessionFlag	;****
	cmpa	#2		;****
;	lbeq	ProcessECommand	;****
	beq	YesWaitAck

	movw	#$0000,CharCounter		;Initialize Character Counter

	ldd	PacketBasePtr
	addd	#TCPPadding			;Start of Data to be written to
	xgdy
	
	ldx	#TestHttpMsg
	jsr	CopyMSG

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	ldd	CharCounter
	pshd
	jsr	UpDateInfo
	puld
	std	CharCounter

	jsr	HttpIP
	jsr	ProcessTCP
;	jsr	DoTCP2
	jsr	DoTCP4				;Send Data and FIN + ACK

	movb	#2,SessionFlag	;*****		;We have a telnet session

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	inc	WaitAckFlg			;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts

;-----------------------------------------------------------------------------------------
YesWaitAck:
	clr	WaitAckFlg
	jsr	ClearRXABuff
	rts

;-----------------------------------------------------------------------------------------
goHttpPSHACK:
	movb	#1,TCPIPFlag

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdy	
	ldd	0,y

	cpd	#$37				;Is it $37 bytes long
	beq	goHttpPSHACKEx

	cpd	#40				;Is it 40 bytes long
	beq	goHttpPSHACKEx	
	bra	ProcessECommand			;Go processed command 


goHttpPSHACKEx:				;<<<original
	ldx	#ACKPSHMsg
;	jsr	OutStr0

	ldd	PacketBasePtr
	ldy	#TCPPadding
	jsr	CalAddOffset			;Calculate address offset
	ldx	#PSHACKMsg	
	ldd	#3
	jsr	WriteBuff

	movw	#0006,CharCounter		;6 bytes of NULL value
;	movw	#0000,CharCounter		;No data transmitted

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	HttpIP
	jsr	ProcessTCP
	jsr	DoTCP3

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

	movb	#2,SessionFlag	;*****		;We have a telnet session
	inc	WaitAckFlg			;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts

;------------------------------------------------------------------------------------------
ProcessECommand:
	ldd	PacketBasePtr
	addd	#$45				;check command type
	xgdy
	ldaa	0,y
	staa	temp

	jsr	Dump_byte

	ldaa	temp
	anda	#$df            ;simple convert to upper case (only works for alpha char)

	cmpa	#'A'
	lbeq	PCA

NoCommand:
	jmp	goHttpPSHACKEx

PCA:
	movw	#$0000,CharCounter		;Initialize Character Counter

	ldd	PacketBasePtr
	addd	#TCPPadding			;Start of Data to be written to
	xgdy
	
	ldx	#TestHttpMsg
	jsr	CopyMSG	

	jmp	SendProcessedData


;------------------------------------------------------------------------------------------
SendProcessedData:
	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	HttpIP
	jsr	ProcessTCP
	jsr	DoTCP2

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

	movb	#2,SessionFlag	;*****		;We have a telnet session
	inc	WaitAckFlg			;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts


;--------------------------------------------------------------------------------------------
goHttpFIN:
	movb	#1,TCPIPFlag ;******
	clr	SessionFlag			;make the seq is incremented

	ldx	#FINMsg
;	jsr	OutStr0

	ldd	PacketBasePtr
	ldy	#TCPPadding
	jsr	CalAddOffset			;Calculate address offset
	ldx	#PSHACKMsg	
	ldd	#3
	jsr	WriteBuff

	movw	#0006,CharCounter		;6 bytes of NULL value

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	HttpIP
	jsr	ProcessTCP
	jsr	DoTCP4

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

;	inc	WaitAckFlg			;Sent a Package - now wait for ACK
	clr	TCPIPFlag
	rts

;--------------------------------------------------------------------------------------------
goHttpRST:
	movb	#1,TCPIPFlag	;*****

	ldx	#RSTMsg
;	jsr	OutStr0

	ldd	PacketBasePtr
	ldy	#TCPPadding
	jsr	CalAddOffset			;Calculate address offset
	ldx	#PSHACKMsg	
	ldd	#3
	jsr	WriteBuff

	movw	#0006,CharCounter		;6 bytes of NULL value

	ldd	PacketBasePtr
	addd	#IPPacketLength
	xgdx

	ldd	#$0028				;IP (= 20bytes) + TCP (= 20bytes) = 40bytes
	addd	CharCounter
	std	0,x

	addd	#14				;Header = DA + SA + Ethertype (= 14bytes)
	std	TXWriteLen

	jsr	HttpIP
	jsr	ProcessTCP
	jsr	DoTCP5

	jsr	CheckWhichRXBuff
	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer

;	inc	WaitAckFlg			;Sent a Package - now wait for ACK
	clr	TCPIPFlag

	rts


;--------------------------------------------------------------------------------------------
HttpIP:
	ldd	PacketBasePtr
	addd	#IPChecksum			;Initialize IP checksum to 0
	xgdx
	movw	#00,0,x	

	ldd	PacketBasePtr
	ldx	#IPSourceAddress		;Copy original source IP to Destination IP
	ldy	#IPDestinationAddress
	jsr	CalAddOffset			;Calculate address offset
	ldd	#2
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#IPSourceAddress
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMIPAddress			;our IP Address as source 
	ldd	#2
	jsr	WriteBuff

;****
	ldd	PacketBasePtr
	ldx	#packetSource			;Move original MAC address source as MAC address destination 
	ldy	#packetDestination
	jsr	CalAddOffset			;Calculate address offset
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#packetSource
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMMAC				;Move our MAC address to source
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldx	#IPVersion			;Start of DATA to added
	jsr	CalAddOffset			;Calculate address offset
	ldy	#20/2
	jsr	CalCRC				;Go calculate CRC
	coma
	comb
	xgdy					;Save Reg D in Y
	ldd	PacketBasePtr
	addd	#IPChecksum
	xgdy					;Restore D, Y = IPChecksum
	std	0,y				;Save Checksum into memory

;Calculate Checksum by the amount in Reg Y
	ldd	PacketBasePtr
	addd	#IPPacketLength			;Get packet length in IP header
	xgdy
	ldd	0,y
	subd	#20
	lsrd					;divide by 2
	xgdy					;Result now in Reg Y

	ldd	PacketBasePtr
	addd	#IPData				
	xgdx					;Start of Data in X
	jsr	CalCRC
	coma
	comb
	xgdx					;Save checksum and exchange with reg X
	rts


;-------------------------------------------------------------------------------------------------------
UpDateInfo:
	ldd	#PortA 		;********
	std	Var1		;********
	ldab	PORTA		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortB 		;********
	std	Var1		;********
	ldab	PORTB		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortE 		;********
	std	Var1		;********
	ldab	PORTE		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortAD 		;********
	std	Var1		;********
	ldab	PORTAD		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortK 		;********
	std	Var1		;********
	ldab	PORTK		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortG 		;********
	std	Var1		;********
	ldab	PORTG		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortH 		;********
	std	Var1		;********
	ldab	PORTH		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

             	ldd	#PortJ 		;********
	std	Var1		;********
	ldab	PORTJ		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortL 		;********
	std	Var1		;********
	ldab	PORTL		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortS 		;********
	std	Var1		;********
	ldab	PORTS		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********

	ldd	#PortT 		;********
	std	Var1		;********
	ldab	PORTT		;********
	clra					;Clear high byte
	std	temp
	jsr	DynamicData	;********
              rts

DynamicData:
	ldx	#temp
	jsr	HTOD
	movb	#0,DBUFR+5			;End of data

	ldd	PacketBasePtr
	addd	#TCPPadding			;Start of Data to be written to
	std	temp	
	
	ldd	Var1
	subd	#TestHttpMsg
	addd	temp
	xgdy

	ldx	#DBUFR+2
	jsr	CopyMSG
	rts

;-------------------------------------------------------------------------------------------------------
CrlfStr:		dc.b	$0a,$0d,$0

TCP0Msg:	dc.b	$0d,$0a,'Begin TCP Session',$0d,$0a,$0	
TCP1Msg:	dc.b	$0d,$0a,'1st Process ',$0d,$0a,$0	
TCP2Msg:	dc.b	$0d,$0a,'2nd Process ',$0d,$0a,$0	
TCP3Msg:	dc.b	$0d,$0a,'3rd Process ',$0d,$0a,$0	
TCP4Msg:	dc.b	$0d,$0a,'Calculating CRC ',$0d,$0a,$0

ACKPSHMsg:	dc.b	$0d,$0a,'PSHACK Http',$0d,$0a,$0	
FINMsg:		dc.b	$0d,$0a,'End Http Session',$0d,$0a,$0	
SYNMsg:		dc.b	$0d,$0a,'Http SYN',$0d,$0a,$0	
RSTMsg:		dc.b	$0d,$0a,'Http RESETTING',$0d,$0a,$0	

TestHttpMsg:
		dc.b	' <HTML>',$0d
		dc.b	' <meta http-equiv="refresh" content="3">',$0d
		dc.b	'<HEAD>',$0d
		dc.b	'<TITLE>9S12NE64 Web Server</TITLE>',$0d
		dc.b	'</HEAD>',$0d
		dc.b	'<BODY>',$0d
		dc.b	'<FORM ACTION=\"/index.html\" METHOD=\"POST\">',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD>',$0d
		dc.b	'<H1> Technological Arts Adapt9S12NE64 Web Server </H1>',$0d
		dc.b	'<TABLE BORDER=\"2\">',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port A</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortA:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port B</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortB:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port E</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortE:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port G</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortG:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port AD</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortAD:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port K</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortK:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port H</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortH:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port J</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortJ:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port L</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortL:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port S</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortS:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'<TR>',$0d
		dc.b	'<TD WIDTH=\"150\" HEIGHT=\"25\">Port T</TD>',$0d 
		dc.b	'<TD WIDTH=\"90\" HEIGHT=\"25\">'
PortT:		dc.b	'012'
		dc.b	'</TD>',$0d
		dc.b	'</TR>',$0d

		dc.b	'</table>',$0d
		dc.b	'<br>',$0d
		dc.b	'<br><a href=index.htm>Home page</a>',$0d

		dc.b	'</FORM>',$0d
		dc.b	'</BODY>',$0d
		dc.b	'</HTML>',$0d,0



endhere:		equ	*-TestHttpMsg

PSHACKMsg:	dc.w	$0000,$0000,$0000		

	END

