;LAN.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 15, 2005	1.00		Initial release
*
*
*Author: Exequiel Rarama for the Adapt9S12NE64
*******************************************************************************
;Assembled using CW
;
; ---------------------------
; Demo - LAN Routine
; ---------------------------

	include "NE64Regs.INC"
	include "PacketFrame.inc"

;Public Function

	XDEF LANInit
	XDEF TestARP
	XDEF ARPResponse
	XDEF ProcessFrameBuff
	XDEF TransmitFrame
	XDEF CheckWhichRXBuff

	XDEF DumpMACIP10
	XDEF WriteBuff

	XDEF CalCRC
	XDEF WriteBuff
	XDEF CalAddOffset

	XDEF CopyMSG

	XDEF ProcessTCP
	XDEF DoTCP1
	XDEF DoTCP2

	XDEF DoTCP3
	XDEF DoTCP4
	XDEF DoTCP5

	XDEF MAC_Address
	XDEF BackUp

;Public Variables

	XDEF LANState
	XDEF TXState

	XDEF LANTimer
	XDEF CrLfStr

	XDEF RAMIPAddress
	XDEF RAMMAC

	XDEF PacketBasePtr
	XDEF RXABFlag			;Which buffer set

	XDEF CharCounter
	XDEF TXWriteLen
	XDEF TCPIPFlag
	XDEF RAMEeprom		;Start of DATA to be saved

;External Messages
	XREF CurrentIPMsg

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF Dump_word
	XREF Dump_byte

	XREF CheckTelnet
	XREF CheckHttp

;External Variables
	XREF SessionFlag

DataSec:	SECTION

;Crystal Lan variables
LANState:		ds.b	2
LANTimer:		ds.b	2
TXState:		ds.b	2

RAMMAC:			ds.b	6
RAMIPAddress:		ds.b	4
TXFlag:			ds.b	1			;Frame transmit/Receive flag

RXAPacketReadLen:	ds.b	2			;2 bytes - Byte Length
RXBPacketReadLen:	ds.b	2			;2 bytes - Byte Length
PacketBasePtr:		ds.b	2

TXWriteLen:		ds.b	2
CalAdd:			ds.b	4
TempVar:		ds.b	2

RXABFlag:		ds.b	1
TCPIPFlag:		ds.b	1
CharCounter:		ds.b	2

RAMEeprom		ds.b	200

;==============================================================================
NON_BANKED:SECTION

LANInit:
	movw	#LANWait,LANState
	movw	#LANRdy,TXState
	movw	#122,LANTimer


	ldx	#MAC_Address+0			;This MAC and IP Address save into MCHASH 
	ldy	#RAMMAC			; and MACAD
	ldab	#5
	jsr	WriteBuff

	ldx	#RAMMAC			;This MAC and IP Address save into MCHASH 
	ldy	#MCHASH			; and MACAD
	ldab	#5			      
	jsr	WriteBuff

	movw	#$45EE,BUFCFG			;1536 bytes RX/TX

;	movw	#$33FF,BUFCFG			;1024 bytes RX/TX
;	movw	#$21FF,BUFCFG			;512 bytes RX/TX
;	movb	#$1FF,BUFCFG+1			;and BREIF, BREIE is set if over 512bytes

	movb	#$08,EPHYCTL0			;Enable Link LED and clear DIS100 and DIS10
	nop
	nop
	bset	EPHYCTL0,EPHYEN			;Enable EPHY

	bset	RXCTS,PROM			;Enable Promiscuous
	bset	NETCTL,EMACE			;Enable EMAC

	clr	TCPIPFlag			;
	clr	TXFlag				;0 = No pending transmit, 1 = Transmitting
	clr	RXABFlag			;used to see which buffer RXA = 0, RXB = 1

	rts

BackUp
	ldd	#CSize
	ldy	#MAC_Address
	ldx	#RAMEeprom

Copy
	movb	1,y+,1,x+
	dbne	d,Copy
	rts

;--------------------------------------------------------------------------------
LANWait:
	ldx	LANTimer
	bne	LANWaitEx

	movw	#ProcessFrameBuff,LANState

	ldx	#Msg_Init
	jsr	OutStr0	

	ldx	#CrLfStr
	jsr	OutStr0


	ldx	#CurrentMACMsg
	jsr	OutStr0

	ldx	#RAMMAC
	ldy	#6
	jsr	DumpMACIP10

	ldx	#CurrentIPMsg
	jsr	OutStr0

	ldx	#RAMIPAddress
	ldy	#4
	jsr	DumpMACIP10

	bset	IEVENT,RXACIF+RXBCIF		;clear Flag for next RX

	ldx	#CrLfStr
	jsr	OutStr0

LANWaitEx:
	rts


LANRdy:
	rts
;------------------------------------------------------------------------------
ProcessFrameBuff:				;Process the receive Packet in RXA or RXB
	ldaa	TXFlag
	bne	ProcessFrameEx

	brset	IEVENT,RXACIF,FrameRXA
	brset	IEVENT,RXBCIF,FrameRXB

ProcessFrameEx:
	rts

FrameRXA:
;	bset	IEVENT,RXACIF			;clear Flag for next RX
	movb	#0,RXABFlag

	ldd	#RXAPacketBuff
	std	PacketBasePtr
	jmp	CheckFrameBuff

FrameRXB:
;	bset	IEVENT,RXBCIF			;clear Flag for next RX
	movb	#1,RXABFlag

	ldd	#RXBPacketBuff
	std	PacketBasePtr
	jmp	CheckFrameBuff

;------------------------------------------------------------------------------
;The Frame is checked to see what is it compose of and compare against TCP, UDP, ARP, etc..
;
CheckFrameBuff:
	ldd	PacketBasePtr
	addd	#packetType			
	xgdx
	ldx	0,x
	cpx	#$0806				;Check if Ethertype = 0x0806 (ARP)
	lbne	CheckIP

	ldd	PacketBasePtr
	addd	#ARPHwType
	xgdx
	ldx	0,x
	cpx	#$0001				;Check Hardware type (1 = 10MB Ethernet)
	lbne	CheckRXABFlag			;Check which buffer to CLEAR

	ldd	PacketBasePtr
	addd	#ARPPrType
	xgdx
	ldx	0,x
	cpx	#$0800				;Check Protocol type
	lbne	CheckRXABFlag			;Check which buffer to CLEAR

	ldd	PacketBasePtr
	addd	#ARPHwLength
	xgdx
	ldx	0,x
	cpx	#$0604				;Check Hardware and IP Address
	lbne	CheckRXABFlag			;Check which buffer to CLEAR

	ldd	PacketBasePtr
	addd	#ARPOperation
	xgdx
	ldx	0,x
	cpx	#$0001				;Check if 1 = ARP Request
	beq	YesARPRequest

	cpx	#$0002
	beq	YesARPRespose			;This hardware sent out an ARP request
						; and now processing the info
	lbne	CheckRXABFlag			;Check which buffer to CLEAR

;Now check if it is addressed to this hardware

YesARPRequest:
	ldd	PacketBasePtr
	addd	#ARPTargetIP
	xgdx
	ldx	0,x
	cpx	RAMIPAddress+0			;Check and compare IP address
	lbne	CheckRXABFlag

	ldd	PacketBasePtr
	addd	#ARPTargetIP+2
	xgdx
	ldx	0,x
	cpx	RAMIPAddress+2			;Check and compare IP address
	bne	CheckRXABFlag			;Check which buffer to CLEAR

	movw	#ARPResponse,LANState		;Process ARP request
	rts

YesARPRespose:
	ldd	PacketBasePtr
	addd	#ARPTargetIP
	xgdx
	ldx	0,x
	cpx	RAMIPAddress+0			;Check and compare IP address
	bne	CheckRXABFlag			;Check which buffer to CLEAR

	ldd	PacketBasePtr
	addd	#ARPTargetIP+2
	xgdx
	ldx	0,x
	cpx	RAMIPAddress+2			;Check and compare IP address
	bne	CheckRXABFlag			;Check which buffer to CLEAR

	ldx	#MACAddressMsg
	jsr	OutStr0

	ldd	PacketBasePtr
	addd	#ARPSenderMAC
	xgdx		

	ldy	#6
	jsr	DumpMACIP10

	ldx	#IPAddressMsg
	jsr	OutStr0

	ldd	PacketBasePtr
	addd	#ARPSenderIP
	xgdx
	
	ldy	#4
	jsr	DumpMACIP10

	ldx	#CrLfStr
	jsr	OutStr0	


CheckRXABFlag:
	ldaa	RXABFlag
	bne	ClrRXBCIF

	bset	IEVENT,RXACIF			;clear Flag for next RX
	rts

ClrRXBCIF:
	bset	IEVENT,RXBCIF			;clear Flag for next RX
	rts


DumpMACIP:
	ldaa	#'-'
	jsr	SerOutput0

DumpMACIP10:
	ldaa	1,x+
	jsr	Dump_byte
	dbne	y,DumpMACIP
	rts

FrameReadEx:
	bsr	CheckRXABFlag
	rts

;------------------------------------------------------------------------------
CheckIP:
	ldd	PacketBasePtr
	addd	#packetType			
	xgdx
	ldx	0,x
	cpx	#$0800				;Check if Ethertype = 0x0800 (IP)
	bne	NotIPTCP

	ldd	PacketBasePtr
	addd	#IPProtocol
	xgdx
	ldaa	0,x
	cmpa	#ICMP				;ICMP = 1
	bne	CheckTCP

	movw	#PingResponse,LANState		;Ping request
	rts


CheckTCP:
	cmpa	#TCP				;TCP = 6
	bne	CheckUDP

;Now check if it is addressed to this hardware

	ldd	PacketBasePtr
	addd	#IPDestinationAddress+0		;Check and compare IP address
	xgdx
	ldx	0,x
	cpx	RAMIPAddress+0
	bne	NotIPTCP

	ldd	PacketBasePtr
	addd	#IPDestinationAddress+2		;Check and compare IP address
	xgdx
	ldx	0,x
	cpx	RAMIPAddress+2
	bne	NotIPTCP

	movw	#TCPResponse,LANState		;Process TCP
	rts


CheckUDP:
	cmpa	#UDP				;UDP = $11
	bne	NotIPUDP

	movw	#UDPResponse,LANState		;Process UDP
	rts

NotIPTCP:
	jmp	CheckRXABFlag			;Check which buffer to CLEAR

NotIPUDP:
	jmp	CheckRXABFlag			;Check which buffer to CLEAR

;------------------------------------------------------------------------------
TestARP:
	jsr	ARPRequest

	movb	#1,TXFlag
	jsr	TransmitFrame
	rts

;------------------------------------------------------------------------------
ARPResponseTest:
	ldx	#TXPacketBuff
	ldy	#ARP_test			;<-----This is a Test

	ldd	#ABSize
	std	TXWriteLen			;Update how many bytes to transmit
	bra	ARPLp

ARPRequest:
	ldx	#TXPacketBuff
	ldy	#Msg_test			;<-----This is a Test
	ldd	#BSize
	std	TXWriteLen			;Update how many bytes to transmit

ARPLp:						;Udate Transmit buffer
	movb	1,y+,1,x+
	dbne	d,ARPLp
	rts

;=============================================================================
ARPResponse:
	bsr	CheckARPRes
	jsr	goSendFrame			;TXFlag is set here

	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	rts

CheckARPRes:
	ldd	PacketBasePtr
	addd	#ARPSenderMAC			;Copy Original Source Address as Distanation Address
	xgdx

	ldy	#TXPacketBuff
	ldab	#3
	jsr	WriteBuff

	ldx	#RAMMAC+0			;Source Address (this hardware)
	ldy	#TXPacketBuff+6
	ldab	#3
	jsr	WriteBuff

	movw	#$0806,TXPacketBuff+12		;Ethertype = ARP
	movw	#$0001,TXPacketBuff+14		;Hardware type = 1 (10Mb Ethernet)
	movw	#$0800,TXPacketBuff+16		;Protocol Type
	movw	#$0604,TXPacketBuff+18		;Length of Hardware and protocol Address
	movw	#$0002,TXPacketBuff+20		;Opcode = 2 (ARP reply)

	ldx	#RAMMAC+0			;Sender's Hardware and IP Address (this hardware)
	ldy	#TXPacketBuff+22
	ldab	#5
	jsr	WriteBuff

	ldd	PacketBasePtr
	addd	#ARPSenderMAC			;Copy Original Source Target's Hardware and IP Address
	xgdx
	ldy	#TXPacketBuff+32
	ldab	#5
	jsr	WriteBuff

	xgdy					;address now with Reg D
	subd	#TXPacketBuff
	std	TXWriteLen			;How many words to transmit
 	rts

WriteBuff:
	movw	2,x+,2,y+	
	dbne	b,WriteBuff
	rts

;-----------------------------------------------------------------------------------
TCPResponse:
	ldd	PacketBasePtr
	addd	#TCPDestination
	xgdx
	ldd	0,x
	cpd	#TELNET				;Check if Telnet
	beq	YesTELNET	

	cpd	#HTTP				;Check if HTTP
	beq	YesHTTP	

	lbra	CheckRXABFlag			;If it gets here who knows what is the info about

YesHTTP:
	jsr	CheckHttp		;***********************
	rts				;***********************


YesTELNET:
	jsr	CheckTelnet		;***********************
	rts				;***********************
;-----------------------------------------------------------------------------------
ProcessTCP:
	ldd	PacketBasePtr
	addd	#IPProtocol
	xgdx
	ldaa	0,x
	clr	TempVar				;High byte = 0
	staa	TempVar+1			;Low byte = Reg A

	ldd	PacketBasePtr
	ldx	#TCPChecksum
	jsr	CalAddOffset			;Calculate address offset
	movw	#$0000,0,x			;Set TCP Checksum = 0

	ldd	PacketBasePtr
	ldx	#TCPSourcePort			;Word swap the Source to Destination
	ldy	#TCPDestination        		; and Destination to Source
	jsr	CalAddOffset			;Calculate address offset

	ldd	0,x				;Reg X = #PacketBasePtr+TCPSourcePort
	std	CalAdd
	ldd	0,y				;Reg Y = #PacketBasePtr+TCPDestination
	std	0,x
	ldd	CalAdd
	std	0,y

	ldd	PacketBasePtr
	ldx	#TCPSequenceNum			;Copy Sender's TCPSequence to TCPAcknowledgement
	ldy	#TCPAcknowledgement
	jsr	CalAddOffset			;Calculate address offset
	ldd	#2
	jsr	WriteBuff

	ldaa	SessionFlag	;***********
	bne	DonotChangeSeq	;***********

	dey
	inc	0,y				;Increment Senders Sequence Number

DonotChangeSeq:
	ldd	PacketBasePtr
	ldy	#TCPSequenceNum
	jsr	CalAddOffset			;Calculate address offset
	ldx	#TCPSeq				;Copy our Sequence into the Header
	ldd	#2
	jsr	WriteBuff
	rts	

DoTCP1:
	ldd	PacketBasePtr
	ldx	#TCPFlags
	jsr	CalAddOffset			;Calculate address offset
	movb	#ACK+SYN,0,x			;Send ACK + SYN

	ldd	PacketBasePtr
	ldx	#TCPWindow			;Set size of window
	jsr	CalAddOffset			;Calculate address offset
	movw	#$8000,0,x

	ldd	PacketBasePtr
	ldx	#TCPMaxSegSize			;Set size of segment
	jsr	CalAddOffset			;Calculate address offset
	movw	#$03F2,0,x

	ldd	PacketBasePtr
	ldx	#TCPHeaderLength
	jsr	CalAddOffset			;Calculate address offset

	ldab	#$60				;6bytes * 4 = 24
	lbra	TCPCRC

DoTCP2:
	ldd	PacketBasePtr
	ldx	#TCPFlags
	jsr	CalAddOffset			;Calculate address offset
	movb	#ACK+PSH,0,x			;Send ACK + PSH

	ldd	PacketBasePtr
	ldx	#TCPWindow			;Set size of window
	jsr	CalAddOffset			;Calculate address offset
	movw	#$8000,0,x

	ldd	PacketBasePtr
	ldx	#TCPHeaderLength
	jsr	CalAddOffset			;Calculate address offset

	ldab	#$50				;5bytes * 4 = 20
	bra	TCPCRC

DoTCP3:
	ldd	PacketBasePtr
	ldx	#TCPFlags
	jsr	CalAddOffset			;Calculate address offset
	movb	#ACK,0,x			;Send ACK

	ldd	PacketBasePtr
	ldx	#TCPWindow			;Set size of window
	jsr	CalAddOffset			;Calculate address offset
	movw	#$8000,0,x

	ldd	PacketBasePtr
	ldx	#TCPHeaderLength
	jsr	CalAddOffset			;Calculate address offset

	ldab	#$50				;5bytes * 4 = 20
	bra	TCPCRC

DoTCP4:
	ldd	PacketBasePtr
	ldx	#TCPFlags
	jsr	CalAddOffset			;Calculate address offset
	movb	#ACK+FIN,0,x			;Send ACK + FIN

	ldd	PacketBasePtr
	ldx	#TCPWindow			;Set size of window
	jsr	CalAddOffset			;Calculate address offset
	movw	#$8000,0,x

	ldd	PacketBasePtr
	ldx	#TCPHeaderLength
	jsr	CalAddOffset			;Calculate address offset

	ldab	#$50				;5bytes * 4 = 20
	bra	TCPCRC

DoTCP5:
	ldd	PacketBasePtr
	ldx	#TCPFlags
	jsr	CalAddOffset			;Calculate address offset
	movb	#ACK+RST,0,x			;Send ACK + RST

	ldd	PacketBasePtr
	ldx	#TCPWindow			;Set size of window
	jsr	CalAddOffset			;Calculate address offset
	movw	#$8000,0,x

	ldd	PacketBasePtr
	ldx	#TCPHeaderLength
	jsr	CalAddOffset			;Calculate address offset

	ldab	#$50				;5bytes * 4 = 20
	bra	TCPCRC


TCPCRC:
	jsr	FinishTCPCRC
	rts

FinishTCPCRC:
	stab	0,x
	lsrb					;Shift right 4 times
	lsrb
	lsrb
	lsrb
	andb	#$0F
	ldaa	#4
	mul					;TCPHeaderLength/16  * 4 = ? bytes Reg B = multiples
	clra

	pshd

	addd	CharCounter			;Add in how many bytes of DATA to the header less Header Lenght
	addd	TempVar				;Add IP Protocol + Header Lenght
	std	TempVar

	puld
	addd	CharCounter			;Add in how many bytes of DATA to the header less Header Lenght
	addd	#8				;Include Sender's IP and Source IP to CRC

	lsrd					;Divide by 2
	xgdy					;Exchange D with Y

	ldd	PacketBasePtr
	addd	#IPSourceAddress		;Start of Data to CRC
	xgdx
	jsr	CalCRC

	addd	TempVar
	bcs	TCPCarry
	bra	NoTCPCarry

TCPCarry:
	addd	#1

NoTCPCarry:
	coma
	comb
	xgdx					;Save Checksum in Reg X
	ldd	PacketBasePtr
	addd	#TCPChecksum
	xgdx
	std	0,x				;Save checksum	
	rts

TCPSeq:		dc.w	$0000, $024E

;------------------------------------------------------------------------------
CheckWhichRXBuff:
	ldaa	RXABFlag			;Check which buffer
	bne	RXBBuff10

	ldx	#RXAPacketBuff
	ldy	#TXPacketBuff

;Lenght of DATA to copy
	ldd	TXWriteLen

DoCOPYRXA:
	movb	1,x+,1,y+	
	dbne	d,DoCOPYRXA

	bset	IEVENT,RXACIF			;clear Flag for next RX
	movb	#1,TXFlag
	rts

RXBBuff10:
	ldx	#RXBPacketBuff
	ldy	#TXPacketBuff

;Lenght of DATA to copy
	ldd	TXWriteLen

DoCOPYRXB:
	movw	1,x+,1,y+	
	dbne	d,DoCOPYRXB

	bset	IEVENT,RXBCIF			;clear Flag for next RX
	movb	#1,TXFlag
	rts


;------------------------------------------------------------------------------
UDPResponse:
	jsr	ProcessUDPRes
	jsr	CheckWhichBuff

	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	rts

ProcessUDPRes:
	ldd	PacketBasePtr
	addd	#IPProtocol
	xgdx
	ldaa	0,x
	clr	TempVar				;High byte = 0
	staa	TempVar+1			;Low byte = Reg A

	ldd	PacketBasePtr
	addd	#UDPLength			;Add UDP length	+ IP Protocol
	xgdx
	ldd	0,x
	addd	TempVar
	std	TempVar				;Checksum looks okay here

	ldd	PacketBasePtr
	addd	#IPChecksum			;Initialize IP checksum to 0
	xgdx
	ldd	#$0000
	std	0,x

	ldd	PacketBasePtr
	ldx	#IPSourceAddress		;Copy original source IP to Destination IP
	ldy	#IPDestinationAddress
	jsr	CalAddOffset			;Calculate address offset
	ldd	#2
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#IPSourceAddress
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMIPAddress			;our IP Address as source 
	ldd	#2
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldx	#packetSource			;Move original MAC address source as MAC address destination 
	ldy	#packetDestination
	jsr	CalAddOffset			;Calculate address offset
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#packetSource
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMMAC				;Move our MAC address to source
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldx	#IPVersion			;Start of DATA to added
	jsr	CalAddOffset			;Calculate address offset
	ldy	#20/2
	jsr	CalCRC				;Go calculate CRC
	coma
	comb
	xgdy					;Save Reg D in Y
	ldd	PacketBasePtr
	addd	#IPChecksum
	xgdy					;Restore D, Y = IPChecksum
	std	0,y				;Save Checksum into memory

;*****
	ldd	PacketBasePtr
	ldx	#UDPSource			;Word swap the Source to Destination
	ldy	#UDPDestination        		; and Destination to Source
	jsr	CalAddOffset			;Calculate address offset

	ldd	0,x				;Reg X = #PacketBasePtr+UDPSource
	std	CalAdd
	ldd	0,y				;Reg Y = #PacketBasePtr+UDPDestination
	std	0,x
	ldd	CalAdd
	std	0,y

	ldd	PacketBasePtr
	addd	#UDPChecksum			;Initialize UDP checksum to 0 before CRC calculation
	xgdx
	ldd	#$0000
	std	0,x

	ldd	PacketBasePtr
	addd	#IPPacketLength			;ICMP packet length
	xgdy
	ldd	0,y
	subd	#20-8

;The CRC consist of this IP, DA IP, IP protocol, UPD lenght and the DATA

	lsrd					;divide by 2
	xgdy					;Result now in Reg Y

	ldd	PacketBasePtr
	addd	#IPSourceAddress		;Start of Data to CRC
	xgdx
	jsr	CalCRC

	addd	TempVar
	bcs	UDPCarry
	bra	NoUDPCarry

UDPCarry:
	addd	#1

NoUDPCarry:
	coma
	comb
	xgdx					;Save Checksum in Reg X
	ldd	PacketBasePtr
	addd	#UDPChecksum
	xgdx
	std	0,x				;Save checksum	
	rts

;------------------------------------------------------------------------------
PingResponse:
	ldaa	TCPIPFlag
	psha

	movb	#0,TCPIPFlag			;Clear for Ping Response

	jsr	ProcessIP
	jsr	CheckWhichBuff			;TXFlag is set here

	pula
	staa	TCPIPFlag

	movw	#ProcessFrameBuff,LANState	;go back to polling Frame buffer
	rts


ProcessIP:
	ldd	PacketBasePtr
	addd	#IPChecksum			;Initialize IP checksum to 0
	xgdx
	movw	#00,0,x	

	ldd	PacketBasePtr
	ldx	#IPSourceAddress		;Copy original source IP to Destination IP
	ldy	#IPDestinationAddress
	jsr	CalAddOffset			;Calculate address offset
	ldd	#2
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#IPSourceAddress
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMIPAddress			;our IP Address as source 
	ldd	#2
	jsr	WriteBuff

;Check if TCP
	ldaa	TCPIPFlag
	bne	TCP10

	ldd	PacketBasePtr
	addd	#ICMPChecksum			;ICMP checksum to 0
	xgdx
	movw	#00,0,x	

	ldd	PacketBasePtr
	addd	#ICMPType			;Clear Type and Code
	xgdx
	movw	#00,0,x	

TCP10:
	ldd	PacketBasePtr
	ldx	#packetSource			;Move original MAC address source as MAC address destination 
	ldy	#packetDestination
	jsr	CalAddOffset			;Calculate address offset
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldy	#packetSource
	jsr	CalAddOffset			;Calculate address offset
	ldx	#RAMMAC				;Move our MAC address to source
	ldd	#3
	jsr	WriteBuff

	ldd	PacketBasePtr
	ldx	#IPVersion			;Start of DATA to added
	jsr	CalAddOffset			;Calculate address offset
	ldy	#20/2
	jsr	CalCRC				;Go calculate CRC
	coma
	comb
	xgdy					;Save Reg D in Y
	ldd	PacketBasePtr
	addd	#IPChecksum
	xgdy					;Restore D, Y = IPChecksum
	std	0,y				;Save Checksum into memory

;Calculate Checksum by the amount in Reg Y
	ldd	PacketBasePtr
	addd	#IPPacketLength			;Get packet length in IP header
	xgdy
	ldd	0,y
	subd	#20
	lsrd					;divide by 2
	xgdy					;Result now in Reg Y

	ldd	PacketBasePtr
	addd	#IPData				
	xgdx					;Start of Data in X
	jsr	CalCRC
	coma
	comb
	xgdx					;Save checksum and exchange with reg X

	ldaa	TCPIPFlag
	bne	ProcessIPEx

	ldd	PacketBasePtr			;Now save it into the checksum
	addd	#ICMPChecksum
	xgdx
	std	0,x

ProcessIPEx:
	rts

;------------------------------------------------------------------------------
CalAddOffset:					;Calculate address offset
	pshd
	stx	CalAdd
	addd	CalAdd
	xgdx

	puld
	sty	CalAdd
	addd	CalAdd
	xgdy
	rts	
;------------------------------------------------------------------------------
CalCRC:
	ldd	2,x+
	dey

CalCRCLp:
	addd	2,x+
	bcs	AddCarry
	bra	NoCarry

AddCarry:
	addd	#1

NoCarry:
	dbne	y,CalCRCLp
	rts

;------------------------------------------------------------------------------
goSendFrame:
	ldaa	RXABFlag			;Check which buffer
	bne	RXBLen

	ldd	RXAEFP				;Get End of RXA buffer
	bset	IEVENT,RXACIF			;clear Flag for next RX
	bra	RXALen

RXBLen:
	ldd	RXBEFP				;Get End of RXB buffer
	bset	IEVENT,RXBCIF			;clear Flag for next RX

RXALen:
	std	TXWriteLen
	movb	#1,TXFlag			;Set for Transmit
	rts

;------------------------------------------------------------------------------
CheckWhichBuff:
	ldaa	RXABFlag			;Check which buffer
	bne	RXBBuff

RXABuff:
	ldx	#RXAPacketBuff
	ldy	#TXPacketBuff

;Lenght of DATA to copy
	ldd	RXAEFP				;Get End of RXA buffer
	std	TXWriteLen
	jsr	WriteBuff			;go copy

	bset	IEVENT,RXACIF			;clear Flag for next RX
	movb	#1,TXFlag
	rts

RXBBuff:
	ldx	#RXBPacketBuff
	ldy	#TXPacketBuff

;Lenght of DATA to copy
	ldd	RXBEFP				;Get End of RXB buffer
	std	TXWriteLen			
	jsr	WriteBuff			;go copy

	bset	IEVENT,RXBCIF			;clear Flag for next RX
	movb	#1,TXFlag
	rts

;------------------------------------------------------------------------------
TransmitFrame:
	ldaa	TXFlag
	beq	TransmitFrameEx

	ldd	TXWriteLen
	std	TXEFP				;store to end of frame

	movb	#CMDStart,TXCTS			;Send DATA out
	clr	TXFlag				;Clear to Transmit next frame

TransmitFrameEx:
	rts

;------------------------------------------------------------------------------
CopyMSG:
	ldaa	1,x+
	beq	EOF

	staa	1,y+

	ldd	CharCounter
	addd	#1
	std	CharCounter			;Update Char counter

	bra	CopyMSG

EOF:
	rts

	ldx	#Msg_test

;------------------------------------------------------------------------------

LFeed:		dc.b	$0c,0
CrLfStr:	dc.b	$0d,$0a,$0

Msg_Data:	dc.b	$0a,$0d,"Getting Data",$0
Msg_Data1:	dc.b	$0a,$0d,"Dumping to SCI - ",$0
Msg_Init:		dc.b	$0a,$0d,"Adapt9S12NE64 EPHY and EMAC Initialized",$0

FrameErrLongMsg:	dc.b	$0d,$0a,"Error - Frame size > 1508 bytes",$0d,$0a,$0
FrameErrNullMsg:	dc.b	$0d,$0a,"Error - Frame size = 0",$0d,$0a,$0
NotARPMsg:		dc.b	$0d,$0a,"Error - Not ARP, IP or UDP Packet",$0d,$0a,$0
PingARPMsg:		dc.b	$0d,$0a,"Being Ping",$0d,$0a,$0

APingARPMsg:		dc.b	$0d,$0a,"Being Ping - A",$0d,$0a,$0
BPingARPMsg:		dc.b	$0d,$0a,"Being Ping - B",$0d,$0a,$0

UDPARPMsg:		dc.b	$0d,$0a,"Being UDPed ",$0d,$0a,$0
TCPMsg:			dc.b	$0d,$0a,"Being TCPed ",$0d,$0a,$0	

TCP0Msg:		dc.b	$0d,$0a,"Begin TCP Session",$0d,$0a,$0	
TCP1Msg:		dc.b	$0d,$0a,"1st Process ",$0d,$0a,$0	
TCP2Msg:		dc.b	$0d,$0a,"2nd Process ",$0d,$0a,$0	
TCP3Msg:		dc.b	$0d,$0a,"3rd Process ",$0d,$0a,$0	
TCP4Msg:		dc.b	$0d,$0a,"Calculating CRC ",$0d,$0a,$0


MsgBase100T:		dc.b	$0d,$0a,"Connecting at 100BaseT",$0d,$0a,$0
MsgBase10T:		dc.b	$0d,$0a,"Connecting at 10BaseT",$0d,$0a,$0

MACAddressMsg:		dc.b	$0d,$0a,"Returning MAC address = ",$0
IPAddressMsg:		dc.b	$0d,$0a,"Returning IP address = ",$0

CurrentMACMsg:		dc.b	$0d,$0a,"Current MAC address = ",$0

EXOPL:		equ	255
DO:		equ	253
WILL:		equ	251
ECHO:		equ	1

TestTelnetMsg:	dc.b	$0d,$0a
		dc.b	"--------------------------------",$0d,$0a
		dc.b	"Welcome to Technological Arts   ",$0d,$0a
		dc.b	"This is a test                  ",$0d,$0a
		dc.b	$30,EXOPL,WILL,ECHO,0

FEEPROM:SECTION

;*	MAC address MAC1-MAC2-MAC3-MAC4-MAC5-MAC6	*

MAC_Address:	dc.b	$56	;MAC6
		dc.b	$34	;MAC5
		dc.b	$12	;MAC4
		dc.b	$00	;MAC3
		dc.b	$00	;MAC2
		dc.b	$00	;MAC1

IP_Address:	dc.b	192	;IP4
		dc.b	168	;IP3
		dc.b	2	;IP2
		dc.b	7	;IP1

Msg_test: 	dc.b	$FF,$FF,$FF,$FF,$FF,$FF		;MAC Distanation Address
		dc.b	$56,$34,$12,$00,$00,$00		;MAC Source Address - This hardware

		dc.b	$08,$06				;Ethertype = ARP
		dc.b	$00,$01				;Hardware Type = 1 (10Mb Ethernet)
		dc.b	$08,$00				;Protocol Type
		dc.b	$06,$04				;Lenght of Hardware and IP address
		dc.b	$00,$01				;Opcode = 1 (ARP request)

		dc.b	$56,$34,$12,$00,$00,$00		;MAC Address - This Hardware
		dc.b	192,168,2,7			;IP Address - Work

		dc.b	$00,$00,$00,$00,$00,$00		;Any Address
		dc.b	192,168,2,23			;IP Address - Work


MsgEnd:	equ	*
BSize:	equ	(MsgEnd-Msg_test)

ARP_test:
		dc.b	$00,$05,$5D,$FB,$E0,$F5		;MAC Distanation Address
		dc.b	$56,$34,$12,$00,$00,$00		;MAC Source Address - This hardware

		dc.b	$08,$06				;Ethertype = ARP
		dc.b	$00,$01				;Hardware Type = 1 (10Mb Ethernet)
		dc.b	$08,$00				;Protocol Type
		dc.b	$06,$04				;Lenght of Hardware and IP address
		dc.b	$00,$02				;Opcode = 2 (ARP response)

		dc.b	$56,$34,$12,$00,$00,$00		;MAC Address - This Hardware
		dc.b	192,168,2,7			;IP Address - Home 

		dc.b	$00,$E0,$18,$A6,$0F,$6F		;Any Address - Work
		dc.b	192,168,2,23			;IP Address - Work

;		dc.b	$00,$05,$5D,$FB,$E0,$F5		;Any Address - Home
;		dc.b	192,168,0,1			;IP Address - Home

ARP_testEnd:	equ	*
ABSize:		equ	(ARP_testEnd-ARP_test)

TotMsg		equ	*
CSize		equ	(TotMsg-MAC_Address)
	END

