;PacketFrame.inc
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*
*
*Author: Exequiel Rarama for the ADAPT9S12NE64
*******************************************************************************

;------------------------------------------------------------------------------------
;*******EPHY***********
;EPHYCTL0 register bits definition
;
EPHYEN:	EQU	$80		;EPHY Enable bit
ANDIS:		equ	$40		
DIS100:		equ	$20
DIS10:		equ	$10
LEDEN:		equ	$08
EPHYWAI:	equ	$04
EPHYIEN:	equ	$01

;EPHYSR register bits definition
_100DIS:		equ	$20
_10DIS:		equ	$10
EPHYIF:		equ	$01


;*******MAC***********
;NETCTL register bits definition
;
EMACE:		equ	$80		;Enable MAC bit
MLB:		equ	$04		;MAC Loop Back bit
FDX:		equ	$02		;Full duplex = 1, Half duplex = 0

;RXCTS register bits definition
;
RXACT:		equ	$80		;Receiver Active Status
RFCE:		equ	$10		;Reception flow control enable
PROM:		equ	$04		;Promiscuous mode
CONMC:		equ	$02		;Conditional Multicast
BCREJ:		equ	$01		;Broadcast Reject

;TXCTS register bits definition
;
TXACT:		equ	$80		;Transmitter Active status
CSLF:		equ	$20		;Carrier sense Lost flag
PTRC:		equ	$10		;Pause timer register control
SSB:		equ	$08		;Single Slot backoff

CMDStart:	equ	%00000001	;Start transmition
CMDPause:	equ	%00000010	;Pause transmition
CMDAbort:	equ	%00000011	;Abort transmition

;ECTCTL register bits definition
;
PET:		equ	$80		;Programmable Ethertype
EMW:		equ	$10		;
IPV6:		equ	$08
ARP:		equ	$04
IPV4:		equ	$02
IEEE:		equ	$01

;IEVENT interrupt event register bits definition
RFCIF:		equ	$80
BREIF:		equ	$20
RXEIF:		equ	$10
RXAOIF:		equ	$08
RXBOIF:		equ	$04
RXACIF:		equ	$02
RXBCIF:		equ	$01

MMCIF:		equ	$80
LCIF:		equ	$20
ECIF:		equ	$10
TXCIF:		equ	$02

;IMASK Interrupt mask register bits definition
;
RFCIE:		equ	$80
BREIE:		equ	$20
RXEIE:		equ	$10

RXAOIE:		equ	$80
RXBOIE:		equ	$40
RXACIE:		equ	$20
RXBCIE:		equ	$10

MMCIE:		equ	$80
LCIE:		equ	$10
ECIE:		equ	$08
TXCIE:		equ	$02

;SWRST Software Reset register register bits definition
;
MAXRST:	equ	$80
;------------------------------------------------------------------------------------


RXAPacketBuff:		equ	$2000
RXBPacketBuff:		equ	$2600
TXPacketBuff:		equ	$2C00			;Make Transmit Buffer

RXABBaseAddress:	equ	$0000
packetDestination:		equ	RXABBaseAddress+0	;6 bytes - MAC values of Destination address
packetSource:		equ	RXABBaseAddress+6	;6 bytes - MAC values of source address
packetType:		equ	RXABBaseAddress+12	;2 bytes - of LLC data

;ARP Packet
;
ARPHwType:		equ	RXABBaseAddress+14	;2 bytes - Hardware Type
ARPPrType:		equ	RXABBaseAddress+16	;2 bytes - Protocol Type
ARPHwLength:		equ	RXABBaseAddress+18	;1 byte - Hardware address length
ARPPrLength:		equ	RXABBaseAddress+19	;1 byte - Protocol address length
ARPOperation:		equ	RXABBaseAddress+20	;2 bytes - ARP operation (1=request, 2=reply)
ARPSenderMAC:		equ	RXABBaseAddress+22	;6 bytes - Senders/Source MAC address
ARPSenderIP:		equ	RXABBaseAddress+28	;4 bytes - Senders/Source IP address
ARPTargetMAC:		equ	RXABBaseAddress+32	;6 byters - Target/Destination MAC address
ARPTargetIP:		equ	RXABBaseAddress+38	;4 bytes - Target/Destination IP address

;IP header
;
IPVersion:		equ	RXABBaseAddress+14	;1 byte - IP version and header length
IPServiceType:		equ	RXABBaseAddress+15	;1 byte - IP type of service
IPPacketLength:		equ	RXABBaseAddress+16	;2 bytes - Packet Length (Length - Header_Lenght)
IPDatagramID:		equ	RXABBaseAddress+18	;2 bytes - Datagram ID
IPFragOffset:		equ	RXABBaseAddress+20	;2 bytes - Fragment Offset
IPTTL:			equ	RXABBaseAddress+22	;1 byte - Time To Live
IPProtocol:		equ	RXABBaseAddress+23	;1 byte - Protocol (ICMP = 1, TCP = 6, EGP =8, UDP = $11)
IPChecksum:		equ	RXABBaseAddress+24	;2 bytes - Header checksum
IPSourceAddress:		equ	RXABBaseAddress+26	;4 bytes - Senders/Source IP address
IPDestinationAddress:	equ	RXABBaseAddress+30	;4 bytes - Target/Destination IP address
IPData:			equ	RXABBaseAddress+34	;What are left = Data

;IP types
;
ICMP:			equ	1			;ICMP packets
TCP:			equ	6			;TCP packets
EGP:			equ	8			;EGP packets
UDP:			equ	$11			;UDP packets

;TCP header

TCPSourcePort:		equ	RXABBaseAddress+34	;2 byte - Source Port
TCPDestination:		equ	RXABBaseAddress+36	;2 byte - Destination Port
TCPSequenceNum:	equ	RXABBaseAddress+38	;4 byte - Sequence
TCPAcknowledgement:	equ	RXABBaseAddress+42	;4 byte - Acknowledge
TCPHeaderLength:		equ	RXABBaseAddress+46	;1 byte high nibble - Header length
TCPFlags:		equ	RXABBaseAddress+47	;1 byte - Flags
TCPWindow:		equ	RXABBaseAddress+48	;2 byte - Window
TCPChecksum:		equ	RXABBaseAddress+50	;2 byte - Checksum
TCPUrgentPtr:		equ	RXABBaseAddress+52	;2 byte - Urgent Pointer
TCPPadding:		equ	RXABBaseAddress+54	;2 byte - Padding
TCPMaxSegSize:		equ	RXABBaseAddress+56	;2 byte - Source Port
TCPSackPermit:		equ	RXABBaseAddress+58	;2 byte - Sack Permitted
TCPData:		equ	RXABBaseAddress+60	;2 byte - Source Port

;TCP Types
HTTP:			equ	80			;Port 80
TELNET:			equ	23			;Port 23
UDPPort:			equ	137			;Port 137

;TCP Flags
ACK:			equ	$10			;Acknowledge
PSH:			equ	$08			;Push
RST:			equ	$04			;Reset
SYN:			equ	$02			;Synchronize
FIN:			equ	$01			;Finish

;ICMP header
;
ICMPType:		equ	IPData+0		;1 byte - 0=reply, 8=request, others=who cares
ICMPCode:		equ	IPData+1		;1 byte - Code
ICMPChecksum:		equ	IPData+2		;2 bytes - Checksum of header + Data
ICMPID:			equ	IPData+4		;2 bytes - Message ID
ICMPSequence:		equ	IPData+6		;2 bytes - Sequence number

;UDP header
;
UDPSource:		equ	IPData+0		;2 bytes - Source UDP port number
UDPDestination:		equ	IPData+2		;2 bytes - Destination UDP port number
UDPLength:		equ	IPData+4		;2 bytes - Length of UDP header + Data
UDPChecksum:		equ	IPData+6		;2 bytes - Checksum
UDPData:		equ	IPData+8		;Start of Data

